/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.strategies;

import elgato.infrastructure.strategies.AdjustmentStrategy;
import elgato.infrastructure.util.FastMath;

public class PercentageAdjustmentStrategy
implements AdjustmentStrategy {
    private final int stepSizeLog10;

    public PercentageAdjustmentStrategy() {
        this(10);
    }

    public PercentageAdjustmentStrategy(int n) {
        this.stepSizeLog10 = FastMath.log10(n) - 1;
    }

    public long stepUp(long l) {
        return this.doStep(l, false, 1);
    }

    public long stepDown(long l) {
        return this.doStep(l, true, 1);
    }

    private long doStep(long l, boolean bl, int n) {
        long l2 = this.calcStepAndDivide(l, n);
        long l3 = l2 / 10L;
        long l4 = bl ? l - l3 : l + l3;
        long l5 = this.calcStepAndDivide(l4, n);
        if (l5 < l2) {
            return l4;
        }
        return bl ? l - l2 : l + l2;
    }

    private long calcStepAndDivide(long l, int n) {
        return this.calcStep(l) / (long)n;
    }

    private long calcStep(long l) {
        long l2 = Math.abs(l / 1000L);
        if (l2 < 1L) {
            l2 = 1L;
        }
        int n = FastMath.log10((int)l2) - this.stepSizeLog10;
        return FastMath.pow10(n + 3);
    }

    public long scroll(long l, int n) {
        int n2;
        boolean bl = n < 0;
        for (int i = n2 = Math.abs(n); i > 0; --i) {
            l = this.doStep(l, bl, 10);
        }
        return l;
    }
}

