/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.strategies;

import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import java.text.NumberFormat;

public class WattStrategy
extends NumberFieldStrategy {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$strategies$WattStrategy == null ? (class$elgato$infrastructure$strategies$WattStrategy = WattStrategy.class$("elgato.infrastructure.strategies.WattStrategy")) : class$elgato$infrastructure$strategies$WattStrategy);
    private static final String UNITS = "W";
    private static final int scaleUnits0Index = 8;
    private static final String[] scaleUnits = new String[]{"yW", "zW", "aW", "fW", "pW", "nW", "\u03bcW", "mW", "W", "kW", "MW", "GW"};
    private final int decimalPlaces;
    private final int exponent;
    static /* synthetic */ Class class$elgato$infrastructure$strategies$WattStrategy;

    public WattStrategy(int n, int n2) {
        super(UNITS);
        this.decimalPlaces = n;
        this.exponent = n2;
    }

    public String format(long l) {
        String[] stringArray = this.formatWithUnits(l, new String[2]);
        return stringArray[0] + " " + stringArray[1];
    }

    public String[] formatWithUnits(long l, String[] stringArray) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(this.decimalPlaces);
        numberFormat.setMinimumFractionDigits(this.decimalPlaces);
        numberFormat.setGroupingUsed(false);
        stringArray[0] = numberFormat.format((double)l / 1000.0);
        int n = this.exponent / 3 + 8;
        if ((double)l / 1000.0 < 1.0 && (double)l / 1000.0 > 0.0) {
            --n;
            stringArray[0] = numberFormat.format(l);
        }
        if (n < 0 || n >= scaleUnits.length) {
            stringArray[1] = "ERR";
            logger.error("formatWithUnits(): Invalid exponent " + this.exponent);
        } else {
            stringArray[1] = scaleUnits[n];
        }
        return stringArray;
    }

    public boolean decimalEntryAllowed() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

