/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.systemFunctions;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.measurement.MeasurementReader;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Platform;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.WrappedTimer;
import elgato.measurement.powerSupply.PowerSupplyMeasurement;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class BacklightAutoDimmer {
    static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$systemFunctions$BacklightAutoDimmer == null ? (class$elgato$infrastructure$systemFunctions$BacklightAutoDimmer = BacklightAutoDimmer.class$("elgato.infrastructure.systemFunctions.BacklightAutoDimmer")) : class$elgato$infrastructure$systemFunctions$BacklightAutoDimmer);
    State state;
    static /* synthetic */ Class class$elgato$infrastructure$systemFunctions$BacklightAutoDimmer;
    static /* synthetic */ Class class$elgato$measurement$powerSupply$PowerSupplyMeasurement;

    public BacklightAutoDimmer() {
        this.setState(new ACPower());
    }

    void setState(State state) {
        if (logger.isDebugEnabled()) {
            logger.debug("setState() " + this.state + " => " + state);
        }
        if (this.state != null) {
            this.state.exit();
        }
        this.state = state;
        this.state.enter();
    }

    void setStatus(String string) {
        MeasurementFactory.instance().getScreenManager().getStatusHandler().setStatus(string);
    }

    public void installPowerSupplyMeasurementListener() {
        MeasurementListener measurementListener = new MeasurementListener(){
            boolean initialized;
            boolean lastStateWasACPower;

            public void measurementReceived(Measurement measurement) {
                PowerSupplyMeasurement powerSupplyMeasurement = (PowerSupplyMeasurement)measurement;
                boolean bl = powerSupplyMeasurement.getBooleanReadingValue(0);
                if (this.initialized && this.lastStateWasACPower == bl) {
                    return;
                }
                if (bl) {
                    BacklightAutoDimmer.this.state.onAcPower();
                } else {
                    BacklightAutoDimmer.this.state.onBattery();
                }
                this.initialized = true;
                this.lastStateWasACPower = bl;
            }
        };
        MeasurementReader measurementReader = MeasurementFactory.instance().getMeasurementReader();
        measurementReader.addMeasurementListener(measurementListener, class$elgato$measurement$powerSupply$PowerSupplyMeasurement == null ? (class$elgato$measurement$powerSupply$PowerSupplyMeasurement = BacklightAutoDimmer.class$("elgato.measurement.powerSupply.PowerSupplyMeasurement")) : class$elgato$measurement$powerSupply$PowerSupplyMeasurement);
    }

    public void keyPressed() {
        this.state.keyPressed();
    }

    public String toString() {
        return "State=" + this.state.getClass().getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BacklightOff
    extends BacklightOffBase {
        public BacklightOff(State state) {
            super(state);
        }

        public void enter() {
            if (logger.isDebugEnabled()) {
                logger.debug("BacklightOff.enter()");
            }
        }

        public void exit() {
            if (logger.isDebugEnabled()) {
                logger.debug("BacklightOff.exit()");
            }
        }
    }

    private class BacklightFadingOut
    extends BacklightOffBase {
        private static final int FADEOUT_TIME = 800;
        private static final int TICK_TIME = 100;
        private WrappedTimer timer;
        int fadeStep;
        private int savedBrightness;

        public BacklightFadingOut(State state) {
            super(state);
            this.timer = new WrappedTimer(100, new ActionListener(this, BacklightAutoDimmer.this){
                private final /* synthetic */ BacklightAutoDimmer val$this$0;
                private final /* synthetic */ BacklightFadingOut this$1;
                {
                    this.this$1 = backlightFadingOut;
                    this.val$this$0 = backlightAutoDimmer;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Platform.getDisplayBrightness();
                    if ((n -= this.this$1.fadeStep) > 0) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = n >> 3; i > 0; --i) {
                            stringBuffer.append('=');
                        }
                        stringBuffer.append('>');
                        BacklightFadingOut.access$400(this.this$1).setStatus(stringBuffer.toString());
                        Platform.setDisplayBrightness(n);
                    } else {
                        Platform.setDisplayBacklightEnabled(false);
                        BacklightFadingOut.access$400(this.this$1).setStatus(Text.Backlight_automatically_turned_off);
                        BacklightFadingOut.access$400(this.this$1).setState(BacklightFadingOut.access$400(this.this$1).new BacklightOff(this.this$1.activeState));
                    }
                }
            });
        }

        public void enter() {
            this.savedBrightness = Platform.getDisplayBrightness();
            int n = 8;
            this.fadeStep = this.savedBrightness / n;
            if (logger.isDebugEnabled()) {
                logger.debug("BacklightFadingout.enter() savedBrightness=" + this.savedBrightness + " steps=" + n + " fadeStep=" + this.fadeStep);
            }
            this.timer.start();
        }

        public void exit() {
            if (logger.isDebugEnabled()) {
                logger.debug("BacklightFadingout.exit()");
            }
            this.timer.stop();
            Platform.setDisplayBrightness(this.savedBrightness);
        }

        static /* synthetic */ BacklightAutoDimmer access$400(BacklightFadingOut backlightFadingOut) {
            return backlightFadingOut.BacklightAutoDimmer.this;
        }
    }

    private abstract class BacklightOffBase
    implements State {
        protected State activeState;

        public BacklightOffBase(State state) {
            this.activeState = state;
        }

        public void keyPressed() {
            BacklightAutoDimmer.this.setStatus("");
            Platform.setDisplayBacklightEnabled(true);
            BacklightAutoDimmer.this.setState(this.activeState);
        }

        public void onAcPower() {
            this.activeState = new ACPower();
        }

        public void onBattery() {
            this.activeState = new Battery();
        }

        public abstract /* synthetic */ void exit();

        public abstract /* synthetic */ void enter();
    }

    private class Battery
    extends TimerRunningStateBase {
        private Battery() {
        }

        public void onAcPower() {
            BacklightAutoDimmer.this.setState(new ACPower());
        }

        public void onBattery() {
        }

        protected ValueInterface getAutoDimSetting() {
            return SystemMeasurementSettings.instance().getBacklightAutoDimBattery();
        }
    }

    private class ACPower
    extends TimerRunningStateBase {
        private ACPower() {
        }

        public void onAcPower() {
        }

        public void onBattery() {
            BacklightAutoDimmer.this.setState(new Battery());
        }

        protected ValueInterface getAutoDimSetting() {
            return SystemMeasurementSettings.instance().getBacklightAutoDimAC();
        }
    }

    private abstract class TimerRunningStateBase
    implements State {
        private static final int WARN_SECS = 5;
        private boolean enableTimer;
        WrappedTimer timer;
        WrappedTimer messageTimer;
        private int timerDelay;
        long dimAt;
        boolean showingCountdownMessage;
        private final ValueListener dimSettingListener = new ValueListener(){
            private final String listenerName = "dimSettingListener";

            public String getListenerName() {
                return "dimSettingListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                timer.stop();
                messageTimer.stop();
                this.setTimers();
                this.restartTimer();
            }
        };

        private TimerRunningStateBase() {
        }

        public void enter() {
            if (logger.isDebugEnabled()) {
                logger.debug("TimerRunningStateBase.enter()");
            }
            this.timer = new WrappedTimer(0, new ActionListener(this){
                private final /* synthetic */ TimerRunningStateBase this$1;
                {
                    this.this$1 = timerRunningStateBase;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TimerRunningStateBase.access$100(this.this$1).setState(this.this$1.getBacklightOffState());
                }
            });
            this.messageTimer = new WrappedTimer(0, new ActionListener(this){
                private final /* synthetic */ TimerRunningStateBase this$1;
                {
                    this.this$1 = timerRunningStateBase;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = (int)((this.this$1.dimAt - System.currentTimeMillis()) / 1000L);
                    TimerRunningStateBase.access$100(this.this$1).setStatus(UIHelper.formatMessage(Text.Backlight_turning_off_in_ARG1_seconds_dotdotdot, new String[]{Integer.toString(n)}));
                    this.this$1.showingCountdownMessage = true;
                }
            });
            this.getAutoDimSetting().addValueListener(this.dimSettingListener);
            this.setTimers();
            this.timer.setRepeats(false);
            this.restartTimer();
        }

        public void exit() {
            if (logger.isDebugEnabled()) {
                logger.debug("TimerRunningStateBase.exit()");
            }
            this.timer.stop();
            this.messageTimer.stop();
            this.getAutoDimSetting().removeValueListener(this.dimSettingListener);
        }

        void setTimers() {
            this.timerDelay = this.getAutoDimSetting().intValue();
            if (logger.isDebugEnabled()) {
                logger.debug("TimerRunningStateBase.setTimers() timerDelay=" + this.timerDelay);
            }
            if (this.timerDelay > 0) {
                this.timer.setInitialDelay(this.timerDelay);
                int n = this.timerDelay - 5000;
                if (n < 0) {
                    n = 0;
                }
                this.messageTimer.setInitialDelay(n);
                this.messageTimer.setDelay(1000);
                this.enableTimer = true;
            } else {
                this.enableTimer = false;
            }
        }

        public void keyPressed() {
            this.restartTimer();
            if (this.showingCountdownMessage) {
                BacklightAutoDimmer.this.setStatus("");
                this.showingCountdownMessage = false;
            }
        }

        protected void restartTimer() {
            if (logger.isDebugEnabled()) {
                logger.debug("TimerRunningStateBase.restartTimer()");
            }
            if (this.enableTimer) {
                this.dimAt = System.currentTimeMillis() + (long)this.timerDelay;
                this.timer.restart();
                this.messageTimer.restart();
            }
        }

        State getBacklightOffState() {
            return new BacklightFadingOut(this);
        }

        protected abstract ValueInterface getAutoDimSetting();

        static /* synthetic */ BacklightAutoDimmer access$100(TimerRunningStateBase timerRunningStateBase) {
            return timerRunningStateBase.BacklightAutoDimmer.this;
        }

        public abstract /* synthetic */ void onBattery();

        public abstract /* synthetic */ void onAcPower();
    }

    private static interface State {
        public void enter();

        public void exit();

        public void keyPressed();

        public void onAcPower();

        public void onBattery();
    }
}

