/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.systemFunctions;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandTimeoutException;
import elgato.infrastructure.html.HTMLRenderer;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.ModalKeyManager;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Platform;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.TextMessage;
import elgato.infrastructure.wheel.ScrollWheelEvent;
import elgato.infrastructure.wheel.ScrollWheelListener;
import elgato.infrastructure.wheel.ScrollWheelManager;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import elgato.measurement.powerSupply.PowerSupplyMonitor;
import elgato.measurement.powerSupply.PowerSupplyReader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;

public class BatteryReconditionScreen
extends Screen
implements ScrollWheelListener {
    Logger logger = LogManager.getLogger(class$elgato$infrastructure$systemFunctions$BatteryReconditionScreen == null ? (class$elgato$infrastructure$systemFunctions$BatteryReconditionScreen = BatteryReconditionScreen.class$("elgato.infrastructure.systemFunctions.BatteryReconditionScreen")) : class$elgato$infrastructure$systemFunctions$BatteryReconditionScreen);
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$mainScreens$CautionErrorMessageScreen == null ? (class$elgato$infrastructure$mainScreens$CautionErrorMessageScreen = BatteryReconditionScreen.class$("elgato.infrastructure.mainScreens.CautionErrorMessageScreen")) : class$elgato$infrastructure$mainScreens$CautionErrorMessageScreen).getName());
    private static final HydroBorderPainterConfig BORDER_CONFIG = res.getBorderConfig("border");
    PushButton continueButton;
    PushButton cancelButton;
    HTMLRenderer htmlRenderer = new HTMLRenderer();
    PowerSupplyMonitor.ChangeListener powerSupplyListener;
    boolean reconStarted = false;
    boolean reconditioning = false;
    int currentBrightness;
    Command setApmAutoCommand;
    Command setApmReconditionCommand;
    private Command setApmResponse;
    static int reconditionCounter = 0;
    static /* synthetic */ Class class$elgato$infrastructure$systemFunctions$BatteryReconditionScreen;
    static /* synthetic */ Class class$elgato$infrastructure$mainScreens$CautionErrorMessageScreen;

    public BatteryReconditionScreen() {
        this.cancelButton = new PushButton(Text.Cancel, this.getContextString("system.stats.cancel"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BatteryReconditionScreen.this.setApmResponse(BatteryReconditionScreen.this.setApmAutoCommand);
                }
                catch (CommandTimeoutException commandTimeoutException) {
                    BatteryReconditionScreen.this.logger.error("no response from server for set APM auto");
                }
                catch (InterruptedException interruptedException) {
                    BatteryReconditionScreen.this.logger.error("no response from server for set APM auto");
                }
                PowerSupplyMonitor.instance().removeChangeListener(BatteryReconditionScreen.this.powerSupplyListener);
                if (BatteryReconditionScreen.this.reconditioning) {
                    BatteryReconditionScreen.this.reconStarted = false;
                    BatteryReconditionScreen.this.reconditioning = false;
                    Platform.setDisplayBrightness(BatteryReconditionScreen.this.currentBrightness);
                }
                BatteryReconditionScreen.this.setStatus("");
                BatteryReconditionScreen.this.getScreenManager().popScreen();
            }
        });
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        screenManager.installLeftMenu(new Menu(Text.Battery, new MenuItem[0]));
        screenManager.installRightMenu(this.createRightMenu());
        screenManager.installDisplay(this.createPanel());
        GlobalKeyManager.registerInstance(new ModalKeyManager(this.getScreenManager()){

            public void processKeyPress(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 76: {
                        BatteryReconditionScreen.this.cancelButton.press();
                        break;
                    }
                    case 40: {
                        keyEvent.consume();
                        BatteryReconditionScreen.this.htmlRenderer.scrollPageDown();
                        break;
                    }
                    case 38: {
                        keyEvent.consume();
                        BatteryReconditionScreen.this.htmlRenderer.scrollPageUp();
                        break;
                    }
                    default: {
                        this.processSoftkeyPress(keyEvent);
                    }
                }
            }
        });
        ScrollWheelManager.instance().addScrollWheelListener(this);
        this.setApmAutoCommand = Command.makeSetCommand("APM");
        this.setApmReconditionCommand = Command.makeSetCommand("APM");
        this.setApmAutoCommand.addProperty("pwrMode", "auto");
        this.setApmReconditionCommand.addProperty("pwrMode", "recondition");
    }

    public void uninstallScreen(ScreenManager screenManager) {
        super.uninstallScreen(screenManager);
        GlobalKeyManager.makeInstance(screenManager);
    }

    private JComponent createPanel() {
        this.htmlRenderer.setText(TextMessage.BATTERY_RECONDITION);
        this.htmlRenderer.render();
        return new BorderWrapper(this.htmlRenderer, BORDER_CONFIG, true);
    }

    Menu createRightMenu() {
        if (this.reconditioning) {
            this.continueButton = null;
            this.cancelButton.setText(Text.Abort);
        } else {
            this.continueButton = this.createContinueButton();
            this.cancelButton.setText(Text.Back);
        }
        return new Menu(Text.Recondition, new MenuItem[]{this.continueButton, null, null, null, null, null, this.cancelButton});
    }

    private PushButton createContinueButton() {
        PushButton pushButton = new PushButton(Text.Continue, this.getContextString("system.stats.continue"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatteryReconditionScreen.this.reconStarted = true;
                BatteryReconditionScreen.this.reconditioning = true;
                reconditionCounter = 0;
                BatteryReconditionScreen.this.setStatus(Text.Recondition_Battery);
                BatteryReconditionScreen.this.currentBrightness = Platform.getDisplayBrightness();
                Platform.setDisplayBrightness(0);
                try {
                    BatteryReconditionScreen.this.setApmResponse(BatteryReconditionScreen.this.setApmReconditionCommand);
                }
                catch (CommandTimeoutException commandTimeoutException) {
                    BatteryReconditionScreen.this.logger.error("no response from server for set APM recondition");
                }
                catch (InterruptedException interruptedException) {
                    BatteryReconditionScreen.this.logger.error("no response from server for set APM recondition");
                }
                BatteryReconditionScreen.this.getScreenManager().installRightMenu(BatteryReconditionScreen.this.createRightMenu());
            }
        });
        this.powerSupplyListener = new PowerSupplyMonitor.ChangeListener(){

            public void stateChanged() {
                if (!BatteryReconditionScreen.this.reconStarted) {
                    PowerSupplyMonitor powerSupplyMonitor = PowerSupplyMonitor.instance();
                    BatteryReconditionScreen.this.continueButton.setEnabled(powerSupplyMonitor.canReconditionNow());
                } else if (!BatteryReconditionScreen.this.reconditioning) {
                    BatteryReconditionScreen.this.reconStarted = false;
                    Platform.setDisplayBrightness(BatteryReconditionScreen.this.currentBrightness);
                    PowerSupplyMonitor.instance().removeChangeListener(BatteryReconditionScreen.this.powerSupplyListener);
                    EventDispatchThread.invokeLater(new Runnable(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            4.access$000(this.this$1).setStatus("");
                            4.access$000(this.this$1).getScreenManager().popScreen();
                        }
                    }, "BatteryRecondition.closeScreen");
                } else {
                    reconditionCounter = PowerSupplyMonitor.instance().getDcPowerIn() == 0 ? ++reconditionCounter : 0;
                    if (reconditionCounter > 2 || !PowerSupplyMonitor.instance().canReconditionNow()) {
                        BatteryReconditionScreen.this.reconditioning = false;
                    }
                    BatteryReconditionScreen.this.htmlRenderer.setText(BatteryReconditionScreen.this.makeContent());
                    BatteryReconditionScreen.this.htmlRenderer.repaint();
                }
            }

            static /* synthetic */ BatteryReconditionScreen access$000(4 var0) {
                return var0.BatteryReconditionScreen.this;
            }
        };
        PowerSupplyMonitor.instance().addChangeListener(this.powerSupplyListener);
        pushButton.setEnabled(false);
        return pushButton;
    }

    protected String makeContent() {
        return "<html><body><h1>" + Text.Recondition_Battery + " -- " + Text.In_Process + "</h1>" + PowerSupplyReader.readBatteryData() + "</body></html>";
    }

    protected void setApmResponse(Command command) throws CommandTimeoutException, InterruptedException {
        this.setApmResponse = MeasurementFactory.instance().getCommandProcessor().call(command, "set");
    }

    void setStatus(String string) {
        MeasurementFactory.instance().getScreenManager().getStatusHandler().setStatus(string);
    }

    public void scrollWheelMoved(ScrollWheelEvent scrollWheelEvent) {
        this.htmlRenderer.scrollBy(scrollWheelEvent.getUnitsMoved() * 5);
    }

    public void scrollWheelMoveComplete() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

