/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.systemFunctions;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandTimeoutException;
import elgato.infrastructure.html.HTMLRenderer;
import elgato.infrastructure.html.HTMLScreen;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.AlphaEditScreen;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.systemFunctions.InstallableOption;
import elgato.infrastructure.util.LocaleManager;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.widgets.BorderWrapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class InstallOptionScreen
extends Screen {
    static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$systemFunctions$InstallOptionScreen == null ? (class$elgato$infrastructure$systemFunctions$InstallOptionScreen = InstallOptionScreen.class$("elgato.infrastructure.systemFunctions.InstallOptionScreen")) : class$elgato$infrastructure$systemFunctions$InstallOptionScreen);
    static final ResourceBundle optionBundle = ResourceBundle.getBundle("elgato.options", LocaleManager.getCurrentLocale());
    InstallableOption option;
    private final String screenSystemOptionInstallHeader;
    private final String screenSystemInstallOptionTitle;
    private final HTMLRenderer htmlRenderer = new HTMLRenderer();
    static /* synthetic */ Class class$elgato$infrastructure$systemFunctions$InstallOptionScreen;

    public InstallOptionScreen(InstallableOption installableOption) {
        this.option = installableOption;
        this.screenSystemOptionInstallHeader = Text.SCREEN_SYSTEM_OPTION_INSTALL_HEADER;
        this.screenSystemInstallOptionTitle = Text.Install_Option;
    }

    public InstallOptionScreen() {
        this.option = null;
        this.screenSystemInstallOptionTitle = this.screenSystemOptionInstallHeader = Text.Install_n_Info.replace('\n', ' ');
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        screenManager.installLeftMenu(this.createLeftMenu());
        screenManager.installRightMenu(this.createRightMenu());
        this.htmlRenderer.setText(this.makeInstallInfo());
        screenManager.installDisplay(new BorderWrapper(this.htmlRenderer, HTMLScreen.BORDER_CONFIG, true));
    }

    private String makeInstallInfo() {
        StringBuffer stringBuffer = new StringBuffer("<html><body><h1>" + this.screenSystemOptionInstallHeader + "</h1>");
        stringBuffer.append("<p>" + Text.SCREEN_SYSTEM_OPTION_INSTALL_MESSAGE + "</p>");
        stringBuffer.append("<table>");
        stringBuffer.append("<TR><TD width=\"30%\"><B>" + Text.Model_numberSymbol + "</B></TD><TD width=\"70%\">" + MeasurementFactory.instance().getModel() + "</TD></TR>");
        stringBuffer.append("<tr><TD width=\"30%\"><B>" + Text.Serial_numberSymbol + "</B></TD><TD width=\"70%\">" + MeasurementFactory.instance().getSerial() + "</TD></TR>");
        stringBuffer.append("<tr><TD width=\"30%\"><B>" + Text.Host_ID + "</B></TD><TD width=\"70%\">" + MeasurementFactory.instance().getHost() + "</TD></TR>");
        if (this.option != null) {
            stringBuffer.append("<TR><TD><B>" + Text.Option + "</B></TD><TD>" + this.option + "</TD></TR>");
        }
        stringBuffer.append("</table>");
        if (this.option != null) {
            stringBuffer.append("<p>" + Text.SCREEN_SYSTEM_OPTION_INSTALL_INSTRUCTIONS + "</p>");
        }
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    public String ft_content() {
        return this.htmlRenderer.getText();
    }

    private Menu createLeftMenu() {
        return new Menu("", new MenuItem[0]);
    }

    private Menu createRightMenu() {
        return new Menu(this.screenSystemInstallOptionTitle, new MenuItem[]{this.createLicenseKeyButton(), null, null, null, null, null, this.createPopScreenButton()});
    }

    private MenuItem createLicenseKeyButton() {
        if (this.option != null) {
            final Value value = Value.createLicenseKeyValue(Text.Enter_License_Key, "");
            PushButton pushButton = new PushButton("Install\nOption", "install"){

                public void press() {
                    LicenseKeyEntryScreen licenseKeyEntryScreen = new LicenseKeyEntryScreen(value, InstallOptionScreen.this.option);
                    MeasurementFactory.instance().getScreenManager().pushScreen(licenseKeyEntryScreen);
                }
            };
            return pushButton;
        }
        return null;
    }

    private MenuItem createPopScreenButton() {
        return new PushButton(Text.Back, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstallOptionScreen.this.getScreenManager().popScreen();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class LicenseResultScreen
    extends Screen {
        private Vector commands;
        HTMLRenderer htmlRenderer = new HTMLRenderer();

        public LicenseResultScreen(Command command) {
            this.commands = new Vector();
            this.commands.addElement(command);
        }

        public LicenseResultScreen(Vector vector) {
            this.commands = vector;
        }

        public void installScreen(ScreenManager screenManager) {
            super.installScreen(screenManager);
            screenManager.installRightMenu(this.createRightMenu());
            this.htmlRenderer.setText(this.makeContent());
            screenManager.installDisplay(new BorderWrapper(this.htmlRenderer, HTMLScreen.BORDER_CONFIG, true));
        }

        private Menu createRightMenu() {
            return new Menu(Text.Install_Option, new MenuItem[]{new PushButton(Text.Finish, "", new ActionListener(this){
                private final /* synthetic */ LicenseResultScreen this$0;
                {
                    this.this$0 = licenseResultScreen;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    MeasurementFactory.instance().getScreenManager().popScreen();
                }
            }), null, null, null, null, null, null});
        }

        private String makeContent() {
            StringBuffer stringBuffer = LicenseResultScreen.makeContentHeader();
            for (int i = 0; i < this.commands.size(); ++i) {
                LicenseResultScreen.makeFeatureContent(stringBuffer, (Command)this.commands.elementAt(i));
            }
            if (this.commands.size() == 0) {
                stringBuffer.append("<p>" + Text.SCREEN_INSTALL_OPTION_CONFIRM_FAILURE_NO_OPTIONS + "</p>");
            }
            LicenseResultScreen.makeContentFooter(stringBuffer);
            return stringBuffer.toString();
        }

        private static StringBuffer makeContentHeader() {
            return new StringBuffer("<html><body><h1>" + Text.SCREEN_INSTALL_OPTION_CONFIRM_HEADER + "</h1>");
        }

        private static void makeFeatureContent(StringBuffer stringBuffer, Command command) {
            String string;
            try {
                string = optionBundle.getString(command.getProperty("option"));
            }
            catch (MissingResourceException missingResourceException) {
                string = "unknown";
            }
            stringBuffer.append("<br><p>" + Text.SCREEN_INSTALL_OPTION_CONFIRM_OPTION + " : " + command.getProperty("option") + " -- " + string + "</p>");
            if ("ok".equals(command.getProperty("status"))) {
                stringBuffer.append("<p>" + Text.SCREEN_INSTALL_OPTION_CONFIRM_SUCCESS + "</p>");
            } else if ("badKey".equals(command.getProperty("status"))) {
                stringBuffer.append("<p>" + Text.SCREEN_INSTALL_OPTION_CONFIRM_FAILURE_BAD_KEY + "</p>");
            } else if ("unknownOption".equals(command.getProperty("status"))) {
                stringBuffer.append("<p>" + Text.SCREEN_INSTALL_OPTION_CONFIRM_FAILURE_NO_OPT + "</p>");
            }
        }

        private static void makeContentFooter(StringBuffer stringBuffer) {
            stringBuffer.append("<br><br><br><p>" + Text.SCREEN_INSTALL_OPTION_CONFIRM_PRESS_OK + "</p></body></html>");
        }

        public String ft_content() {
            return this.htmlRenderer.getText();
        }
    }

    private class LicenseKeyEntryScreen
    extends AlphaEditScreen {
        public LicenseKeyEntryScreen(Value value, InstallableOption installableOption) {
            super((ValueInterface)value, new AlphaEditScreen.EntryListener(installableOption){
                private final /* synthetic */ InstallableOption val$option;
                {
                    this.val$option = installableOption;
                }

                public void valueEntered(String string) {
                    Command command = new Command("addOption");
                    command.addProperty("key", string);
                    command.addProperty("option", this.val$option.getOrderCode());
                    try {
                        Command command2 = MeasurementFactory.instance().getCommandProcessor().call(command, "addOption");
                        MeasurementFactory.instance().getScreenManager().popScreen();
                        MeasurementFactory.instance().getScreenManager().pushScreen(new LicenseResultScreen(command2));
                        MeasurementFactory.instance().getLicensedList();
                    }
                    catch (CommandTimeoutException commandTimeoutException) {
                        logger.error("Unable to add option, timeout", commandTimeoutException);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error("Unable to add option, interrupted", interruptedException);
                    }
                }
            });
        }
    }
}

