/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.systemFunctions;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.html.HTMLScreen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.systemFunctions.InstallableOption;
import elgato.infrastructure.util.KeyValuePair;
import elgato.infrastructure.util.LocaleManager;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class ListOptionScreen
extends HTMLScreen {
    protected static final ResourceBundle optionBundle = ResourceBundle.getBundle("elgato.options", LocaleManager.getCurrentLocale());
    private static String testEntryString;
    public final String MAGIC_NUMBER_FOR_DCOUT_OPTION = "300";
    public final String MAGIC_NUMBER_FOR_E1_OPTION = "710";
    public final String MAGIC_NUMBER_FOR_T1_OPTION = "700";
    private Vector installedOptions = null;
    private Vector userInstallableOptions = null;

    public abstract String getHeading();

    public abstract String getPreList();

    public abstract String getPostList();

    public abstract String[] getListData();

    public ListOptionScreen(ScreenManager screenManager, String string) {
        super(screenManager, false, string);
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.htmlRenderer.setText(this.makeContent());
        this.htmlRenderer.render();
    }

    protected String makeContent() {
        StringBuffer stringBuffer = new StringBuffer("<html><body>");
        String string = this.getHeading();
        if (string != null && string.length() > 0) {
            stringBuffer.append("<h1>" + string + "</h1>");
        }
        if ((string = this.getPreList()) != null && string.length() > 0) {
            stringBuffer.append("<p>" + string + "</p>");
        }
        String[] stringArray = this.getListData();
        stringBuffer.append("<ul>");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
            }
        }
        stringBuffer.append("</ul>");
        string = this.getPostList();
        if (string != null && string.length() > 0) {
            stringBuffer.append("<p>" + string + "</p>");
        }
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    public String getMakeContent() {
        return this.makeContent();
    }

    protected KeyValuePair[] getOptionsKeyValuePairs() {
        Command command = Command.getResultCommand(new Command("getOptionList"), "setOptionList");
        KeyValuePair[] keyValuePairArray = new KeyValuePair[]{};
        if (command != null) {
            keyValuePairArray = command.getProperties();
        }
        return keyValuePairArray;
    }

    public InstallableOption[] getInstallableList() {
        Vector vector = new Vector();
        Vector vector2 = this.getInstalledOptions();
        Vector vector3 = this.getAvailableUserOptions();
        for (int i = 0; i < vector3.size(); ++i) {
            if (vector2.contains(vector3.elementAt(i))) continue;
            vector.addElement(vector3.elementAt(i));
        }
        InstallableOption[] installableOptionArray = new InstallableOption[vector.size() + 1];
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            installableOptionArray[i] = new InstallableOption(string, optionBundle.getString(string));
        }
        installableOptionArray[vector.size()] = new InstallableOption("", "Manually Enter a Specific Option --");
        return installableOptionArray;
    }

    protected Vector getInstalledOptions() {
        if (this.installedOptions == null) {
            KeyValuePair[] keyValuePairArray = this.getOptionsKeyValuePairs();
            this.installedOptions = new Vector(keyValuePairArray.length);
            for (int i = 0; i < keyValuePairArray.length; ++i) {
                if (!keyValuePairArray[i].getKey().startsWith("option")) continue;
                this.installedOptions.addElement(keyValuePairArray[i].getValue());
            }
        }
        return this.installedOptions;
    }

    protected Vector getAvailableFactoryOptions() {
        Vector vector = ListOptionScreen.splitAtCommas(this.getPropertyString("factory"));
        Vector vector2 = this.getInstalledOptions();
        boolean bl = vector2.contains("700");
        boolean bl2 = vector2.contains("710");
        if (bl) {
            vector.removeElement("710");
        } else if (bl2) {
            vector.removeElement("700");
        }
        return vector;
    }

    protected Vector getAvailableUserOptions() {
        if (this.userInstallableOptions == null) {
            this.userInstallableOptions = ListOptionScreen.splitAtCommas(this.getPropertyString("installable"));
            if (!MeasurementFactory.instance().isDcBiasHardwareAvailable()) {
                for (int i = 0; i < this.userInstallableOptions.size(); ++i) {
                    String string = (String)this.userInstallableOptions.elementAt(i);
                    if (!string.equals("300")) continue;
                    this.userInstallableOptions.removeElementAt(i);
                }
            }
        }
        return this.userInstallableOptions;
    }

    String getPropertyString(String string) {
        return optionBundle.getString(string) + ListOptionScreen.ft_testEntries();
    }

    private static String ft_testEntries() {
        if (testEntryString == null) {
            return "";
        }
        return "," + testEntryString;
    }

    public static void setTestEntryString(String string) {
        testEntryString = string;
    }

    protected static Vector splitAtCommas(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.indexOf(44, 0);
        if (n2 == -1) {
            n2 = string.length();
        }
        while (n2 > n) {
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
            if ((n2 = string.indexOf(44, n)) != -1) continue;
            n2 = string.length();
        }
        return vector;
    }
}

