/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.systemFunctions;

import elgato.infrastructure.systemFunctions.SavedState;

public class SavedStateList {
    private final String currentState;
    private final String powerUpState;
    private final SavedState[] states;

    public SavedStateList(String string, String string2, SavedState[] savedStateArray) {
        this.currentState = string;
        this.powerUpState = string2;
        this.states = savedStateArray;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public String getPowerUpState() {
        return this.powerUpState;
    }

    public SavedState[] getReadableStates() {
        return (SavedState[])this.states.clone();
    }

    public SavedState[] getWritableStates() {
        int n = 0;
        for (int i = 0; i < this.states.length; ++i) {
            if (!this.states[i].isWritable()) continue;
            ++n;
        }
        SavedState[] savedStateArray = new SavedState[n];
        int n2 = 0;
        for (int i = 0; i < this.states.length; ++i) {
            if (!this.states[i].isWritable()) continue;
            savedStateArray[n2++] = this.states[i];
        }
        return savedStateArray;
    }

    public SavedState[] getDeletableStates() {
        int n = 0;
        for (int i = 0; i < this.states.length; ++i) {
            if (!this.isDeletable(i)) continue;
            ++n;
        }
        SavedState[] savedStateArray = new SavedState[n];
        int n2 = 0;
        for (int i = 0; i < this.states.length; ++i) {
            if (!this.isDeletable(i)) continue;
            savedStateArray[n2++] = this.states[i];
        }
        return savedStateArray;
    }

    private boolean isDeletable(int n) {
        return this.states[n].isWritable() && !this.states[n].getName().equals(this.powerUpState);
    }
}

