/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.systemFunctions;

import elgato.gui.ModelTypeMgr;
import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandTimeoutException;
import elgato.infrastructure.mainScreens.FormatMessageScreen;
import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.MessageScreenListener;
import elgato.infrastructure.mainScreens.RestartScreen;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.manufacturing.DisplayTestScreen;
import elgato.infrastructure.manufacturing.KeyboardTestScreen;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.AlphaEditScreen;
import elgato.infrastructure.menu.FileSelectButton;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListButton;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuMgr;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.MenuSymbol;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.ScreenButton;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.menu.TimeFreqRefButtonFactory;
import elgato.infrastructure.systemFunctions.FactoryInstallableOptionsScreen;
import elgato.infrastructure.systemFunctions.InstallOptionScreen;
import elgato.infrastructure.systemFunctions.InstallableOption;
import elgato.infrastructure.systemFunctions.InstalledOptionsScreen;
import elgato.infrastructure.systemFunctions.SavedState;
import elgato.infrastructure.systemFunctions.TimeBaseAdjustmentScreen;
import elgato.infrastructure.util.CatCard;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.LocaleManager;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.NetworkConfiguration;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.TextMessage;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueButton;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.DefaultEListModel;
import elgato.infrastructure.widgets.EListDataListener;
import elgato.infrastructure.widgets.EListModel;
import elgato.measurement.powerSupply.PowerSupplyMeasurementSettings;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;

public abstract class SystemMenuMgr
extends MenuMgr {
    static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$systemFunctions$SystemMenuMgr == null ? (class$elgato$infrastructure$systemFunctions$SystemMenuMgr = SystemMenuMgr.class$("elgato.infrastructure.systemFunctions.SystemMenuMgr")) : class$elgato$infrastructure$systemFunctions$SystemMenuMgr);
    protected final SystemMeasurementSettings settings;
    private static final Resources systemResources = Resources.getResources("elgato.system");
    static final String SYSTEM_SETTINGS_DIR = systemResources.getString("system.settings.directory");
    private SettingsModel globalSettingsModel;
    protected MenuItem screenFileSelectButton = this.createScreenFilenameButton();
    protected MenuItem dataFileSelectButton = this.createDataFilenameButton();
    protected MenuItem screenFileExistsButton = this.createScreenFileExistsButton();
    protected MenuItem dataFileExistsButton = this.createDataFileExistsButton();
    DeviceChecker deviceCheckerThread;
    private ValueListener fileExistsValueListener;
    private ValueListener dataFileValueListener;
    private ValueListener dhcpValueListener;
    NetworkConfiguration networkConfigModel;
    ValueButton ipAddressButton;
    ValueButton netMaskButton;
    ValueButton gateWayButton;
    protected Menu leftMenu = null;
    private ValueListener dataFileLocationListener = new ValueListener(){
        private final String listenerName = "SysScreen.dataFileLocationListener";

        public String getListenerName() {
            return "SysScreen.dataFileLocationListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            SystemMenuMgr.this.dataFileSelectButton = SystemMenuMgr.this.createScreenFilenameButton();
            SystemMenuMgr.this.scn.getScreenManager().getRightMenuPanel().setMenuItem(SystemMenuMgr.this.dataFileSelectButton, 3);
        }
    };
    private ValueListener screenFileLocationListener = new ValueListener(){
        private final String listenerName = "SysScreen.screenFileLocationListener";

        public String getListenerName() {
            return "SysScreen.screenFileLocationListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            SystemMenuMgr.this.screenFileSelectButton = SystemMenuMgr.this.createScreenFilenameButton();
            SystemMenuMgr.this.scn.getScreenManager().getRightMenuPanel().setMenuItem(SystemMenuMgr.this.screenFileSelectButton, 3);
        }
    };
    private ValueListener screenAutoNameFileValueListener = new ValueListener(){
        private final String listenerName = "SysScreen.screenAutoFileListener";

        public String getListenerName() {
            return "SysScreen.screenAutoFileListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            boolean bl = valueInterface.intValue() == 0;
            SystemMenuMgr.this.screenFileSelectButton.setEnabled(bl);
            SystemMenuMgr.this.screenFileExistsButton.setEnabled(bl);
        }
    };
    private ValueListener dataAutoNameFileValueListener = new ValueListener(){
        private final String listenerName = "SysScreen.dataAutoNameFileListener";

        public String getListenerName() {
            return "SysScreen.dataAutoNameFileListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            boolean bl = valueInterface.intValue() == 0;
            SystemMenuMgr.this.dataFileSelectButton.setEnabled(bl);
            SystemMenuMgr.this.dataFileExistsButton.setEnabled(bl);
        }
    };
    private static final Font ipAddressValueFont = Resources.getResources((class$elgato$infrastructure$menu$MenuItem == null ? (class$elgato$infrastructure$menu$MenuItem = SystemMenuMgr.class$("elgato.infrastructure.menu.MenuItem")) : class$elgato$infrastructure$menu$MenuItem).getName()).getFont("ipAddressTextFont");
    static /* synthetic */ Class class$elgato$infrastructure$systemFunctions$SystemMenuMgr;
    static /* synthetic */ Class class$elgato$infrastructure$menu$MenuItem;

    public SystemMenuMgr(Screen screen, SystemMeasurementSettings systemMeasurementSettings) {
        super(screen);
        this.settings = systemMeasurementSettings;
    }

    protected abstract MenuItem createLocRefMenuButton();

    protected abstract MenuItem createPrintScrSetupButton();

    protected abstract MenuItem createSaveDataSetupButton();

    protected abstract MenuItem createSaveRecallButton();

    protected abstract MenuItem createControlsButton();

    protected abstract MenuItem createSystemStatsButton();

    protected abstract MenuItem createOptionManagerButton();

    protected abstract MenuItem createServiceButton();

    public void addValueListeners() {
        SystemMeasurementSettings.instance().getDataFileLocation().addValueListener(this.dataFileLocationListener);
        SystemMeasurementSettings.instance().getScreenFileLocation().addValueListener(this.screenFileLocationListener);
        SystemMeasurementSettings.instance().getScreenFileExists().addValueListener(this.fileExistsValueListener);
        SystemMeasurementSettings.instance().getDataFileExists().addValueListener(this.dataFileValueListener);
        SystemMeasurementSettings.instance().getScreenAutoNameFile().addValueListener(this.screenAutoNameFileValueListener);
        SystemMeasurementSettings.instance().getDataAutoNameFile().addValueListener(this.dataAutoNameFileValueListener);
    }

    public void removeValueListeners() {
        SystemMeasurementSettings.instance().getDataFileLocation().removeValueListener(this.dataFileLocationListener);
        SystemMeasurementSettings.instance().getScreenFileLocation().removeValueListener(this.screenFileLocationListener);
        SystemMeasurementSettings.instance().getScreenFileExists().removeValueListener(this.fileExistsValueListener);
        SystemMeasurementSettings.instance().getDataFileExists().removeValueListener(this.dataFileValueListener);
        SystemMeasurementSettings.instance().getScreenAutoNameFile().removeValueListener(this.screenAutoNameFileValueListener);
        SystemMeasurementSettings.instance().getDataAutoNameFile().removeValueListener(this.dataAutoNameFileValueListener);
    }

    public Menu buildLeftMenu() {
        if (this.leftMenu != null) {
            return this.leftMenu;
        }
        this.leftMenu = new Menu(Text.System, new MenuItem[]{this.createLocRefMenuButton(), this.createPrintScrSetupButton(), this.createSaveDataSetupButton(), this.createMediaReferenceMenuButton(), this.createControlsButton(), this.createSaveRecallButton(), this.createMoreButton(this.scn.getScreenManager())});
        return this.leftMenu;
    }

    MenuItem[] buildSecondLeftMenu() {
        return new MenuItem[]{this.createSystemStatsButton(), this.createOptionManagerButton(), null, null, null, this.createServiceButton()};
    }

    void loadLeftButtonMenu(ScreenManager screenManager) {
        this.globalSettingsModel = MeasurementFactory.instance().getSettingsModel("display.global");
        if (ModelTypeMgr.instance().getModelType() == 0) {
            screenManager.getLeftMenuPanel().installMenu(this.buildLeftMenu());
        } else {
            screenManager.installLeftMenu(this.buildLeftMenu());
        }
        this.pressHomeButton();
    }

    void loadSecondLeftButtonMenu(ScreenManager screenManager) {
        screenManager.getLeftMenuPanel().installMenu(new Menu(Text.System, new MenuItem[]{this.createSystemStatsButton(), this.createOptionManagerButton(), null, null, null, this.createServiceButton(), this.createMore2Button(screenManager)}));
        this.pressHomeButton();
    }

    void pressHomeButton() {
        if (ModelTypeMgr.instance().getModelType() == 0) {
            this.scn.pressHomeButton();
        }
    }

    public MenuItem createMediaReferenceMenuButton() {
        return new SimpleMenuButton(Text.Media_n_Manager, this.getContextString("media.reference"), new Menu(Text.Media_Manager, new MenuItem[]{new FormatDeviceButton(Text.Format_n_PCMCIA, this.getContextString("media.reference.pcmcia"), 0), new FormatDeviceButton(Text.Format_n_CF, this.getContextString("media.reference.cf"), 1), new CatCard(this.scn.getScreenManager()).makeCatCardButton(), null, null, null, this.createReturnButton()}));
    }

    protected Menu createRightMenuWithTimeRef() {
        return new Menu(Text.get("screen.system.loc.ref.title"), new MenuItem[]{TimeFreqRefButtonFactory.createTimeFreqRefButton("SysScreen"), this.createGpsButton("gps"), this.createDcOutButton(), null, null, null, this.createReturnButton()});
    }

    protected MenuItem createDcOutButton() {
        if (MeasurementFactory.instance().isDcBiasHardwareAvailable()) {
            MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(PowerSupplyMeasurementSettings.instance().getDcOut(), this.getContextString("dcOut"), "SysScreen.dcOut");
            multiStateActuatorButton.setEnabled(MeasurementFactory.instance().isDcBiasOptionAvailable());
            return multiStateActuatorButton;
        }
        return null;
    }

    protected MultiStateActuatorButton createPrintSchemeButton(SystemMeasurementSettings systemMeasurementSettings) {
        return new MultiStateActuatorButton(systemMeasurementSettings.getPrintSchemeActuator(), this.getContextString("lightBackground"), "SysScreen.printSchemeListener");
    }

    protected FileSelectButton createScreenFilenameButton() {
        int n = SystemMeasurementSettings.instance().getScreenDeviceType();
        String[] stringArray = RuntimeConfiguration.isEmbedded() ? FileSystemHelper.getInstance().getDeviceFileList(n, "", ".png", false) : FileSystemHelper.getInstance().getFileList(FileSystemHelper.getInstance().getLocalDirectory(), ".png", false);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        ScreenFilenameListener screenFilenameListener = new ScreenFilenameListener();
        FileSelectButton fileSelectButton = new FileSelectButton(Text.User_Filename, Text.Enter_Screen_Filename, this.getContextString("printScreenSetup.filename"), (SettingsModel)SystemMeasurementSettings.instance(), "screenFilename", stringArray, (AlphaEditScreen.AlphaEditScreenExitListener)screenFilenameListener);
        String string = SystemMeasurementSettings.instance().getScreenFilename();
        if (string == null || string.trim().length() == 0) {
            SystemMeasurementSettings.instance().setScreenFilename(Text.printScreen);
        }
        fileSelectButton.setEnabled(SystemMeasurementSettings.instance().isAutonameScreenFileUser());
        return fileSelectButton;
    }

    protected FileSelectButton createDataFilenameButton() {
        int n = SystemMeasurementSettings.instance().getDataDeviceType();
        String[] stringArray = RuntimeConfiguration.isEmbedded() ? FileSystemHelper.getInstance().getDeviceFileList(n, "", ".xls", false) : FileSystemHelper.getInstance().getFileList(FileSystemHelper.getInstance().getLocalDirectory(), ".xls", false);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        DataFilenameListener dataFilenameListener = new DataFilenameListener();
        FileSelectButton fileSelectButton = new FileSelectButton(Text.User_Filename, Text.Enter_Data_Filename, this.getContextString("dataSetup.filename"), (SettingsModel)SystemMeasurementSettings.instance(), "dataFilename", stringArray, (AlphaEditScreen.AlphaEditScreenExitListener)dataFilenameListener);
        String string = SystemMeasurementSettings.instance().getDataFilename();
        if (string == null || string.trim().length() == 0) {
            SystemMeasurementSettings.instance().setDataFilename(Text.saveData);
        }
        fileSelectButton.setEnabled(SystemMeasurementSettings.instance().isAutonameDataFileUser());
        return fileSelectButton;
    }

    protected MultiStateActuatorButton createScreenAutoNameFileButton() {
        return new MultiStateActuatorButton(SystemMeasurementSettings.instance().getScreenAutoNameFile(), this.getContextString("printScreenSetup.autoNameFile"), "SysScreen.screenAutoNameFileButton");
    }

    protected MultiStateActuatorButton createDataAutoNameFileButton() {
        return new MultiStateActuatorButton(SystemMeasurementSettings.instance().getDataAutoNameFile(), this.getContextString("dataSetup.autoNameFile"), "SysScreen.dataAutoNameFileButton");
    }

    private SubMenuButton createScreenFileExistsButton() {
        final SubMenuButton subMenuButton = new SubMenuButton(Text.If_File_n_Existsdotdotdot, this.getContextString("printScreenSetup.fileExists"), new Menu("", new MenuItem[]{this.createFileExistsSettingButton(Text.Overwrite, "", "screenFileExists", 1), this.createFileExistsSettingButton(Text.Prompt, "", "screenFileExists", 0), this.createFileExistsSettingButton(Text.Auto_Incr, "", "screenFileExists", 2), this.createFileExistsSettingButton(Text.Timestamp, "", "screenFileExists", 3)}));
        if (SystemMeasurementSettings.instance() == null) {
            return subMenuButton;
        }
        this.handleFileExistsSubText(subMenuButton, SystemMeasurementSettings.instance().getScreenFileExists().intValue());
        this.fileExistsValueListener = new ValueListener(){
            private final String listenerName = "SysScreen.fileExistsValueListener";

            public String getListenerName() {
                return "SysScreen.fileExistsValueListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                SystemMenuMgr.this.handleFileExistsSubText(subMenuButton, valueInterface.intValue());
            }
        };
        this.screenFileExistsButton = subMenuButton;
        subMenuButton.setEnabled(SystemMeasurementSettings.instance().isAutonameScreenFileUser());
        return subMenuButton;
    }

    private SubMenuButton createDataFileExistsButton() {
        final SubMenuButton subMenuButton = new SubMenuButton(Text.If_File_n_Existsdotdotdot, this.getContextString("printScreenSetup.fileExists"), new Menu("", new MenuItem[]{this.createFileExistsSettingButton(Text.Overwrite, "", "dataFileExists", 1), this.createFileExistsSettingButton(Text.Append, "", "dataFileExists", 4), this.createFileExistsSettingButton(Text.Prompt, "", "dataFileExists", 0), this.createFileExistsSettingButton(Text.Auto_Incr, "", "dataFileExists", 2), this.createFileExistsSettingButton(Text.Timestamp, "", "dataFileExists", 3)}));
        if (SystemMeasurementSettings.instance() == null) {
            return subMenuButton;
        }
        this.handleFileExistsSubText(subMenuButton, SystemMeasurementSettings.instance().getDataFileExists().intValue());
        this.dataFileValueListener = new ValueListener(){
            private final String listenerName = "SysScreen.dataFileValueListener";

            public String getListenerName() {
                return "SysScreen.dataFileValueListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                SystemMenuMgr.this.handleFileExistsSubText(subMenuButton, valueInterface.intValue());
            }
        };
        subMenuButton.setEnabled(SystemMeasurementSettings.instance().isAutonameDataFileUser());
        this.dataFileExistsButton = subMenuButton;
        return subMenuButton;
    }

    public void handleFileExistsSubText(SubMenuButton subMenuButton, int n) {
        String[] stringArray = FileSystemHelper.getInstance().getFileExistsOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != n) continue;
            subMenuButton.setSubText(stringArray[i]);
            return;
        }
        subMenuButton.setSubText("");
    }

    PushButton createFileExistsSettingButton(String string, String string2, final String string3, final int n) {
        return new PushButton(string, this.getContextString(string2), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SystemMeasurementSettings.instance().set(string3, n);
                ScreenManager screenManager = MeasurementFactory.instance().getScreenManager();
                if (screenManager == null) {
                    return;
                }
                MenuPanel menuPanel = screenManager.getRightMenuPanel();
                if (menuPanel == null) {
                    return;
                }
                Command command = Command.makeSetCommand("system");
                command.addProperty(string3, n);
                MeasurementFactory.instance().getCommandProcessor().send(command);
                menuPanel.invokeButton(6);
            }
        });
    }

    public MenuItem createScreenFileLocationButton() {
        if (!RuntimeConfiguration.isEmbedded()) {
            return new MultiStateActuatorButton(SystemMeasurementSettings.instance().getScreenFileLocation(), this.getContextString("printScreenSetup.fileLocation"), "SysScreen.screenFileLocationButton");
        }
        return new MultiStateActuatorButton(SystemMeasurementSettings.instance().getScreenFileLocation(), this.getContextString("printScreenSetup.fileLocation"), "SysScreen.screenFileLocationButton");
    }

    protected MultiStateActuatorButton createDataFileLocationButton() {
        return new MultiStateActuatorButton(SystemMeasurementSettings.instance().getDataFileLocation(), this.getContextString("saveDataScreenSetup.fileLocation"), "SysScreen.dataFileLocationButton");
    }

    private ListButton createSettingsRemovalButton() {
        SettingsListModel settingsListModel = this.createListModel();
        ListButton listButton = new ListButton(Text.Delete_n_States, this.getContextString("settings.delete"), settingsListModel, (SettingsModel)SystemMeasurementSettings.instance(), "", (ItemSelectionListener)new SettingsSelectionListener());
        listButton.setDrawSelectedItem(false);
        return listButton;
    }

    protected SettingsListModel createListModel() {
        return new SettingsListModel();
    }

    public MenuItem createPeripheralsButton() {
        return new SimpleMenuButton(Text.get("screen.system.controls"), this.getContextString("peripherals"), this.createEmptyMenu());
    }

    MenuItem createMoreButton(final ScreenManager screenManager) {
        if (ModelTypeMgr.instance().getModelType() == 0) {
            return new PushButton(Text.get("screen.system.more"), this.getContextString("more"), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    screenManager.getLeftMenuPanel().clear();
                    SystemMenuMgr.this.loadSecondLeftButtonMenu(screenManager);
                }
            });
        }
        SubMenuButton subMenuButton = new SubMenuButton(Text.get("screen.system.more"), this.getContextString("more"), new Menu(Text.get("screen.system.more"), this.buildSecondLeftMenu()));
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    MenuItem createMore2Button(final ScreenManager screenManager) {
        return new PushButton(Text.get("screen.system.more2"), this.getContextString("more"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                screenManager.getLeftMenuPanel().clear();
                SystemMenuMgr.this.loadLeftButtonMenu(screenManager);
            }
        });
    }

    protected MenuItem createReturnButton() {
        return PushButton.createPopScreenReturnButton(this.scn.getScreenManager());
    }

    protected Menu createControlsMenu() {
        ActuatorSubMenuButton actuatorSubMenuButton = new ActuatorSubMenuButton(SystemMeasurementSettings.instance().getRPGType(), this.getContextString("rpgType"), true, "SysScreen.rpgTypeButton");
        actuatorSubMenuButton.setSubMenuTopTitle(Text.Knob_Type);
        return new Menu(Text.get("screen.system.controls"), new MenuItem[]{this.createIpAdminSubmenu(), actuatorSubMenuButton, this.createDisplaySettingsSubmenu(), "true".equals(System.getProperty("showLanguageButton")) ? this.createLocaleButton() : null, null, null, this.createReturnButton()});
    }

    private MenuItem createDisplaySettingsSubmenu() {
        SystemMeasurementSettings systemMeasurementSettings = SystemMeasurementSettings.instance();
        SubMenuButton subMenuButton = new SubMenuButton(Text.Display_n_Settings, "", new Menu(Text.Display, new MenuItem[]{new ListActuatorButton(systemMeasurementSettings.getBacklightAutoDimBattery(), "", "dimBattery"), new ListActuatorButton(systemMeasurementSettings.getBacklightAutoDimAC(), "", "dimAC")}));
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    SubMenuButton createIpAdminSubmenu() {
        try {
            this.networkConfigModel = this.getNetworkConfiguration();
            SubMenuButton subMenuButton = new SubMenuButton(Text.IP_Admin, this.getContextString("ip.admin"), new Menu(Text.IP_Admin, new MenuItem[]{this.makeHostnameButton(), this.makeDhcpButton(), this.makeIpAddressButton(), this.makeNetmaskButton(), this.makeGatewayButton(), this.makeIpAdminSaveButton()}));
            this.addDhcpValueListener();
            subMenuButton.setCancelButtonTitle(Text.Back);
            this.networkConfigModel.getDhcpEnabled().setValue(this.networkConfigModel.getDhcpEnabled().intValue());
            return subMenuButton;
        }
        catch (IOException iOException) {
            logger.error("Error trying to obtain network configuration. ", iOException);
            return null;
        }
    }

    PushButton makeIpAdminSaveButton() {
        PushButton pushButton = new PushButton(Text.Save, this.getContextString("ipadmin.save"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SystemMenuMgr.this.getNetworkConfiguration().saveChanges();
                    RestartScreen.promptForRestart(RestartScreen.reboot);
                }
                catch (IOException iOException) {
                    logger.error("Couldn't save network configuration", iOException);
                }
            }
        };
        pushButton.addActionListener(actionListener);
        return pushButton;
    }

    NetworkConfiguration getNetworkConfiguration() throws IOException {
        if (this.networkConfigModel == null) {
            this.networkConfigModel = NetworkConfiguration.create();
        }
        return this.networkConfigModel;
    }

    MultiStateActuatorButton makeDhcpButton() {
        ListActuator listActuator = new ListActuator("noTopic", "notToBeSent", Text.DHCP, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
        listActuator.setValue(this.networkConfigModel.getDhcpEnabled().intValue());
        listActuator.addValueListener(new ValueListener(){
            private final String listenerName = "dhcpConfigListener";

            public String getListenerName() {
                return "dhcpConfigListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                SystemMenuMgr.this.networkConfigModel.setDhcpEnabled(valueInterface.booleanValue());
            }
        });
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(listActuator, this.getContextString("sys.name"), "dhcpButton");
        return multiStateActuatorButton;
    }

    ValueButton makeHostnameButton() {
        ValueButtonWithArrow valueButtonWithArrow = new ValueButtonWithArrow(this.getContextString("hostname"), this.networkConfigModel.getHostname(), ipAddressValueFont, "hostnameButton");
        return valueButtonWithArrow;
    }

    ValueButton makeIpAddressButton() {
        this.ipAddressButton = new ValueButtonWithArrow(this.getContextString("ip.address"), this.networkConfigModel.getIpAddress(), ipAddressValueFont, "ipAddressButton");
        return this.ipAddressButton;
    }

    ValueButton makeNetmaskButton() {
        this.netMaskButton = new ValueButtonWithArrow(this.getContextString("netmask.address"), this.networkConfigModel.getSubnetMask(), ipAddressValueFont, "networkMaskButton");
        return this.netMaskButton;
    }

    ValueButton makeGatewayButton() {
        this.gateWayButton = new ValueButtonWithArrow(this.getContextString("gateway.address"), this.networkConfigModel.getGateway(), ipAddressValueFont, "gatewayButton");
        return this.gateWayButton;
    }

    private void addDhcpValueListener() {
        this.dhcpValueListener = new ValueListener(){
            private final String listenerName = "dhcpValueListener";

            public String getListenerName() {
                return "dhcpValueListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                boolean bl = !valueInterface.booleanValue();
                SystemMenuMgr.this.ipAddressButton.setEnabled(bl);
                SystemMenuMgr.this.netMaskButton.setEnabled(bl);
                SystemMenuMgr.this.gateWayButton.setEnabled(bl);
            }
        };
        this.networkConfigModel.getDhcpEnabled().addValueListener(this.dhcpValueListener);
    }

    public void removeDhcpValueListener() {
        if (this.networkConfigModel != null) {
            this.networkConfigModel.getDhcpEnabled().removeValueListener(this.dhcpValueListener);
        }
    }

    public ValueListener getDhcpValueListener() {
        return this.dhcpValueListener;
    }

    MenuItem createSerialPortsButton() {
        return new SimpleMenuButton(Text.get("screen.system.serial_ports"), this.getContextString("serial.ports"), this.createEmptyMenu());
    }

    private MenuItem createLocaleButton() {
        return new ListActuatorButton(LocaleManager.getLocaleActuator(), "", "SysScreen.localeButton");
    }

    protected Menu createRightMenuForOptionButton() {
        return new Menu(Text.get("screen.system.option_manager.no.br"), new MenuItem[]{ScreenButton.newPushingButtonWithArrow(Text.Installed_n_Options, new InstalledOptionsScreen(this.scn.getScreenManager())), ScreenButton.newPushingButtonWithArrow(Text.Installable_n_Options, new FactoryInstallableOptionsScreen(this.scn.getScreenManager())), this.createUserInstallableListButton(), ScreenButton.newPushingButtonWithArrow(Text.Install_n_Info, new InstallOptionScreen()), null, null, this.createReturnButton()});
    }

    MenuItem createUserInstallableListButton() {
        Object[] objectArray = this.getFactoryInstallableOptionsScreen().getInstallableList();
        InstallableListButton installableListButton = new InstallableListButton(Text.Install_n_an_Option, this.getContextString("installable"), new DefaultEListModel(objectArray), this.globalSettingsModel, "optToInstall", new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                InstallableOption installableOption = (InstallableOption)itemSelectionEvent.getValue();
                if (installableOption.getOrderCode().equals("")) {
                    Value value = Value.createValue("OPTION_ID", "");
                    value.setPalette(Palette.createUnsignedInteger());
                    ValueListener valueListener = new ValueListener(this){
                        private final /* synthetic */ 13 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void valueChanged(ValueInterface valueInterface) {
                            SystemMenuMgr.access$600(13.access$500(this.this$1)).getScreenManager().pushScreen(new InstallOptionScreen(new InstallableOption(((Object)valueInterface).toString(), "Software Option")));
                        }

                        public String getListenerName() {
                            return null;
                        }
                    };
                    value.addValueListener(valueListener);
                    SystemMenuMgr.this.scn.getScreenManager().pushScreen(new AlphaEditScreen(this, value){
                        private final /* synthetic */ 13 this$1;
                        {
                            this.this$1 = var1_1;
                        }
                    });
                } else {
                    SystemMenuMgr.this.scn.getScreenManager().pushScreen(new InstallOptionScreen(installableOption));
                }
            }

            static /* synthetic */ SystemMenuMgr access$500(13 var0) {
                return var0.SystemMenuMgr.this;
            }
        });
        installableListButton.setEnabled(objectArray.length > 0);
        return installableListButton;
    }

    protected FactoryInstallableOptionsScreen getFactoryInstallableOptionsScreen() {
        return new FactoryInstallableOptionsScreen(this.scn.getScreenManager());
    }

    protected Menu createEmptyMenu() {
        return new Menu("", new MenuItem[]{null, null, null, null, null, null, this.createReturnButton()});
    }

    protected Menu createSaveRecallMenu() {
        return new Menu("Save/Recall", new MenuItem[]{null, this.createSettingsRemovalButton(), null, null, null, null, this.createReturnButton()});
    }

    public Menu createRightMenuForServiceButton() {
        return new Menu(Text.get("screen.system.service"), new MenuItem[]{this.createAdjustmentsButton(), null, this.createVerificationButton(), null, null, null, this.createReturnButton()});
    }

    public MenuItem createAdjustmentsButton() {
        Object object;
        Object object2;
        boolean bl = false;
        if (RuntimeConfiguration.isUnitTestMode()) {
            bl = true;
        } else {
            object2 = new Command("getRxDacSetting");
            ((Command)object2).addProperty("type", "create");
            try {
                object = MeasurementFactory.instance().getCommandProcessor().call((Command)object2, "setRxDacSetting", 2000L);
                if (Integer.parseInt(((Command)object).getProperty("dac")) >= 0) {
                    bl = true;
                }
            }
            catch (CommandTimeoutException commandTimeoutException) {
                logger.error("no response from server for getRxDacSetting");
            }
            catch (InterruptedException interruptedException) {
                logger.error("no response from server for getRxDacSetting");
            }
        }
        object2 = ScreenButton.newPushingButton(Text.Time_Base_n_Adjustment, new TimeBaseAdjustmentScreen());
        object = new SubMenuButton(Text.Adjustments, this.getContextString("system.adjustments"), new Menu(Text.Adjustments, new MenuItem[]{object2}));
        ((MenuItem)object2).setEnabled(bl);
        ((SimpleMenuButton)object).getMenu().getItems()[6].setText(Text.Back);
        return object;
    }

    MenuItem createVerificationButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Verification, this.getContextString("system.verification"), new Menu(Text.Verification, new MenuItem[]{ScreenButton.newPushingButton(Text.Display_n_Test, new DisplayTestScreen()), ScreenButton.newPushingButton(Text.Keyboard_n_Test, new KeyboardTestScreen()), null, null, null, null}));
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    public void startDeviceCheckerThread() {
        if (this.deviceCheckerThread == null) {
            this.deviceCheckerThread = new DeviceChecker();
            this.deviceCheckerThread.start();
        }
        this.deviceCheckerThread.update();
    }

    public void stopDeviceCheckerThread() {
        if (this.deviceCheckerThread != null) {
            DeviceChecker deviceChecker = this.deviceCheckerThread;
            this.deviceCheckerThread = null;
            deviceChecker.update();
        }
    }

    MultiStateActuatorButton createGpsButton(String string) {
        return new MultiStateActuatorButton(DisplayGlobalMeasurementSettings.instance().getGpsLocationToggle(), string, "SysScreen.gpsButton");
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            MenuPanel menuPanel;
            ScreenManager screenManager = MeasurementFactory.instance().getScreenManager();
            if (screenManager != null && (menuPanel = screenManager.getRightMenuPanel()) != null && this.showingEscapableRightMenu(menuPanel.getMenu())) {
                menuPanel.getMenuItems()[6].press();
            }
        } else {
            this.scn.keyPressed(keyEvent);
        }
    }

    private boolean showingEscapableRightMenu(Menu menu) {
        return menu.getTitle().equals(Text.Save_Data) || menu.getTitle().equals(Text.Fr_slash_Time_Ref) || menu.getTitle().equals(Text.Print_Screen);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Screen access$600(SystemMenuMgr systemMenuMgr) {
        return systemMenuMgr.scn;
    }

    static /* synthetic */ Screen access$1300(SystemMenuMgr systemMenuMgr) {
        return systemMenuMgr.scn;
    }

    class ConfirmSettingsDeleteMessageScreen
    extends MessageScreen
    implements MessageScreenListener {
        String prompt = "";
        String directory = "";
        EListModel model = null;
        String[] directories = null;
        String settingName = "";

        public ConfirmSettingsDeleteMessageScreen(String string, int n, int n2) {
            super("", true, n, n2);
            this.prompt = string;
            this.addListener(this);
        }

        public void setSettingName(String string) {
            this.settingName = string;
        }

        private void removeAllSettings() {
            for (int i = 1; i < this.directories.length; ++i) {
                FileSystemHelper.getInstance().removeDirectory(this.directories[i]);
            }
        }

        public void messageScreenExit(int n) {
            if (n == 2) {
                if (this.directories == null) {
                    if (this.directory == null) {
                        return;
                    }
                    FileSystemHelper.getInstance().removeDirectory(this.directory);
                } else {
                    this.removeAllSettings();
                }
                this.model.deleteItem(-1);
            }
        }

        public void setDirectory(String string) {
            this.directory = string;
        }

        public void setDirectories(String[] stringArray) {
            this.directories = stringArray;
        }

        public void setModel(EListModel eListModel) {
            this.model = eListModel;
        }

        public void installScreen(ScreenManager screenManager) {
            super.installScreen(screenManager);
            this.getHTMLRenderer().addVariableReplacment("$SETTINGS$", this.settingName);
            this.setMessage(this.prompt);
        }
    }

    protected class SettingsListModel
    implements EListModel {
        protected String[] settings = null;

        public SettingsListModel() {
            this.refresh();
        }

        public void refresh() {
            SavedState[] savedStateArray = MeasurementFactory.instance().getDeletableSavedStates();
            this.settings = new String[savedStateArray.length];
            for (int i = 0; i < savedStateArray.length; ++i) {
                this.settings[i] = savedStateArray[i].getName();
            }
            if (this.settings == null) {
                logger.info("settings = null");
                this.settings = new String[0];
                return;
            }
            if (this.settings.length > 0) {
                String[] stringArray = new String[this.settings.length + 1];
                System.arraycopy(this.settings, 0, stringArray, 1, this.settings.length);
                stringArray[0] = "<< " + Text.All + " >>";
                this.settings = stringArray;
            } else {
                this.settings = new String[1];
                this.settings[0] = "<< " + Text.None + " >>";
            }
        }

        public void addListDataListener(EListDataListener eListDataListener) {
        }

        public void removeListDataListener(EListDataListener eListDataListener) {
        }

        public void fireListDataChanged() {
        }

        public int size() {
            return this.settings.length;
        }

        public Object getItem(int n) {
            if (this.size() == 0) {
                return null;
            }
            if (n >= this.size()) {
                n = this.size() - 1;
            }
            if (n < 0) {
                n = 0;
            }
            return this.settings[n];
        }

        public void insertItem(int n, Object object) {
        }

        public void deleteItem(int n) {
            this.refresh();
        }
    }

    private class SettingsSelectionListener
    implements ItemSelectionListener {
        private SettingsSelectionListener() {
        }

        public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
            EListModel eListModel = itemSelectionEvent.getModel();
            if (eListModel.size() <= 1) {
                return;
            }
            ConfirmSettingsDeleteMessageScreen confirmSettingsDeleteMessageScreen = new ConfirmSettingsDeleteMessageScreen(TextMessage.SCREEN_SYSTEM_SETTINGS_DELETE_CONFIRM, 3, 20);
            confirmSettingsDeleteMessageScreen.setModel(eListModel);
            if (itemSelectionEvent.getIndex() == 0) {
                int n = eListModel.size();
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = FileSystemHelper.getInstance().getBaseDirectory() + SYSTEM_SETTINGS_DIR + File.separator + (String)eListModel.getItem(i);
                    logger.debug("**************File to be deleted: " + eListModel.getItem(i));
                }
                confirmSettingsDeleteMessageScreen.setSettingName(Text.All);
                confirmSettingsDeleteMessageScreen.setDirectories(stringArray);
            } else {
                String string = FileSystemHelper.getInstance().getBaseDirectory() + SYSTEM_SETTINGS_DIR + File.separator + itemSelectionEvent.getValue();
                confirmSettingsDeleteMessageScreen.setSettingName((String)itemSelectionEvent.getValue());
                confirmSettingsDeleteMessageScreen.setDirectory(string);
            }
            SystemMenuMgr.this.scn.getScreenManager().pushScreen(confirmSettingsDeleteMessageScreen);
        }
    }

    private class DeviceChecker
    extends Thread {
        private DeviceChecker() {
        }

        public void update() {
            this.interrupt();
        }

        public void run() {
            if (SystemMenuMgr.this.scn.getScreenManager() == null) {
                return;
            }
            while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (SystemMenuMgr.this.deviceCheckerThread == null) {
                    return;
                }
                boolean bl = this.isDeviceReady(0);
                boolean bl2 = this.isDeviceReady(1);
                EventDispatchThread.invokeLater(new Runnable(this, bl, bl2){
                    private final /* synthetic */ boolean val$isPCMCIAReady;
                    private final /* synthetic */ boolean val$isCFReady;
                    private final /* synthetic */ DeviceChecker this$1;
                    {
                        this.this$1 = deviceChecker;
                        this.val$isPCMCIAReady = bl;
                        this.val$isCFReady = bl2;
                    }

                    public void run() {
                        MenuPanel menuPanel = SystemMenuMgr.access$1300(DeviceChecker.access$1200(this.this$1)).getScreenManager().getRightMenuPanel();
                        if (menuPanel == null) {
                            return;
                        }
                        MenuItem[] menuItemArray = menuPanel.getMenuItems();
                        if (menuItemArray == null) {
                            return;
                        }
                        if (menuItemArray.length < 2) {
                            return;
                        }
                        MenuItem menuItem = menuItemArray[0];
                        if (menuItem == null) {
                            return;
                        }
                        if (menuItem.getText().equals(Text.Format_n_PCMCIA)) {
                            menuItem.setEnabled(this.val$isPCMCIAReady);
                            MenuItem menuItem2 = menuItemArray[1];
                            if (menuItem2 != null) {
                                menuItem2.setEnabled(this.val$isCFReady);
                            }
                            menuPanel.repaint();
                        }
                    }
                }, "SystemMenuMgr.DeviceChecker.run");
                Thread.interrupted();
            }
        }

        private boolean isDeviceReady(int n) {
            String string = FileSystemHelper.getInstance().determineDevice(n);
            return string != null;
        }

        static /* synthetic */ SystemMenuMgr access$1200(DeviceChecker deviceChecker) {
            return deviceChecker.SystemMenuMgr.this;
        }
    }

    protected class FormatDeviceButton
    extends MenuItem {
        private final int deviceType;

        public FormatDeviceButton(String string, String string2, int n) {
            super(string, string2);
            this.deviceType = n;
            this.setEnabled(false);
        }

        public void addNotify(MenuPanel menuPanel) {
            SystemMenuMgr.this.startDeviceCheckerThread();
        }

        public void removeNotify() {
            SystemMenuMgr.this.stopDeviceCheckerThread();
        }

        public void press() {
            FormatMessageScreen formatMessageScreen = new FormatMessageScreen(TextMessage.MEDIA_CARD_FORMAT_CONFIRM, true, 4, this.deviceType);
            SystemMenuMgr.this.scn.getScreenManager().pushScreen(formatMessageScreen);
        }
    }

    private class InstallableListButton
    extends ListButton {
        public InstallableListButton(String string, String string2, EListModel eListModel, SettingsModel settingsModel, String string3, ItemSelectionListener itemSelectionListener) {
            super(string, string2, eListModel, settingsModel, string3, itemSelectionListener);
            this.setDrawSelectedItem(false);
        }
    }

    class ValueButtonWithArrow
    extends ValueButton {
        public ValueButtonWithArrow(String string, Value value, Font font, String string2) {
            super(string, value, font, string2);
        }

        protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
            super.drawExtras(graphics, n, n2, n3, n4);
            MenuSymbol.draw(graphics, n, n2, n3, n4);
        }
    }

    private class DataFilenameListener
    implements AlphaEditScreen.AlphaEditScreenExitListener {
        private DataFilenameListener() {
        }

        public void alphaEditScreenExit(int n, String string) {
            if (n == 0) {
                SystemMeasurementSettings.instance().sendDataFilename(string);
            }
        }
    }

    private class ScreenFilenameListener
    implements AlphaEditScreen.AlphaEditScreenExitListener {
        private ScreenFilenameListener() {
        }

        public void alphaEditScreenExit(int n, String string) {
            if (n == 0) {
                SystemMeasurementSettings.instance().sendScreenFilename(string);
            }
        }
    }
}

