/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.systemFunctions;

import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.MessageScreenListener;
import elgato.infrastructure.mainScreens.ProductFactory;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.systemFunctions.SystemMenuMgr;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.NetworkConfiguration;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.EListModel;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;

public class SystemScreen
extends Screen {
    static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$systemFunctions$SystemScreen == null ? (class$elgato$infrastructure$systemFunctions$SystemScreen = SystemScreen.class$("elgato.infrastructure.systemFunctions.SystemScreen")) : class$elgato$infrastructure$systemFunctions$SystemScreen);
    private static final Resources systemResources = Resources.getResources("elgato.system");
    static final String SYSTEM_SETTINGS_DIR = systemResources.getString("system.settings.directory");
    private SystemMenuMgr menuMgr;
    private static boolean isActive;
    NetworkConfiguration networkConfigModel;
    final SystemMeasurementSettings settings = SystemMeasurementSettings.instance();
    static /* synthetic */ Class class$elgato$infrastructure$systemFunctions$SystemScreen;

    public SystemScreen() {
        this.createMenuMgr();
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.menuMgr.loadLeftButtonMenu(screenManager);
        this.addValueListeners();
        isActive = true;
    }

    protected SystemMenuMgr createMenuMgr() {
        this.menuMgr = ProductFactory.getInstance().createSystemMenuMgr(this, this.settings);
        return this.menuMgr;
    }

    private void addValueListeners() {
        this.menuMgr.addValueListeners();
    }

    private void removeValueListeners() {
        this.menuMgr.removeValueListeners();
    }

    public void uninstallScreen(ScreenManager screenManager) {
        isActive = false;
        this.removeValueListeners();
        if (this.networkConfigModel != null) {
            this.networkConfigModel.getDhcpEnabled().addValueListener(this.menuMgr.getDhcpValueListener());
        }
        this.menuMgr.removeDhcpValueListener();
        super.uninstallScreen(screenManager);
    }

    public static boolean isActive() {
        return isActive;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            MenuPanel menuPanel;
            ScreenManager screenManager = MeasurementFactory.instance().getScreenManager();
            if (screenManager != null && (menuPanel = screenManager.getRightMenuPanel()) != null && this.showingEscapableRightMenu(menuPanel.getMenu())) {
                menuPanel.getMenuItems()[6].press();
            }
        } else {
            super.keyPressed(keyEvent);
        }
    }

    private boolean showingEscapableRightMenu(Menu menu) {
        return menu.getTitle().equals(Text.Save_Data) || menu.getTitle().equals(Text.Fr_slash_Time_Ref) || menu.getTitle().equals(Text.Print_Screen);
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        Screen screen = this.getScreenManager().getPreviousScreen();
        if (screen != null) {
            return screen.filterPrintImage(image, rectangle);
        }
        return super.filterPrintImage(image, rectangle);
    }

    public SystemMenuMgr getMenuMgr() {
        return this.menuMgr;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConfirmSettingsDeleteMessageScreen
    extends MessageScreen
    implements MessageScreenListener {
        String prompt = "";
        String directory = "";
        EListModel model = null;
        String[] directories = null;
        String settingName = "";

        public ConfirmSettingsDeleteMessageScreen(String string, int n, int n2) {
            super("", true, n, n2);
            this.prompt = string;
            this.addListener(this);
        }

        public void setSettingName(String string) {
            this.settingName = string;
        }

        private void removeAllSettings() {
            for (int i = 1; i < this.directories.length; ++i) {
                FileSystemHelper.getInstance().removeDirectory(this.directories[i]);
            }
        }

        public void messageScreenExit(int n) {
            if (n == 2) {
                if (this.directories == null) {
                    if (this.directory == null) {
                        return;
                    }
                    FileSystemHelper.getInstance().removeDirectory(this.directory);
                } else {
                    this.removeAllSettings();
                }
                this.model.deleteItem(-1);
            }
        }

        public void setDirectory(String string) {
            this.directory = string;
        }

        public void setDirectories(String[] stringArray) {
            this.directories = stringArray;
        }

        public void setModel(EListModel eListModel) {
            this.model = eListModel;
        }

        public void installScreen(ScreenManager screenManager) {
            super.installScreen(screenManager);
            this.getHTMLRenderer().addVariableReplacment("$SETTINGS$", this.settingName);
            this.setMessage(this.prompt);
        }
    }
}

