/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.systemFunctions;

import elgato.infrastructure.html.HTMLScreen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.mainScreens.VersionPopup;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.ScreenButton;
import elgato.infrastructure.systemFunctions.BatteryReconditionScreen;
import elgato.infrastructure.util.SystemProcess;
import elgato.infrastructure.util.Text;
import elgato.measurement.powerSupply.PowerSupplyMonitor;
import elgato.measurement.powerSupply.PowerSupplyReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SystemStatisticsScreen
extends HTMLScreen {
    public static final int INSTRUMENT = 0;
    public static final int MEMORY = 1;
    public static final int REVISION = 2;
    public static final int BATTERY = 3;
    public static final int COPYRIGHTS = 4;
    ScreenButton reconditionButton;
    private final int screenType;
    private PowerSupplyMonitor.ChangeListener powerSupplyListener;
    static /* synthetic */ Class class$elgato$infrastructure$mainScreens$VersionPopup;

    public SystemStatisticsScreen(ScreenManager screenManager, int n) {
        super(screenManager, false, "");
        this.screenType = n;
    }

    public void installScreen(ScreenManager screenManager) {
        Menu menu = super.buildRightMenu();
        if (this.screenType == 2) {
            screenManager.installLeftMenu(new Menu("", new MenuItem[0]));
            screenManager.installRightMenu(new Menu("", new MenuItem[0]));
            MessagePanel messagePanel = new MessagePanel();
            screenManager.installDisplay(messagePanel);
            screenManager.getLeftMenuPanel().paintImmediately(new Rectangle(screenManager.getLeftMenuPanel().getSize()));
            screenManager.getRightMenuPanel().paintImmediately(new Rectangle(screenManager.getRightMenuPanel().getSize()));
            messagePanel.paintImmediately(new Rectangle(screenManager.getInstalledDisplay().getSize()));
        }
        if (this.screenType == 3) {
            menu.setMenuItem(this.createReconditionButton(), 3);
            menu.getItems()[6].setText(Text.Back);
            this.powerSupplyListener = new PowerSupplyMonitor.ChangeListener(){

                public void stateChanged() {
                    PowerSupplyMonitor powerSupplyMonitor = PowerSupplyMonitor.instance();
                    SystemStatisticsScreen.this.reconditionButton.setEnabled(powerSupplyMonitor.isReconditioningSupported());
                    SystemStatisticsScreen.this.htmlRenderer.setText(SystemStatisticsScreen.this.makeContent());
                    SystemStatisticsScreen.this.htmlRenderer.repaint();
                }
            };
            PowerSupplyMonitor.instance().addChangeListener(this.powerSupplyListener);
        }
        if (this.screenType == 4) {
            menu.getItems()[6].setText(Text.Back);
        }
        this.htmlRenderer.setText(this.makeContent());
        this.htmlRenderer.render();
        super.installScreen(screenManager);
        if (this.screenType == 3) {
            screenManager.installRightMenu(menu);
        }
    }

    MenuItem createReconditionButton() {
        this.reconditionButton = ScreenButton.newPushingButtonWithArrow(Text.Recondition, new BatteryReconditionScreen());
        this.reconditionButton.setEnabled(false);
        return this.reconditionButton;
    }

    public void uninstallScreen(ScreenManager screenManager) {
        if (this.screenType == 3) {
            PowerSupplyMonitor.instance().removeChangeListener(this.powerSupplyListener);
        }
        super.uninstallScreen(screenManager);
    }

    protected String makeContent() {
        return "<html><body><h1>" + Text.System_Statistics + " -- " + SystemStatisticsScreen.getStatisticName(this.screenType).replace('\n', ' ') + "</h1>" + this.getStatData() + "</body></html>";
    }

    protected String getStatData() {
        switch (this.screenType) {
            case 1: {
                return this.memoryData();
            }
            case 2: {
                return this.revisionData();
            }
            case 3: {
                return PowerSupplyReader.readBatteryData();
            }
            case 4: {
                return "<br><br>" + Text.CopyrightNotice;
            }
        }
        return "";
    }

    String getStatisticName() {
        return SystemStatisticsScreen.getStatisticName(this.screenType);
    }

    static String getStatisticName(int n) {
        switch (n) {
            case 1: {
                return Text.Memory;
            }
            case 0: {
                return Text.Instrument_n_Info;
            }
            case 2: {
                return Text.Rev_Info;
            }
            case 3: {
                return Text.Battery;
            }
            case 4: {
                return Text.Copyrights;
            }
        }
        return "";
    }

    private String memoryData() {
        String[] stringArray = this.getMemoryInfo();
        StringBuffer stringBuffer = new StringBuffer("<table>");
        stringBuffer.append("<tr><td colspan=3> &nbsp; </td></tr>");
        stringBuffer.append("<tr><td width=\"35%\"><b><u>Device</u></b></td><td width=\"30%\"><b><u>Size</u></b></td><td width=\"35%\"><b><u>Available</u></b></td></tr>");
        stringBuffer.append("<tr><td colspan=3> &nbsp; </td></tr>");
        stringBuffer.append("<tr><td width=\"35%\">System RAM</td><td width=\"30%\">" + stringArray[0] + "</td><td width=\"35%\">" + stringArray[1] + "</td></tr>");
        stringBuffer.append("<tr><td width=\"35%\">Internal Flash</td><td width=\"30%\">" + stringArray[2] + "</td><td width=\"35%\">" + stringArray[3] + "</td></tr>");
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    String[] getMemoryInfo() {
        String string;
        int n;
        String string2 = "ramT";
        String string3 = "ramA";
        String string4 = "diskT";
        String string5 = "diskA";
        SystemProcess systemProcess = new SystemProcess("df");
        systemProcess.execute(true);
        Vector vector = systemProcess.getProcessOutput();
        for (n = 0; n < vector.size(); ++n) {
            string = (String)vector.elementAt(n);
            if (!string.trim().endsWith("/flash") && !string.trim().endsWith("/")) continue;
            string4 = this.getField(string, 1) + " kB";
            string5 = this.getField(string, 3) + " kB";
        }
        systemProcess = new SystemProcess("cat /proc/meminfo");
        systemProcess.execute(true);
        vector = systemProcess.getProcessOutput();
        for (n = 0; n < vector.size(); ++n) {
            string = (String)vector.elementAt(n);
            if (string.startsWith("MemTotal:")) {
                string2 = string.substring(9).trim();
                continue;
            }
            if (!string.startsWith("MemFree:")) continue;
            string3 = string.substring(8).trim();
        }
        return new String[]{string2, string3, string4, string5};
    }

    private String getField(String string, int n) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            boolean bl2;
            char c = cArray[i];
            boolean bl3 = bl2 = c != ' ';
            if (!bl && bl2) {
                ++n2;
            }
            if (bl2 && n2 == n) {
                stringBuffer.append(c);
            }
            bl = bl2;
        }
        return stringBuffer.toString();
    }

    String revisionData() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<table><tr><td width=\"40%\"><B>Component</B></td><td width=\"60%\"><B>Revision</B></td></tr><tr><td colspan=2> &nbsp; </td></tr>");
        this.appendRevisionRow(stringBuffer, "gui_version", VersionPopup.getVersion());
        this.appendRevisionRow(stringBuffer, "gui_timestamp", this.getBuildTimestamp());
        this.appendRevisionRow(stringBuffer, "jvm_version", this.getJVMVersionString());
        MeasurementFactory measurementFactory = MeasurementFactory.instance();
        measurementFactory.retrieveRevisionInfo();
        String[] stringArray = measurementFactory.getRevisionComponentNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.appendRevisionRow(stringBuffer, string, measurementFactory.getComponentRevision(string));
        }
        stringBuffer.append("<tr><td colspan=2> &nbsp; </td></tr></table>");
        return stringBuffer.toString();
    }

    private String getJVMVersionString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("java.vm.name")).append(" version ");
        String string = System.getProperty("java.vm.version");
        if (string == null) {
            string = System.getProperty("jvm.version");
        }
        if (string == null) {
            string = Text.Unknown;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private void appendRevisionRow(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("<tr><td width=\"40%\">").append(Text.getServerName(string)).append("</td><td width=\"60%\">").append(string2).append("</td></tr>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBuildTimestamp() {
        InputStream inputStream = (class$elgato$infrastructure$mainScreens$VersionPopup == null ? (class$elgato$infrastructure$mainScreens$VersionPopup = SystemStatisticsScreen.class$("elgato.infrastructure.mainScreens.VersionPopup")) : class$elgato$infrastructure$mainScreens$VersionPopup).getResourceAsStream("/elgato/timestamp.bld");
        if (inputStream == null) {
            return "no timestamp file (Ant should generate this)";
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[100];
            while ((n = inputStreamReader.read(cArray)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (IOException iOException) {
            String string = "timestamp file failure";
            return string;
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class MessagePanel
    extends JPanel {
        public MessagePanel() {
            JLabel jLabel = new JLabel(Text.Please_wait_while_the_revision_info_loads);
            jLabel.setVerticalAlignment(0);
            jLabel.setHorizontalAlignment(0);
            this.setLayout(new BorderLayout());
            this.add((Component)jLabel, "Center");
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        }
    }
}

