/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.systemFunctions;

import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandTimeoutException;
import elgato.infrastructure.html.HTMLRenderer;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.ModalKeyManager;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.tablelayout.TableLayoutConstraints;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.TextMessage;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurementSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimeBaseAdjustmentScreen
extends Screen {
    Logger logger = LogManager.getLogger(class$elgato$infrastructure$systemFunctions$TimeBaseAdjustmentScreen == null ? (class$elgato$infrastructure$systemFunctions$TimeBaseAdjustmentScreen = TimeBaseAdjustmentScreen.class$("elgato.infrastructure.systemFunctions.TimeBaseAdjustmentScreen")) : class$elgato$infrastructure$systemFunctions$TimeBaseAdjustmentScreen);
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$mainScreens$CautionErrorMessageScreen == null ? (class$elgato$infrastructure$mainScreens$CautionErrorMessageScreen = TimeBaseAdjustmentScreen.class$("elgato.infrastructure.mainScreens.CautionErrorMessageScreen")) : class$elgato$infrastructure$mainScreens$CautionErrorMessageScreen).getName());
    private static final HydroBorderPainterConfig BORDER_CONFIG = res.getBorderConfig("border");
    PushButton continueButton;
    PushButton cancelButton = new PushButton(Text.Cancel, this.getContextString("system.adjustments.cancel"), new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            TimeBaseAdjustmentScreen.this.getScreenManager().popScreen();
            TimeBaseAdjustmentScreen.this.turnOffGpsDisplay();
        }
    });
    private PushButton finishButton = new PushButton(Text.Finish, this.getContextString("system.adjustments.finish"), new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            TimeBaseAdjustmentScreen.this.getScreenManager().popScreen();
            TimeBaseAdjustmentScreen.this.turnOffGpsDisplay();
        }
    });
    private Command repeatCommand;
    private Command existingCommand;
    Command createResponse;
    Command existingResponse;
    private ValueListener ppsListener = new ValueListener(){
        private final String listenerName = "TimeBaseAdjScreen.ppsListener";

        public String getListenerName() {
            return "TimeBaseAdjScreen.ppsListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            if (TimeFreqRefMeasurementSettings.instance().isInternalGps()) {
                if (valueInterface.intValue() == 1) {
                    TimeBaseAdjustmentScreen.this.continueButton.setEnabled(true);
                } else {
                    TimeBaseAdjustmentScreen.this.continueButton.setEnabled(false);
                }
            }
        }
    };
    public static final String Property_Dac = "dac";
    static /* synthetic */ Class class$elgato$infrastructure$systemFunctions$TimeBaseAdjustmentScreen;
    static /* synthetic */ Class class$elgato$infrastructure$mainScreens$CautionErrorMessageScreen;

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.getScreenManager().installLeftMenu(new Menu(Text.System, new MenuItem[0]));
        this.getScreenManager().installRightMenu(this.createRightMenu());
        this.getScreenManager().installDisplay(this.createPanel());
        GlobalKeyManager.registerInstance(new ModalKeyManager(screenManager){

            public void processKeyPress(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 76) {
                    TimeBaseAdjustmentScreen.this.cancelButton.press();
                } else {
                    this.processSoftkeyPress(keyEvent);
                }
            }
        });
        this.repeatCommand = new Command("getRxDacSetting");
        this.repeatCommand.addProperty("type", "create");
        this.existingCommand = new Command("getRxDacSetting");
        this.existingCommand.addProperty("type", "existing");
        TimeFreqRefMeasurementSettings.instance().getPpsState().addValueListener(this.ppsListener);
    }

    public void uninstallScreen(ScreenManager screenManager) {
        super.uninstallScreen(screenManager);
        GlobalKeyManager.makeInstance(screenManager);
        TimeFreqRefMeasurementSettings.instance().getPpsState().removeValueListener(this.ppsListener);
    }

    JComponent createPanel() {
        HTMLRenderer hTMLRenderer = new HTMLRenderer();
        if (TimeFreqRefMeasurementSettings.instance().isInternalGps()) {
            hTMLRenderer.setText(TextMessage.ADJUSTMENT_SETUP);
        } else {
            hTMLRenderer.setText(TextMessage.ADJUSTMENT_GPS);
        }
        hTMLRenderer.render();
        return new BorderWrapper(hTMLRenderer, BORDER_CONFIG, true);
    }

    Menu createRightMenu() {
        MultiStateActuatorButton multiStateActuatorButton = null;
        if (TimeFreqRefMeasurementSettings.instance().isInternalGps()) {
            this.continueButton = this.createAdjustmentSetupContinueButton();
            multiStateActuatorButton = new MultiStateActuatorButton(DisplayGlobalMeasurementSettings.instance().getGpsLocationToggle(), this.getContextString("gps"), "TimeBaseAdjScreen.gpsButton");
            Color color = this.getScreenManager().getGpsDotColor();
            if (color != Color.green && TimeFreqRefMeasurementSettings.instance().isInternalGps()) {
                this.continueButton.setEnabled(false);
            } else {
                this.continueButton.setEnabled(true);
            }
        } else {
            this.continueButton = this.createNotGpsContinueButton();
            multiStateActuatorButton = null;
        }
        return new Menu(Text.Time_Base_Adj, new MenuItem[]{this.continueButton, null, null, multiStateActuatorButton, null, null, this.cancelButton});
    }

    void turnOffGpsDisplay() {
        if (DisplayGlobalMeasurementSettings.instance().getGpsLocationToggle().intValue() == 1) {
            DisplayGlobalMeasurementSettings.instance().getGpsLocationToggle().setValue(0);
        }
    }

    private PushButton createAdjustmentSetupContinueButton() {
        return new PushButton(Text.Continue, this.getContextString("system.adjustments.continue"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TimeBaseAdjustmentScreen.this.getScreenManager().isGpsLocked()) {
                    TimeBaseAdjustmentScreen.this.turnOffGpsDisplay();
                    TimeBaseAdjustmentScreen.this.installResultsScreenRightMenu();
                    try {
                        TimeBaseAdjustmentScreen.this.setCreateResponse();
                        TimeBaseAdjustmentScreen.this.setExistingResponse();
                        TimeBaseAdjustmentScreen.this.getScreenManager().installDisplay(TimeBaseAdjustmentScreen.this.createResultsPanel(TimeBaseAdjustmentScreen.this.existingResponse, TimeBaseAdjustmentScreen.this.createResponse));
                    }
                    catch (CommandTimeoutException commandTimeoutException) {
                        TimeBaseAdjustmentScreen.this.logger.error("no response from server for getRxDacSetting");
                    }
                    catch (InterruptedException interruptedException) {
                        TimeBaseAdjustmentScreen.this.logger.error("no response from server for getRxDacSetting");
                    }
                }
            }
        });
    }

    protected void setExistingResponse() throws CommandTimeoutException, InterruptedException {
        this.existingResponse = MeasurementFactory.instance().getCommandProcessor().call(this.existingCommand, "setRxDacSetting");
    }

    protected void setCreateResponse() throws CommandTimeoutException, InterruptedException {
        this.createResponse = MeasurementFactory.instance().getCommandProcessor().call(this.repeatCommand, "setRxDacSetting");
    }

    Component createResultsPanel(Command command, Command command2) {
        JPanel jPanel = new JPanel(new TableLayout(new float[][]{{0.05f, 0.33f, 0.33f, -1.0f, 0.05f}, {-1.0f, 0.1f, 0.1f, 0.1f, 0.1f, 0.5f}}));
        jPanel.setBackground(Color.white);
        JLabel jLabel = new JLabel("Time Base Adjustment", 0);
        jLabel.setFont(new Font("SansSerif", 1, 16));
        jPanel.add((Component)jLabel, TableLayoutConstraints.newSpan(0, 0, 4, 0));
        jPanel.add((Component)this.createLabel(Text.Old), TableLayoutConstraints.newCell(2, 1));
        jPanel.add((Component)this.createLabel(Text.New), TableLayoutConstraints.newCell(3, 1));
        jPanel.add((Component)this.createLabel(Text.Time_Base_DAC_Setting), TableLayoutConstraints.newCell(1, 2));
        jPanel.add((Component)this.createLabel(command.getProperty(Property_Dac)), TableLayoutConstraints.newCell(2, 2));
        jPanel.add((Component)this.createLabel(command2.getProperty(Property_Dac)), TableLayoutConstraints.newCell(3, 2));
        jPanel.add((Component)this.createLabel(Text.Calibration_Time), TableLayoutConstraints.newCell(1, 3));
        jPanel.add((Component)this.createLabel(this.getDate(command)), TableLayoutConstraints.newCell(2, 3));
        jPanel.add((Component)this.createLabel(this.getDate(command2)), TableLayoutConstraints.newCell(3, 3));
        jPanel.add((Component)this.createTimeLabel(this.getTime(command)), TableLayoutConstraints.newCell(2, 4));
        jPanel.add((Component)this.createTimeLabel(this.getTime(command2)), TableLayoutConstraints.newCell(3, 4));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(null);
        jPanel2.add((Component)this.createLabel(Text.Store_And_Repeat_Information), "Center");
        jPanel.add((Component)jPanel2, TableLayoutConstraints.newSpan(1, 5, 3, 5));
        return jPanel;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("SansSerif", 1, 12));
        return jLabel;
    }

    private JLabel createTimeLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setVerticalAlignment(1);
        jLabel.setFont(new Font("SansSerif", 1, 12));
        return jLabel;
    }

    protected String getTime(Command command) {
        long l = Long.parseLong(command.getProperty("utc"));
        if (l == 0L) {
            return "";
        }
        Date date = new Date(l * 1000L);
        String string = "HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        return simpleDateFormat.format(date);
    }

    protected String getDate(Command command) {
        long l = Long.parseLong(command.getProperty("utc"));
        if (l == 0L) {
            return Text.Factory;
        }
        Date date = new Date(l * 1000L);
        String string = "MM/dd/yyyy";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        return simpleDateFormat.format(date);
    }

    void installResultsScreenRightMenu() {
        this.getScreenManager().installRightMenu(this.createResultsScreenRightMenu());
    }

    protected Menu createResultsScreenRightMenu() {
        return new Menu(Text.Time_Base_Adj, new MenuItem[]{new PushButton(Text.Store, this.getContextString("adjustment.store"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementFactory.instance().getCommandProcessor().send(TimeBaseAdjustmentScreen.this.createResponse);
                try {
                    TimeBaseAdjustmentScreen.this.setExistingResponse();
                }
                catch (CommandTimeoutException commandTimeoutException) {
                    TimeBaseAdjustmentScreen.this.logger.error("no response from server for getRxDacSetting");
                }
                catch (InterruptedException interruptedException) {
                    TimeBaseAdjustmentScreen.this.logger.error("no response from server for getRxDacSetting");
                }
                TimeBaseAdjustmentScreen.this.getScreenManager().installDisplay(TimeBaseAdjustmentScreen.this.createResultsPanel(TimeBaseAdjustmentScreen.this.existingResponse, TimeBaseAdjustmentScreen.this.createResponse));
            }
        }), new PushButton(Text.Repeat, this.getContextString("adjustment.repeat"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TimeBaseAdjustmentScreen.this.setCreateResponse();
                    TimeBaseAdjustmentScreen.this.getScreenManager().installDisplay(TimeBaseAdjustmentScreen.this.createResultsPanel(TimeBaseAdjustmentScreen.this.existingResponse, TimeBaseAdjustmentScreen.this.createResponse));
                }
                catch (CommandTimeoutException commandTimeoutException) {
                    TimeBaseAdjustmentScreen.this.logger.error("no response from server for getRxDacSetting");
                }
                catch (InterruptedException interruptedException) {
                    TimeBaseAdjustmentScreen.this.logger.error("no response from server for getRxDacSetting");
                }
            }
        }), null, null, null, null, this.finishButton});
    }

    private PushButton createNotGpsContinueButton() {
        return new PushButton(Text.Continue, this.getContextString("system.adjustments.continue"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeFreqRefMeasurementSettings.instance().getTimeFreqRef().setValue(30);
                TimeFreqRefMeasurementSettings.instance().getTimeFreqRef().send();
                TimeBaseAdjustmentScreen.this.getScreenManager().installRightMenu(TimeBaseAdjustmentScreen.this.createRightMenu());
                TimeBaseAdjustmentScreen.this.getScreenManager().installDisplay(TimeBaseAdjustmentScreen.this.createPanel());
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

