/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.tablelayout;

import elgato.infrastructure.tablelayout.TableLayoutConstants;
import elgato.infrastructure.tablelayout.TableLayoutConstraints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Vector;

public final class TableLayout
implements LayoutManager2,
Serializable,
TableLayoutConstants {
    private static final float[][] defaultSize = new float[][]{new float[0], new float[0]};
    private float[] columnSpec;
    private float[] rowSpec;
    private int[] columnSize;
    private int[] rowSize;
    private int[] columnOffset;
    private int[] rowOffset;
    private Vector list;
    private boolean dirty;
    private int oldWidth;
    private int oldHeight;

    public TableLayout() {
        this(defaultSize);
    }

    public TableLayout(float[][] fArray) {
        if (fArray != null && fArray.length == 2) {
            int n;
            float[] fArray2 = fArray[0];
            float[] fArray3 = fArray[1];
            this.columnSpec = new float[fArray2.length];
            this.rowSpec = new float[fArray3.length];
            System.arraycopy(fArray2, 0, this.columnSpec, 0, this.columnSpec.length);
            System.arraycopy(fArray3, 0, this.rowSpec, 0, this.rowSpec.length);
            for (n = 0; n < this.columnSpec.length; ++n) {
                if (!(this.columnSpec[n] < 0.0f) || this.columnSpec[n] == -1.0f || this.columnSpec[n] == -2.0f || this.columnSpec[n] == -3.0f) continue;
                this.columnSpec[n] = 0.0f;
            }
            for (n = 0; n < this.rowSpec.length; ++n) {
                if (!(this.rowSpec[n] < 0.0f) || this.rowSpec[n] == -1.0f || this.rowSpec[n] == -2.0f || this.rowSpec[n] == -3.0f) continue;
                this.rowSpec[n] = 0.0f;
            }
        } else {
            float[] fArray4 = new float[]{-1.0f};
            float[] fArray5 = new float[]{-1.0f};
            this.setColumn(fArray4);
            this.setRow(fArray5);
        }
        this.list = new Vector();
        this.dirty = true;
    }

    public TableLayoutConstraints getConstraints(Component component) {
        for (int i = 0; i < this.list.size(); ++i) {
            Entry entry = (Entry)this.list.elementAt(i);
            if (entry.component != component) continue;
            return new TableLayoutConstraints(entry.col1, entry.row1, entry.col2, entry.row2, entry.hAlign, entry.vAlign);
        }
        return null;
    }

    public void setConstraints(Component component, TableLayoutConstraints tableLayoutConstraints) {
        if (component == null) {
            throw new IllegalArgumentException("Parameter component cannot be null.");
        }
        if (tableLayoutConstraints == null) {
            throw new IllegalArgumentException("Parameter constraint cannot be null.");
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Entry entry = (Entry)this.list.elementAt(i);
            if (entry.component != component) continue;
            this.list.setElementAt(new Entry(component, tableLayoutConstraints), i);
        }
    }

    public void setColumn(float[] fArray) {
        this.columnSpec = new float[fArray.length];
        System.arraycopy(fArray, 0, this.columnSpec, 0, this.columnSpec.length);
        for (int i = 0; i < this.columnSpec.length; ++i) {
            if (!(this.columnSpec[i] < 0.0f) || this.columnSpec[i] == -1.0f || this.columnSpec[i] == -2.0f || this.columnSpec[i] == -3.0f) continue;
            this.columnSpec[i] = 0.0f;
        }
        this.dirty = true;
    }

    public void setRow(float[] fArray) {
        this.rowSpec = new float[fArray.length];
        System.arraycopy(fArray, 0, this.rowSpec, 0, this.rowSpec.length);
        for (int i = 0; i < this.rowSpec.length; ++i) {
            if (!(this.rowSpec[i] < 0.0f) || this.rowSpec[i] == -1.0f || this.rowSpec[i] == -2.0f || this.rowSpec[i] == -3.0f) continue;
            this.rowSpec[i] = 0.0f;
        }
        this.dirty = true;
    }

    public void setColumn(int n, float f) {
        if (f < 0.0f && f != -1.0f && f != -2.0f && f != -3.0f) {
            f = 0.0f;
        }
        this.columnSpec[n] = f;
        this.dirty = true;
    }

    public void setRow(int n, float f) {
        if (f < 0.0f && f != -1.0f && f != -2.0f && f != -3.0f) {
            f = 0.0f;
        }
        this.rowSpec[n] = f;
        this.dirty = true;
    }

    public float[] getColumn() {
        float[] fArray = new float[this.columnSpec.length];
        System.arraycopy(this.columnSpec, 0, fArray, 0, fArray.length);
        return fArray;
    }

    public float[] getRow() {
        float[] fArray = new float[this.rowSpec.length];
        System.arraycopy(this.rowSpec, 0, fArray, 0, fArray.length);
        return fArray;
    }

    public float getColumn(int n) {
        return this.columnSpec[n];
    }

    public float getRow(int n) {
        return this.rowSpec[n];
    }

    public int getNumColumn() {
        return this.columnSpec.length;
    }

    public int getNumRow() {
        return this.rowSpec.length;
    }

    public void insertColumn(int n, float f) {
        if (n < 0 || n > this.columnSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n + ".  Valid range is [0, " + this.columnSpec.length + "].");
        }
        if (f < 0.0f && f != -1.0f && f != -2.0f && f != -3.0f) {
            f = 0.0f;
        }
        float[] fArray = new float[this.columnSpec.length + 1];
        System.arraycopy(this.columnSpec, 0, fArray, 0, n);
        System.arraycopy(this.columnSpec, n, fArray, n + 1, this.columnSpec.length - n);
        fArray[n] = f;
        this.columnSpec = fArray;
        for (int i = 0; i < this.list.size(); ++i) {
            Entry entry = (Entry)this.list.elementAt(i);
            if (entry.col1 >= n) {
                ++entry.col1;
            }
            if (entry.col2 < n) continue;
            ++entry.col2;
        }
        this.dirty = true;
    }

    public void insertRow(int n, float f) {
        if (n < 0 || n > this.rowSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n + ".  Valid range is [0, " + this.rowSpec.length + "].");
        }
        if (f < 0.0f && f != -1.0f && f != -2.0f && f != -3.0f) {
            f = 0.0f;
        }
        float[] fArray = new float[this.rowSpec.length + 1];
        System.arraycopy(this.rowSpec, 0, fArray, 0, n);
        System.arraycopy(this.rowSpec, n, fArray, n + 1, this.rowSpec.length - n);
        fArray[n] = f;
        this.rowSpec = fArray;
        for (int i = 0; i < this.list.size(); ++i) {
            Entry entry = (Entry)this.list.elementAt(i);
            if (entry.row1 >= n) {
                ++entry.row1;
            }
            if (entry.row2 < n) continue;
            ++entry.row2;
        }
        this.dirty = true;
    }

    public void deleteColumn(int n) {
        if (n < 0 || n >= this.columnSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n + ".  Valid range is [0, " + (this.columnSpec.length - 1) + "].");
        }
        float[] fArray = new float[this.columnSpec.length - 1];
        System.arraycopy(this.columnSpec, 0, fArray, 0, n);
        System.arraycopy(this.columnSpec, n + 1, fArray, n, this.columnSpec.length - n - 1);
        this.columnSpec = fArray;
        for (int i = 0; i < this.list.size(); ++i) {
            Entry entry = (Entry)this.list.elementAt(i);
            if (entry.col1 >= n) {
                --entry.col1;
            }
            if (entry.col2 < n) continue;
            --entry.col2;
        }
        this.dirty = true;
    }

    public void deleteRow(int n) {
        if (n < 0 || n >= this.rowSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n + ".  Valid range is [0, " + (this.rowSpec.length - 1) + "].");
        }
        float[] fArray = new float[this.rowSpec.length - 1];
        System.arraycopy(this.rowSpec, 0, fArray, 0, n);
        System.arraycopy(this.rowSpec, n + 1, fArray, n, this.rowSpec.length - n - 1);
        this.rowSpec = fArray;
        for (int i = 0; i < this.list.size(); ++i) {
            Entry entry = (Entry)this.list.elementAt(i);
            if (entry.row1 >= n) {
                --entry.row1;
            }
            if (entry.row2 < n) continue;
            --entry.row2;
        }
        this.dirty = true;
    }

    public String toString() {
        int n;
        String string = "TableLayout {{";
        if (this.columnSpec.length > 0) {
            for (n = 0; n < this.columnSpec.length - 1; ++n) {
                string = string + this.columnSpec[n] + ", ";
            }
            string = string + this.columnSpec[this.columnSpec.length - 1] + "}, {";
        } else {
            string = string + "}, {";
        }
        if (this.rowSpec.length > 0) {
            for (n = 0; n < this.rowSpec.length - 1; ++n) {
                string = string + this.rowSpec[n] + ", ";
            }
            string = string + this.rowSpec[this.rowSpec.length - 1] + "}}";
        } else {
            string = string + "}}";
        }
        return string;
    }

    public void drawGrid(Container container, Graphics graphics) {
        Dimension dimension = container.getSize();
        if (this.dirty || dimension.width != this.oldWidth || dimension.height != this.oldHeight) {
            this.calculateSize(container);
        }
        int n = 0;
        for (int i = 0; i < this.rowSize.length; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.columnSize.length; ++j) {
                Color color = new Color((int)(Math.random() * 1.6777215E7));
                graphics.setColor(color);
                graphics.fillRect(n2, n, this.columnSize[j], this.rowSize[i]);
                n2 += this.columnSize[j];
            }
            n += this.rowSize[i];
        }
    }

    public boolean hidden() {
        boolean bl = false;
        for (int i = 0; i < this.list.size(); ++i) {
            Entry entry = (Entry)this.list.elementAt(i);
            if (entry.row1 >= 0 && entry.col1 >= 0 && entry.row2 <= this.rowSpec.length && entry.col2 <= this.columnSpec.length) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean overlapping() {
        int n = this.list.size();
        if (n == 0) {
            return false;
        }
        boolean bl = false;
        block0: for (int i = 1; i < n; ++i) {
            Entry entry = (Entry)this.list.elementAt(i);
            for (int j = i - 1; j >= 0; --j) {
                Entry entry2 = (Entry)this.list.elementAt(j);
                if ((entry2.col1 < entry.col1 || entry2.col1 > entry.col2 || entry2.row1 < entry.row1 || entry2.row1 > entry.row2) && (entry2.col2 < entry.col1 || entry2.col2 > entry.col2 || entry2.row2 < entry.row1 || entry2.row2 > entry.row2)) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    private void calculateSize(Container container) {
        int n;
        int n2;
        int n3;
        Dimension dimension;
        Entry entry;
        int n4;
        int n5;
        int n6;
        int n7 = this.columnSpec.length;
        int n8 = this.rowSpec.length;
        this.columnSize = new int[n7];
        this.rowSize = new int[n8];
        Insets insets = container.getInsets();
        Dimension dimension2 = container.getSize();
        int n9 = dimension2.width - insets.left - insets.right;
        int n10 = dimension2.height - insets.top - insets.bottom;
        int n11 = n9;
        int n12 = n10;
        for (n6 = 0; n6 < n7; ++n6) {
            if (!(this.columnSpec[n6] >= 1.0f) && this.columnSpec[n6] != 0.0f) continue;
            this.columnSize[n6] = (int)(this.columnSpec[n6] + 0.5f);
            n11 -= this.columnSize[n6];
        }
        for (n6 = 0; n6 < n8; ++n6) {
            if (!(this.rowSpec[n6] >= 1.0f) && this.rowSpec[n6] != 0.0f) continue;
            this.rowSize[n6] = (int)(this.rowSpec[n6] + 0.5f);
            n12 -= this.rowSize[n6];
        }
        for (n6 = 0; n6 < n7; ++n6) {
            if (this.columnSpec[n6] != -2.0f && this.columnSpec[n6] != -3.0f) continue;
            n5 = 0;
            for (n4 = 0; n4 < this.list.size(); ++n4) {
                entry = (Entry)this.list.elementAt(n4);
                if (entry.col1 != n6 || entry.col2 != n6) continue;
                dimension = this.columnSpec[n6] == -2.0f ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                int n13 = n3 = dimension == null ? 0 : dimension.width;
                if (n5 >= n3) continue;
                n5 = n3;
            }
            this.columnSize[n6] = n5;
            n11 -= n5;
        }
        for (n6 = 0; n6 < n8; ++n6) {
            if (this.rowSpec[n6] != -2.0f && this.rowSpec[n6] != -3.0f) continue;
            n5 = 0;
            for (n4 = 0; n4 < this.list.size(); ++n4) {
                entry = (Entry)this.list.elementAt(n4);
                if (entry.row1 != n6 || entry.row2 != n6) continue;
                dimension = this.rowSpec[n6] == -2.0f ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                int n14 = n3 = dimension == null ? 0 : dimension.height;
                if (n5 >= n3) continue;
                n5 = n3;
            }
            this.rowSize[n6] = n5;
            n12 -= n5;
        }
        n6 = n11;
        n5 = n12;
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        for (n4 = 0; n4 < n7; ++n4) {
            if (!(this.columnSpec[n4] > 0.0f) || !(this.columnSpec[n4] < 1.0f)) continue;
            this.columnSize[n4] = (int)(this.columnSpec[n4] * (float)n6 + 0.5f);
            n11 -= this.columnSize[n4];
        }
        for (n4 = 0; n4 < n8; ++n4) {
            if (!(this.rowSpec[n4] > 0.0f) || !(this.rowSpec[n4] < 1.0f)) continue;
            this.rowSize[n4] = (int)(this.rowSpec[n4] * (float)n5 + 0.5f);
            n12 -= this.rowSize[n4];
        }
        if (n11 < 0) {
            n11 = 0;
        }
        if (n12 < 0) {
            n12 = 0;
        }
        n4 = 0;
        int n15 = 0;
        for (n2 = 0; n2 < n7; ++n2) {
            if (this.columnSpec[n2] != -1.0f) continue;
            ++n4;
        }
        for (n2 = 0; n2 < n8; ++n2) {
            if (this.rowSpec[n2] != -1.0f) continue;
            ++n15;
        }
        n2 = n11;
        n3 = n12;
        for (n = 0; n < n7; ++n) {
            if (this.columnSpec[n] != -1.0f) continue;
            this.columnSize[n] = n11 / n4;
            n2 -= this.columnSize[n];
        }
        for (n = 0; n < n8; ++n) {
            if (this.rowSpec[n] != -1.0f) continue;
            this.rowSize[n] = n12 / n15;
            n3 -= this.rowSize[n];
        }
        for (n = n7 - 1; n >= 0; --n) {
            if (this.columnSpec[n] != -1.0f) continue;
            int n16 = n;
            this.columnSize[n16] = this.columnSize[n16] + n2;
            break;
        }
        for (n = n8 - 1; n >= 0; --n) {
            if (this.rowSpec[n] != -1.0f) continue;
            int n17 = n;
            this.rowSize[n17] = this.rowSize[n17] + n3;
            break;
        }
        this.columnOffset = new int[n7 + 1];
        this.columnOffset[0] = insets.left;
        for (n = 0; n < n7; ++n) {
            this.columnOffset[n + 1] = this.columnOffset[n] + this.columnSize[n];
        }
        this.rowOffset = new int[n8 + 1];
        this.rowOffset[0] = insets.top;
        for (n = 0; n < n8; ++n) {
            this.rowOffset[n + 1] = this.rowOffset[n] + this.rowSize[n];
        }
        this.dirty = false;
        this.oldWidth = n9;
        this.oldHeight = n10;
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        if (this.dirty || dimension.width != this.oldWidth || dimension.height != this.oldHeight) {
            this.calculateSize(container);
        }
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            try {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                Entry entry = null;
                for (n5 = 0; n5 < this.list.size(); ++n5) {
                    Entry entry2 = (Entry)this.list.elementAt(n5);
                    if (entry2.component != componentArray[i]) continue;
                    entry = entry2;
                    break;
                }
                if (entry == null) break;
                if (entry.singleCell) {
                    n5 = 0;
                    int n6 = 0;
                    if (entry.hAlign != 2 || entry.vAlign != 2) {
                        Dimension dimension2 = componentArray[i].getPreferredSize();
                        n5 = dimension2.width;
                        n6 = dimension2.height;
                    }
                    int n7 = this.columnSize[entry.col1];
                    int n8 = this.rowSize[entry.row1];
                    n4 = entry.hAlign == 2 || n7 < n5 ? n7 : n5;
                    switch (entry.hAlign) {
                        case 0: {
                            n3 = this.columnOffset[entry.col1];
                            break;
                        }
                        case 3: {
                            n3 = this.columnOffset[entry.col1 + 1] - n4;
                            break;
                        }
                        case 1: {
                            n3 = this.columnOffset[entry.col1] + (n7 - n4 >> 1);
                            break;
                        }
                        case 2: {
                            n3 = this.columnOffset[entry.col1];
                            break;
                        }
                        default: {
                            n3 = 0;
                        }
                    }
                    n2 = entry.vAlign == 2 || n8 < n6 ? n8 : n6;
                    switch (entry.vAlign) {
                        case 0: {
                            n = this.rowOffset[entry.row1];
                            break;
                        }
                        case 3: {
                            n = this.rowOffset[entry.row1 + 1] - n2;
                            break;
                        }
                        case 1: {
                            n = this.rowOffset[entry.row1] + (n8 - n2 >> 1);
                            break;
                        }
                        case 2: {
                            n = this.rowOffset[entry.row1];
                            break;
                        }
                        default: {
                            n = 0;
                            break;
                        }
                    }
                } else {
                    n3 = this.columnOffset[entry.col1];
                    n = this.rowOffset[entry.row1];
                    n4 = this.columnOffset[entry.col2 + 1] - this.columnOffset[entry.col1];
                    n2 = this.rowOffset[entry.row2 + 1] - this.rowOffset[entry.row1];
                }
                componentArray[i].setBounds(n3, n, n4, n2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        int n;
        Object object;
        int n2;
        int n3;
        int n4;
        float f = 1.0f;
        float f2 = 1.0f;
        int n5 = 0;
        int n6 = 0;
        for (n4 = 0; n4 < this.columnSpec.length; ++n4) {
            if (this.columnSpec[n4] > 0.0f && this.columnSpec[n4] < 1.0f) {
                f -= this.columnSpec[n4];
                continue;
            }
            if (this.columnSpec[n4] != -1.0f) continue;
            ++n5;
        }
        for (n4 = 0; n4 < this.rowSpec.length; ++n4) {
            if (this.rowSpec[n4] > 0.0f && this.rowSpec[n4] < 1.0f) {
                f2 -= this.rowSpec[n4];
                continue;
            }
            if (this.rowSpec[n4] != -1.0f) continue;
            ++n6;
        }
        if (n5 > 1) {
            f /= (float)n5;
        }
        if (n6 > 1) {
            f2 /= (float)n6;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        int[] nArray = new int[this.columnSpec.length];
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < this.columnSpec.length; ++i) {
            if (this.columnSpec[i] != -2.0f && this.columnSpec[i] != -3.0f) continue;
            n3 = 0;
            for (n2 = 0; n2 < this.list.size(); ++n2) {
                int n9;
                Entry entry = (Entry)this.list.elementAt(n2);
                if (entry.col1 != i || entry.col2 != i) continue;
                object = this.columnSpec[i] == -2.0f ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                int n10 = n9 = object == null ? 0 : ((Dimension)object).width;
                if (n3 >= n9) continue;
                n3 = n9;
            }
            nArray[i] = n3;
        }
        int[] nArray2 = new int[this.rowSpec.length];
        for (n3 = 0; n3 < this.rowSpec.length; ++n3) {
            if (this.rowSpec[n3] != -2.0f && this.rowSpec[n3] != -3.0f) continue;
            n2 = 0;
            for (int i = 0; i < this.list.size(); ++i) {
                int n11;
                object = (Entry)this.list.elementAt(i);
                if (((TableLayoutConstraints)object).row1 != n3 || ((TableLayoutConstraints)object).row1 != n3) continue;
                Dimension dimension = this.rowSpec[n3] == -2.0f ? ((Entry)object).component.getPreferredSize() : ((Entry)object).component.getMinimumSize();
                int n12 = n11 = dimension == null ? 0 : dimension.height;
                if (n2 >= n11) continue;
                n2 = n11;
            }
            int n13 = n3;
            nArray2[n13] = nArray2[n13] + n2;
        }
        for (n3 = 0; n3 < this.list.size(); ++n3) {
            int n14;
            int n15;
            Entry entry = (Entry)this.list.elementAt(n3);
            if (entry.col1 < 0 || entry.col1 >= this.columnSpec.length || entry.col2 >= this.columnSpec.length || entry.row1 < 0 || entry.row1 >= this.rowSpec.length || entry.row2 >= this.rowSpec.length) continue;
            Dimension dimension = entry.component.getPreferredSize();
            int n16 = dimension.width;
            int n17 = dimension.height;
            for (n15 = entry.col1; n15 <= entry.col2; ++n15) {
                if (this.columnSpec[n15] >= 1.0f) {
                    n16 = (int)((float)n16 - this.columnSpec[n15]);
                    continue;
                }
                if (this.columnSpec[n15] != -2.0f && this.columnSpec[n15] != -3.0f) continue;
                n16 -= nArray[n15];
            }
            for (n15 = entry.row1; n15 <= entry.row2; ++n15) {
                if (this.rowSpec[n15] >= 1.0f) {
                    n17 = (int)((float)n17 - this.rowSpec[n15]);
                    continue;
                }
                if (this.rowSpec[n15] != -2.0f && this.rowSpec[n15] != -3.0f) continue;
                n17 -= nArray2[n15];
            }
            float f3 = 0.0f;
            for (n14 = entry.col1; n14 <= entry.col2; ++n14) {
                if (this.columnSpec[n14] > 0.0f && this.columnSpec[n14] < 1.0f) {
                    f3 += this.columnSpec[n14];
                    continue;
                }
                if (this.columnSpec[n14] != -1.0f || f == 0.0f) continue;
                f3 += f;
            }
            n14 = f3 == 0.0f ? 0 : (int)((float)n16 / f3 + 0.5f);
            if (n7 < n14) {
                n7 = n14;
            }
            float f4 = 0.0f;
            for (int i = entry.row1; i <= entry.row2; ++i) {
                if (this.rowSpec[i] > 0.0f && this.rowSpec[i] < 1.0f) {
                    f4 += this.rowSpec[i];
                    continue;
                }
                if (this.rowSpec[i] != -1.0f || f2 == 0.0f) continue;
                f4 += f2;
            }
            n14 = f4 == 0.0f ? 0 : (int)((float)n17 / f4 + 0.5f);
            if (n8 >= n14) continue;
            n8 = n14;
        }
        n3 = n7;
        for (n = 0; n < this.columnSpec.length; ++n) {
            if (this.columnSpec[n] >= 1.0f) {
                n3 += (int)(this.columnSpec[n] + 0.5f);
                continue;
            }
            if (this.columnSpec[n] != -2.0f && this.columnSpec[n] != -3.0f) continue;
            n3 += nArray[n];
        }
        n = n8;
        for (int i = 0; i < this.rowSpec.length; ++i) {
            if (this.rowSpec[i] >= 1.0f) {
                n += (int)(this.rowSpec[i] + 0.5f);
                continue;
            }
            if (this.rowSpec[i] != -2.0f && this.rowSpec[i] != -3.0f) continue;
            n += nArray2[i];
        }
        Insets insets = container.getInsets();
        return new Dimension(n3 += insets.left + insets.right, n += insets.top + insets.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        float f = 1.0f;
        float f2 = 1.0f;
        int n8 = 0;
        int n9 = 0;
        for (n5 = 0; n5 < this.columnSpec.length; ++n5) {
            if (this.columnSpec[n5] > 0.0f && this.columnSpec[n5] < 1.0f) {
                f -= this.columnSpec[n5];
                continue;
            }
            if (this.columnSpec[n5] != -1.0f) continue;
            ++n8;
        }
        for (n5 = 0; n5 < this.rowSpec.length; ++n5) {
            if (this.rowSpec[n5] > 0.0f && this.rowSpec[n5] < 1.0f) {
                f2 -= this.rowSpec[n5];
                continue;
            }
            if (this.rowSpec[n5] != -1.0f) continue;
            ++n9;
        }
        if (n8 > 1) {
            f /= (float)n8;
        }
        if (n9 > 1) {
            f2 /= (float)n9;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        for (n5 = 0; n5 < this.list.size(); ++n5) {
            int n10;
            Entry entry = (Entry)this.list.elementAt(n5);
            if (entry.col1 < 0 || entry.col1 >= this.columnSpec.length || entry.col2 >= this.columnSpec.length || entry.row1 < 0 || entry.row1 >= this.rowSpec.length || entry.row2 >= this.rowSpec.length) continue;
            Dimension dimension = entry.component.getMinimumSize();
            n4 = dimension.width;
            n3 = dimension.height;
            for (n10 = entry.col1; n10 <= entry.col2; ++n10) {
                if (!(this.columnSpec[n10] >= 1.0f)) continue;
                n4 = (int)((float)n4 - this.columnSpec[n10]);
            }
            for (n10 = entry.row1; n10 <= entry.row2; ++n10) {
                if (!(this.rowSpec[n10] >= 1.0f)) continue;
                n3 = (int)((float)n3 - this.rowSpec[n10]);
            }
            float f3 = 0.0f;
            for (int i = entry.col1; i <= entry.col2; ++i) {
                if (this.columnSpec[i] > 0.0f && this.columnSpec[i] < 1.0f) {
                    f3 += this.columnSpec[i];
                    continue;
                }
                if (this.columnSpec[i] != -1.0f || f == 0.0f) continue;
                f3 += f;
            }
            int n11 = f3 == 0.0f ? 0 : (int)((float)n4 / f3 + 0.5f);
            if (n6 < n11) {
                n6 = n11;
            }
            float f4 = 0.0f;
            for (n2 = entry.row1; n2 <= entry.row2; ++n2) {
                if (this.rowSpec[n2] > 0.0f && this.rowSpec[n2] < 1.0f) {
                    f4 += this.rowSpec[n2];
                    continue;
                }
                if (this.rowSpec[n2] != -1.0f || f2 == 0.0f) continue;
                f4 += f2;
            }
            n11 = f4 == 0.0f ? 0 : (int)((float)n3 / f4 + 0.5f);
            if (n7 >= n11) continue;
            n7 = n11;
        }
        n5 = n6;
        for (n = 0; n < this.columnSpec.length; ++n) {
            if (this.columnSpec[n] >= 1.0f) {
                n5 += (int)(this.columnSpec[n] + 0.5f);
                continue;
            }
            if (this.columnSpec[n] != -2.0f && this.columnSpec[n] != -3.0f) continue;
            n4 = 0;
            for (n3 = 0; n3 < this.list.size(); ++n3) {
                Entry entry = (Entry)this.list.elementAt(n3);
                if (entry.col1 != n || entry.col2 != n) continue;
                Dimension dimension = this.columnSpec[n] == -2.0f ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                int n12 = n2 = dimension == null ? 0 : dimension.width;
                if (n4 >= n2) continue;
                n4 = n2;
            }
            n5 += n4;
        }
        n = n7;
        for (n4 = 0; n4 < this.rowSpec.length; ++n4) {
            if (this.rowSpec[n4] >= 1.0f) {
                n += (int)(this.rowSpec[n4] + 0.5f);
                continue;
            }
            if (this.rowSpec[n4] != -2.0f && this.rowSpec[n4] != -3.0f) continue;
            n3 = 0;
            for (int i = 0; i < this.list.size(); ++i) {
                int n13;
                Entry entry = (Entry)this.list.elementAt(i);
                if (entry.row1 != n4 || entry.row1 != n4) continue;
                Dimension dimension = this.rowSpec[n4] == -2.0f ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                int n14 = n13 = dimension == null ? 0 : dimension.height;
                if (n3 >= n13) continue;
                n3 = n13;
            }
            n += n3;
        }
        Insets insets = container.getInsets();
        return new Dimension(n5 += insets.left + insets.right, n += insets.top + insets.bottom);
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            object = new TableLayoutConstraints((String)object);
            this.list.addElement(new Entry(component, (TableLayoutConstraints)object));
        } else if (object instanceof TableLayoutConstraints) {
            this.list.addElement(new Entry(component, (TableLayoutConstraints)object));
        } else {
            if (object == null) {
                throw new IllegalArgumentException("No constraint for the component");
            }
            throw new IllegalArgumentException("Cannot accept a constraint of class " + object.getClass());
        }
    }

    public void removeLayoutComponent(Component component) {
        this.list.removeElement(component);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        this.dirty = true;
    }

    private static class Entry
    extends TableLayoutConstraints {
        final Component component;
        final boolean singleCell;

        Entry(Component component, TableLayoutConstraints tableLayoutConstraints) {
            super(tableLayoutConstraints.col1, tableLayoutConstraints.row1, tableLayoutConstraints.col2, tableLayoutConstraints.row2, tableLayoutConstraints.hAlign, tableLayoutConstraints.vAlign);
            this.singleCell = this.row1 == this.row2 && this.col1 == this.col2;
            this.component = component;
        }

        public boolean equals(Object object) {
            if (object instanceof Component) {
                Component component = (Component)object;
                return this.component == component;
            }
            return false;
        }
    }
}

