/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.tablelayout;

import elgato.infrastructure.tablelayout.TableLayoutConstants;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class TableLayoutConstraints
implements TableLayoutConstants {
    public int col1 = 0;
    public int row1 = 0;
    public int col2 = 0;
    public int row2 = 0;
    public int hAlign = 2;
    public int vAlign = 2;

    public TableLayoutConstraints() {
    }

    public TableLayoutConstraints(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
            this.col2 = this.col1 = new Integer(string2).intValue();
            string2 = stringTokenizer.nextToken();
            this.row2 = this.row1 = new Integer(string2).intValue();
            string2 = stringTokenizer.nextToken();
            this.col2 = new Integer(string2);
            string2 = stringTokenizer.nextToken();
            this.row2 = new Integer(string2);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (NumberFormatException numberFormatException) {
            try {
                if (string2.equalsIgnoreCase("L")) {
                    this.hAlign = 0;
                } else if (string2.equalsIgnoreCase("C")) {
                    this.hAlign = 1;
                } else if (string2.equalsIgnoreCase("F")) {
                    this.hAlign = 2;
                } else if (string2.equalsIgnoreCase("R")) {
                    this.hAlign = 3;
                }
                string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("T")) {
                    this.vAlign = 0;
                } else if (string2.equalsIgnoreCase("C")) {
                    this.vAlign = 1;
                } else if (string2.equalsIgnoreCase("F")) {
                    this.vAlign = 2;
                } else if (string2.equalsIgnoreCase("B")) {
                    this.vAlign = 3;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        if (this.row2 < this.row1) {
            this.row2 = this.row1;
        }
        if (this.col2 < this.col1) {
            this.col2 = this.col1;
        }
    }

    protected TableLayoutConstraints(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 < n || n4 < n2 || n5 < 0 || n5 > 3 || n6 < 0 || n6 > 3) {
            throw new IllegalArgumentException();
        }
        this.col1 = n;
        this.row1 = n2;
        this.col2 = n3;
        this.row2 = n4;
        this.hAlign = n5;
        this.vAlign = n6;
    }

    public static TableLayoutConstraints newCell(int n, int n2) {
        return new TableLayoutConstraints(n, n2, n, n2, 2, 2);
    }

    public static TableLayoutConstraints newCell(int n, int n2, int n3, int n4) {
        return new TableLayoutConstraints(n, n2, n, n2, n3, n4);
    }

    public static TableLayoutConstraints newSpan(int n, int n2, int n3, int n4) {
        return new TableLayoutConstraints(n, n2, n3, n4, 2, 2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.row1);
        stringBuffer.append(", ");
        stringBuffer.append(this.col1);
        stringBuffer.append(", ");
        if (this.row1 == this.row2 && this.col1 == this.col2) {
            char[] cArray = new char[]{'L', 'C', 'F', 'R'};
            char[] cArray2 = new char[]{'T', 'C', 'F', 'B'};
            stringBuffer.append(cArray[this.hAlign]);
            stringBuffer.append(", ");
            stringBuffer.append(cArray2[this.vAlign]);
        } else {
            stringBuffer.append(this.row2);
            stringBuffer.append(", ");
            stringBuffer.append(this.col2);
        }
        return stringBuffer.toString();
    }
}

