/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.units;

import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.units.UnitsFactory;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;

public class ChannelCountUnits
extends UnitsFactory {
    private BandSelector bandSelector;
    private ChannelCountConversion channelCountConversion = new ChannelCountConversion();

    public ChannelCountUnits(BandSelector bandSelector) {
        this.bandSelector = bandSelector;
    }

    public Conversion[] getUnits() {
        return new Conversion[]{this.channelCountConversion};
    }

    public String toString(long l) {
        return this.channelCountConversion.toString(l);
    }

    public Conversion getDefaultUnits() {
        return this.channelCountConversion;
    }

    public void setDefaultUnits(Conversion conversion) {
    }

    public int getIncrement() {
        return (int)Band.getCurrentBandChannelWidth(this.bandSelector);
    }

    private class ChannelCountConversion
    extends Conversion {
        private ChannelCountConversion() {
        }

        public String getLabel() {
            return "";
        }

        public long longValue(String string) {
            int n = Integer.parseInt(string);
            return this.channelToFrequency(n);
        }

        public String toString(long l) {
            return Integer.toString(this.frequencyToChannels(l));
        }

        private int frequencyToChannels(long l) {
            long l2 = this.getBandWidth();
            long l3 = l / l2;
            long l4 = l % l2;
            if (l4 >= l2 / 2L) {
                ++l3;
            }
            return (int)l3;
        }

        private long getBandWidth() {
            return Band.getCurrentBandChannelWidth(ChannelCountUnits.this.bandSelector);
        }

        private long channelToFrequency(int n) {
            return (long)n * this.getBandWidth();
        }

        public long increment(int n) {
            throw new RuntimeException("Method ChannelCountConversion.increment() not implemented");
        }
    }
}

