/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.units;

import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.util.chanstd.IChannel;
import elgato.infrastructure.util.chanstd.InvalidChannelException;
import elgato.infrastructure.util.chanstd.InvalidFrequencyException;

public abstract class ChannelFrequencyConversion
extends Conversion {
    private final BandSelector bandSelector;

    ChannelFrequencyConversion(BandSelector bandSelector) {
        this.bandSelector = bandSelector;
    }

    public static ChannelFrequencyConversion createForward(BandSelector bandSelector) {
        return new ForwardChannelFrequencyConversion(bandSelector);
    }

    public static ChannelFrequencyConversion createReverse(BandSelector bandSelector) {
        return new ReverseChannelFrequencyConversion(bandSelector);
    }

    public long longValue(String string) {
        double d = 0.0;
        try {
            d = Double.valueOf(string);
            return this.getLong(d);
        }
        catch (InvalidChannelException invalidChannelException) {
            return this.getClosestFrequency(d);
        }
        catch (NumberFormatException numberFormatException) {
            return this.getDefaultFrequency();
        }
    }

    protected abstract long getClosestFrequency(double var1);

    private long getDefaultFrequency() {
        return this.getDefaultChannel().getCenterFrequency();
    }

    public BandSelector getBandSelector() {
        return this.bandSelector;
    }

    public String toString(long l) {
        return this.getChannelValue(l);
    }

    public String getChannelValue(long l) {
        try {
            double d = Band.getCurrentBand(this.bandSelector).convertFrequencyToChannelNumber(l);
            IChannel iChannel = this.getChannel(Band.getCurrentBand(this.bandSelector), d);
            return ((Object)iChannel).toString();
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            return Text.Questionmark;
        }
        catch (InvalidChannelException invalidChannelException) {
            return Text.Questionmark;
        }
    }

    private IChannel getDefaultChannel() {
        return Band.getCurrentBand(this.bandSelector).getDefaultChannel();
    }

    private long getLong(double d) throws InvalidChannelException {
        return this.getChannel(Band.getCurrentBand(this.bandSelector), d).getCenterFrequency();
    }

    protected abstract IChannel getChannel(Band var1, double var2) throws InvalidChannelException;

    public abstract String getChannelUnits();

    public String getLabel() {
        if (Band.getCurrentBand(this.bandSelector).isForwardAndReverseSameFrequencies()) {
            return Text.Enter;
        }
        return this.getChannelUnits();
    }

    private static class ReverseChannelFrequencyConversion
    extends ChannelFrequencyConversion {
        public ReverseChannelFrequencyConversion(BandSelector bandSelector) {
            super(bandSelector);
        }

        protected IChannel getChannel(Band band, double d) throws InvalidChannelException {
            return band.getChannelRevByChannelNumber(d);
        }

        public String getChannelUnits() {
            return Band.getCurrentBand(this.getBandSelector()).getChannelRevUnitLabel();
        }

        protected long getClosestFrequency(double d) {
            return Band.getCurrentBand(this.getBandSelector()).getClosestChannel(d).convertToReverse(this.getChannelUnits()).getCenterFrequency();
        }
    }

    private static class ForwardChannelFrequencyConversion
    extends ChannelFrequencyConversion {
        public ForwardChannelFrequencyConversion(BandSelector bandSelector) {
            super(bandSelector);
        }

        protected IChannel getChannel(Band band, double d) throws InvalidChannelException {
            return band.getChannelFwdByChannelNumber(d);
        }

        public String getChannelUnits() {
            return Band.getCurrentBand(this.getBandSelector()).getChannelFwdUnitLabel();
        }

        protected long getClosestFrequency(double d) {
            return Band.getCurrentBand(this.getBandSelector()).getClosestChannel(d).getCenterFrequency();
        }
    }
}

