/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.units;

import elgato.infrastructure.units.ChannelFrequencyConversion;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.units.UnitsFactory;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;

public class ChannelUnits
extends UnitsFactory {
    private static final Conversion defaultUnits = new Conversion();
    private final BandSelector bandSelector;
    private final Conversion forward;
    private final Conversion reverse;
    private final Conversion[] conversions;

    public ChannelUnits(BandSelector bandSelector) {
        this.bandSelector = bandSelector;
        this.forward = ChannelFrequencyConversion.createForward(bandSelector);
        this.reverse = ChannelFrequencyConversion.createReverse(bandSelector);
        Band band = Band.getCurrentBand(bandSelector);
        this.conversions = band.isForwardAndReverseSameFrequencies() ? new Conversion[]{this.forward} : new Conversion[]{this.forward, this.reverse};
    }

    public Conversion getReverse() {
        return this.reverse;
    }

    public Conversion getForward() {
        return this.forward;
    }

    public Conversion[] getUnits() {
        return this.conversions;
    }

    public Conversion getDefaultUnits() {
        return defaultUnits;
    }

    public void setDefaultUnits(Conversion conversion) {
    }

    public String toString(long l) {
        Band band = Band.getCurrentBand(this.bandSelector);
        if (band.isFrequencyFwdChannel(l)) {
            return this.forward.toString(l);
        }
        return this.reverse.toString(l);
    }

    public int getIncrement() {
        return 1;
    }
}

