/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.units;

import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.strategies.WattStrategy;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.units.UnitsFactory;
import elgato.infrastructure.util.FastMath;
import java.math.BigDecimal;

public class DbmUnitsFactory
extends UnitsFactory {
    private static final Conversion dBmConversion = FactorConversion.createFixedPoint("dBm", 1000);
    private static final Conversion wattsConversion = new WattsConversion();
    private static final Conversion[] units = new Conversion[]{dBmConversion, wattsConversion};
    private Conversion defaultUnits = dBmConversion;

    public static Conversion getDbmConversion() {
        return dBmConversion;
    }

    public static Conversion getWattsConversion() {
        return wattsConversion;
    }

    public Conversion[] getUnits() {
        return units;
    }

    public String toString(long l) {
        return this.getDefaultUnits().toString(l);
    }

    public Conversion getDefaultUnits() {
        return this.defaultUnits;
    }

    public void setDefaultUnits(Conversion conversion) {
        this.defaultUnits = conversion;
    }

    public static NumberFieldStrategy getDBToWattStrategy() {
        return new DBToWattStrategy();
    }

    public static NumberFieldStrategy getDBToWattDecimalsStrategy(int n) {
        return new DBToWattDecimalsStrategy(n);
    }

    private static class DBToWattDecimalsStrategy
    extends DBToWattStrategy {
        int decimalPlaces = 1;

        DBToWattDecimalsStrategy(int n) {
            this.decimalPlaces = n;
        }

        public String format(long l) {
            return ((WattsConversion)DbmUnitsFactory.getWattsConversion()).toString(l, this.decimalPlaces);
        }
    }

    private static class DBToWattStrategy
    extends NumberFieldStrategy {
        private DBToWattStrategy() {
        }

        public String format(long l) {
            return DbmUnitsFactory.getWattsConversion().toString(l);
        }
    }

    private static class WattsConversion
    extends Conversion {
        private WattsConversion() {
        }

        public String getLabel() {
            return "W";
        }

        public long longValue(String string) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2;
            BigDecimal bigDecimal3 = new BigDecimal(string);
            if (bigDecimal3.compareTo(new BigDecimal(0.0)) == 0) {
                bigDecimal3 = new BigDecimal(0.001);
            }
            if ((bigDecimal2 = (bigDecimal = bigDecimal3.setScale(6, 4)).multiply(new BigDecimal("1000"))).compareTo(new BigDecimal(0.0)) == 0) {
                bigDecimal2 = new BigDecimal(0.001);
            }
            double d = 10000.0 * (Math.log(bigDecimal2.doubleValue()) / Math.log(10.0));
            BigDecimal bigDecimal4 = new BigDecimal(Double.toString(d));
            return bigDecimal4.setScale(0, 4).longValue();
        }

        public String toString(long l) {
            double d = Math.pow(10.0, (double)l / 1000.0 / 10.0) / 1000.0;
            int n = FastMath.floor((int)FastMath.float_log10((float)d), 3);
            double d2 = Math.pow(10.0, n);
            double d3 = d / d2;
            int[] nArray = new int[]{(int)Math.round(d3 * 1000.0), n};
            return new WattStrategy(1, nArray[1]).format(nArray[0]);
        }

        public String toString(long l, int n) {
            double d = Math.pow(10.0, (double)l / 1000.0 / 10.0) / 1000.0;
            int n2 = FastMath.floor((int)FastMath.float_log10((float)d), 3);
            double d2 = Math.pow(10.0, n2);
            double d3 = d / d2;
            int[] nArray = new int[]{(int)Math.round(d3 * 1000.0), n2};
            return new WattStrategy(n, nArray[1]).format(nArray[0]);
        }
    }
}

