/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.units;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.units.UnitsConversion;
import java.math.BigDecimal;
import java.text.NumberFormat;

public class FactorConversion
extends UnitsConversion {
    protected final BigDecimal factor;
    protected final NumberFormat format;

    public FactorConversion(String string, BigDecimal bigDecimal) {
        super(string);
        this.factor = bigDecimal;
        this.format = NumberFormat.getNumberInstance();
        this.format.setGroupingUsed(false);
        this.setMinimumFractionDigits(0);
        this.setMaximumFractionDigits(9);
    }

    public FactorConversion(String string, long l) {
        this(string, BigDecimal.valueOf(l));
    }

    public FactorConversion(String string, String string2) {
        this(string, new BigDecimal(string2));
    }

    public FactorConversion setMinimumFractionDigits(int n) {
        this.format.setMinimumFractionDigits(n);
        return this;
    }

    public FactorConversion setMaximumFractionDigits(int n) {
        this.format.setMaximumFractionDigits(n);
        return this;
    }

    public static Conversion createPercent(int n) {
        return FactorConversion.createFixedPoint("%", n);
    }

    public static Conversion createFixedPoint(String string, int n) {
        return new FactorConversion(string, n){
            {
                this.format.setMinimumFractionDigits(1);
            }
        };
    }

    public static Conversion createFixedPoint(String string, int n, final LongActuator longActuator) {
        return new FactorConversion(string, n){
            {
                this.format.setMinimumFractionDigits(1);
            }

            public long increment(int n, int n2) {
                return super.increment(n, this.getIncrement());
            }

            public int getIncrement() {
                return longActuator.intValue() / 10;
            }
        };
    }

    public long longValue(String string) {
        BigDecimal bigDecimal = new BigDecimal(string);
        bigDecimal = bigDecimal.setScale(9, 4);
        bigDecimal = bigDecimal.multiply(this.factor);
        return bigDecimal.longValue();
    }

    public String toString(long l) {
        return this.format.format(BigDecimal.valueOf(l).divide(this.factor, 9, 4)) + " " + this.getLabel();
    }

    public long getFactor() {
        return this.factor.longValue();
    }
}

