/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.units;

import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.units.UnitsFactory;

public class FrequencyUnits
extends UnitsFactory {
    private static final long BILLION = 1000000000L;
    private static final long MILLION = 1000000L;
    private static final long THOUSAND = 1000L;
    private static final FactorConversion GHzConversion = new FactorConversion("GHz", 1000000000L);
    private static final FactorConversion MHzConversion = new FactorConversion("MHz", 1000000L);
    private static final FactorConversion kHzConversion = new FactorConversion("kHz", 1000L);
    private static final FactorConversion HzConversion = new FactorConversion("Hz", 1L);
    private static final FactorConversion[] units = new FactorConversion[]{GHzConversion, MHzConversion, kHzConversion, HzConversion};
    private Conversion defaultUnits = kHzConversion;

    public static Conversion getKHzUnits() {
        return kHzConversion;
    }

    public static Conversion getMHzUnits() {
        return MHzConversion;
    }

    public static Conversion getHzUnits() {
        return HzConversion;
    }

    public static Conversion getGHzUnits() {
        return GHzConversion;
    }

    public Conversion[] getUnits() {
        return units;
    }

    public String toString(long l) {
        int n;
        long l2 = l < 0L ? -l : l;
        for (n = 0; n < units.length - 1 && l2 < units[n].getFactor(); ++n) {
        }
        return units[n].toString(l);
    }

    public Conversion getDefaultUnits() {
        return this.defaultUnits;
    }

    public void setDefaultUnits(Conversion conversion) {
    }
}

