/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.units;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.util.FastMath;

public class RelativeFactorConversion
extends FactorConversion {
    protected LongActuator actuator;

    public RelativeFactorConversion(String string, String string2, LongActuator longActuator) {
        super(string, string2);
        this.actuator = longActuator;
    }

    public long increment(int n, int n2) {
        return super.increment(n, this.getStep());
    }

    protected int getStep() {
        return RelativeFactorConversion.calculateTruncatedPercentIncrement(this.actuator.intValue(), 10);
    }

    public static int calculateTruncatedPercentIncrement(int n, int n2) {
        int n3;
        int n4 = FastMath.log10(Math.abs(n));
        if (n4 < (n3 = FastMath.log10(n2))) {
            n4 = n3;
        }
        int n5 = FastMath.pow10(n4 - n3);
        return n5;
    }
}

