/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.units;

import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.units.UnitsFactory;

public class TimeUnits
extends UnitsFactory {
    private static final long BILLION = 1000000000L;
    private static final long MILLION = 1000000L;
    private static final long THOUSAND = 1000L;
    private static final FactorConversion SecConversion = new FactorConversion("s", 1000000000L);
    private static final FactorConversion MilliSecConversion = new FactorConversion("ms", 1000000L);
    private static final FactorConversion MicroSecConversion = new FactorConversion("\u00b5s", 1000L);
    private static final FactorConversion NanoSecConversion = new FactorConversion("ns", 1L);
    private static final FactorConversion[] units = new FactorConversion[]{SecConversion, MilliSecConversion, MicroSecConversion, NanoSecConversion};
    private Conversion defaultUnits = MicroSecConversion;

    public static Conversion getSecondUnits() {
        return SecConversion;
    }

    public static Conversion getMilliSecondUnits() {
        return MilliSecConversion;
    }

    public static Conversion getMicroSecondUnits() {
        return MicroSecConversion;
    }

    public static Conversion getNanoSecondUnits() {
        return NanoSecConversion;
    }

    public Conversion[] getUnits() {
        return units;
    }

    public String toString(long l) {
        int n;
        long l2 = l < 0L ? -l : l;
        for (n = 0; n < units.length - 1 && l2 < units[n].getFactor(); ++n) {
        }
        return units[n].toString(l);
    }

    public Conversion getDefaultUnits() {
        return this.defaultUnits;
    }

    public void setDefaultUnits(Conversion conversion) {
    }
}

