/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.Comparator;
import java.util.Vector;

public class Arrays {
    public static void sort(Object[] objectArray, Comparator comparator) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        Arrays.mergeSort(objectArray2, objectArray, 0, objectArray.length, comparator);
    }

    public static void sort(Object[] objectArray, int n, int n2, Comparator comparator) {
        Arrays.rangeCheck(objectArray.length, n, n2);
        Object[] objectArray2 = (Object[])objectArray.clone();
        Arrays.mergeSort(objectArray2, objectArray, n, n2, comparator);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, Comparator comparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && comparator.compare(objectArray2[j - 1], objectArray2[j]) > 0; --j) {
                    Arrays.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = n + n2 >> 1;
        Arrays.mergeSort(objectArray2, objectArray, n, n4, comparator);
        Arrays.mergeSort(objectArray2, objectArray, n4, n2, comparator);
        if (comparator.compare(objectArray[n4 - 1], objectArray[n4]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            objectArray2[i] = n6 >= n2 || n5 < n4 && comparator.compare(objectArray[n5], objectArray[n6]) <= 0 ? objectArray[n5++] : objectArray[n6++];
        }
    }

    private static void rangeCheck(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > n) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static boolean contains(String[] stringArray, String string) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    public static int indexof(String[] stringArray, String string) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    public static String[] remove(String[] stringArray, String string) {
        if (Arrays.contains(stringArray, string)) {
            String[] stringArray2 = new String[stringArray.length - 1];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.equals(stringArray[i])) continue;
                stringArray2[n++] = stringArray[i];
            }
            return stringArray2;
        }
        return stringArray;
    }

    public static String[] toArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }
}

