/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import ceej.awt.CEEJGraphics;
import ceej.awt.KeyEventFilter;
import ceej.cwt.Attribute;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.util.Platform;
import elgato.infrastructure.wheel.NullScrollWheelManager;
import elgato.infrastructure.wheel.RPGManager;
import elgato.infrastructure.wheel.ScrollWheelManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;

final class CEEJPlatform
extends Platform {
    private static final boolean nativeLibraryLoaded;
    private static final int DEFAULT_DISPLAY_BRIGHTNESS = 128;
    private int displayBrightness;
    private boolean backlightEnabled;

    CEEJPlatform() {
        this.do_setDisplayBrightness(128);
        this.do_setDisplayBacklightEnabled(true);
    }

    protected void do_initializeScrollWheelManager(Component component) {
        ScrollWheelManager scrollWheelManager;
        if (new File("/dev/rpg").exists()) {
            scrollWheelManager = new RPGManager();
        } else {
            Platform.logger.warn("RPG device not accessible");
            scrollWheelManager = new NullScrollWheelManager();
        }
        ScrollWheelManager.registerInstance(scrollWheelManager);
    }

    protected void do_setAntialias(Graphics graphics, boolean bl) {
        CEEJGraphics cEEJGraphics = CEEJGraphics.getExtendedGraphics((Graphics)graphics);
        Attribute attribute = cEEJGraphics.getAttribute();
        attribute.setFlags(CEEJPlatform.setBit(attribute.getFlags(), bl, 1));
    }

    protected void do_setTextAntialias(Graphics graphics, boolean bl) {
        CEEJGraphics cEEJGraphics = CEEJGraphics.getExtendedGraphics((Graphics)graphics);
        Attribute attribute = cEEJGraphics.getAttribute();
        attribute.setFlags(CEEJPlatform.setBit(attribute.getFlags(), bl, 4096));
    }

    private static int setBit(int n, boolean bl, int n2) {
        n &= ~n2;
        if (bl) {
            n |= n2;
        }
        return n;
    }

    protected void do_setDisplayBrightness(int n) {
        this.displayBrightness = n;
        if (nativeLibraryLoaded) {
            try {
                CEEJPlatform.native_setDisplayBrightness(n);
            }
            catch (IOException iOException) {
                Platform.logger.error("Unable to set display brightness", iOException);
            }
        }
    }

    protected int do_getDisplayBrightness() {
        return this.displayBrightness;
    }

    protected void do_setDisplayBacklightEnabled(boolean bl) {
        this.backlightEnabled = bl;
        if (nativeLibraryLoaded) {
            try {
                CEEJPlatform.native_setDisplayBacklightEnabled(bl);
            }
            catch (IOException iOException) {
                Platform.logger.error("Unable to set display backlight enabled state", iOException);
            }
        }
    }

    protected boolean do_isDisplayBacklightEnabled() {
        return this.backlightEnabled;
    }

    protected boolean do_initializeKeyEventFilter() {
        KeyEventFilter.registerFilter((KeyEventFilter)new KeyEventFilter(){

            public KeyEvent filterKey(KeyEvent keyEvent) {
                GlobalKeyManager.incrementKeyPressInProcessCount(keyEvent);
                return keyEvent;
            }
        });
        return true;
    }

    private static native void native_setDisplayBacklightEnabled(boolean var0) throws IOException;

    private static native void native_setDisplayBrightness(int var0) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean bl = false;
        try {
            System.loadLibrary("guiutil");
            bl = true;
        }
        catch (Throwable throwable) {
            Platform.logger.error("Unable to load guiutil library", throwable);
        }
        finally {
            nativeLibraryLoaded = bl;
        }
    }
}

