/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.mainScreens.GenericMessageScreen;
import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.MessageScreenListener;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListScreen;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.IStorageDevice;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.StorageDevice;
import elgato.infrastructure.util.TextMessage;
import elgato.infrastructure.util.WindowsStorageDevice;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.infrastructure.widgets.DefaultEListModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CatCard {
    private String currentDir = "";
    private ScreenManager screenManager;
    static final String PADDING = "            ";
    private IStorageDevice storageDevice;

    public CatCard(ScreenManager screenManager) {
        this.screenManager = screenManager;
        this.storageDevice = RuntimeConfiguration.isEmbedded() ? FileSystemHelper.getInstance().createStorageDevice(SystemMeasurementSettings.instance().getDataDeviceType()) : new WindowsStorageDevice();
    }

    private void modifyRightMenu(boolean bl) {
        Menu menu = this.screenManager.getRightMenuPanel().getMenu();
        menu.setMenuItem(this.makeExpandDirButton(), 0);
        menu.setMenuItem(this.makeDeleteButton(), 2);
        if (bl) {
            menu.setMenuItem(this.makeBackDirButton(), 1);
        }
    }

    private void pushCatScreen(boolean bl) {
        ItemSelectionListener itemSelectionListener = new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
            }
        };
        if (bl) {
            this.screenManager.popScreen();
        }
        this.screenManager.pushScreen(new ListScreen(new DefaultEListModel(this.getFileList()), 0, itemSelectionListener, "Cat Card", new DefaultEListCellRenderer()));
        this.modifyRightMenu(!this.currentDir.equals(""));
    }

    private MenuItem makeExpandDirButton() {
        return new PushButton("Expand\nDir", "expandDir", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = CatCard.this.getSelectedEntry();
                if (string.startsWith("<DIR> ")) {
                    if (FileSystemHelper.getInstance().noCardPresent(SystemMeasurementSettings.instance().getDataDeviceType())) {
                        CatCard.this.screenManager.popScreen();
                        CatCard.this.displayCatErrorMessageScreen(CatCard.this.screenManager);
                    } else {
                        if (!RuntimeConfiguration.isEmbedded()) {
                            CatCard.this.currentDir = CatCard.this.currentDir + ("/" + string.substring(6));
                        } else {
                            CatCard.this.currentDir = CatCard.this.currentDir + (string.substring(6) + "/");
                        }
                        CatCard.this.pushCatScreen(true);
                    }
                }
            }
        });
    }

    private MenuItem makeBackDirButton() {
        return new PushButton("Back", "backDir", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FileSystemHelper.getInstance().noCardPresent(SystemMeasurementSettings.instance().getDataDeviceType())) {
                    CatCard.this.screenManager.popScreen();
                    CatCard.this.displayCatErrorMessageScreen(CatCard.this.screenManager);
                } else {
                    if (CatCard.this.currentDir.endsWith("/")) {
                        CatCard.this.currentDir = CatCard.this.currentDir.substring(0, CatCard.this.currentDir.lastIndexOf("/"));
                    }
                    if (CatCard.this.currentDir.lastIndexOf(47) >= 0) {
                        CatCard.this.currentDir = CatCard.this.currentDir.substring(0, CatCard.this.currentDir.lastIndexOf(47) + 1);
                    } else {
                        CatCard.this.currentDir = "";
                    }
                    CatCard.this.pushCatScreen(true);
                }
            }
        });
    }

    private MenuItem makeDeleteButton() {
        return new PushButton("Delete File", "delete", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = CatCard.this.getSelectedEntry();
                if (!string.startsWith("<DIR> ")) {
                    if (FileSystemHelper.getInstance().noCardPresent(SystemMeasurementSettings.instance().getDataDeviceType())) {
                        CatCard.this.screenManager.popScreen();
                        CatCard.this.displayCatErrorMessageScreen(CatCard.this.screenManager);
                    } else {
                        CatCard.this.screenManager.pushScreen(new ConfirmDeleteScreen(TextMessage.MEDIA_DATA_DELETE_CONFIRM, 2, 30, CatCard.this.currentDir + "/" + string.trim()));
                    }
                }
            }
        });
    }

    public MenuItem makeCatCardButton() {
        return new PushButton("Cat Card", "cat card", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FileSystemHelper.getInstance().noCardPresent(SystemMeasurementSettings.instance().getDataDeviceType())) {
                    CatCard.this.displayCatErrorMessageScreen(CatCard.this.screenManager);
                } else {
                    CatCard.this.currentDir = "";
                    CatCard.this.pushCatScreen(false);
                }
            }
        });
    }

    String getSelectedEntry() {
        ListScreen listScreen = (ListScreen)this.screenManager.getCurrentScreen();
        String string = (String)listScreen.getListModel().getItem(listScreen.getSelectedIndex());
        return string;
    }

    public void displayCatErrorMessageScreen(ScreenManager screenManager) {
        GenericMessageScreen genericMessageScreen = new GenericMessageScreen(TextMessage.MEDIA_DATA_NO_PCMCIA_CAT_FAILURE, true, 4);
        screenManager.pushScreen(genericMessageScreen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getFileList() {
        String string = RuntimeConfiguration.isEmbedded() || this.currentDir.equals("") ? "" : "/";
        String[] stringArray = FileSystemHelper.getInstance().getDeviceFileList(this.storageDevice, this.currentDir);
        try {
            this.storageDevice.mount();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = FileSystemHelper.getInstance().isDirectory(this.storageDevice, this.currentDir + string + stringArray[i]) ? "<DIR> " + stringArray[i] : PADDING + stringArray[i];
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.storageDevice.unmount();
            }
            catch (Exception exception) {}
        }
        if (stringArray.length == 0) {
            stringArray = new String[]{"-- empty --"};
        }
        return stringArray;
    }

    protected MenuItem makeCancelButton(ScreenManager screenManager) {
        return new PushButton("Cancel", "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CatCard.this.pushCatScreen(true);
            }
        });
    }

    class ConfirmDeleteScreen
    extends MessageScreen
    implements MessageScreenListener {
        String prompt = "";
        private String fileName;

        public ConfirmDeleteScreen(String string, int n, int n2, String string2) {
            super("", true, n, n2);
            this.prompt = string;
            this.fileName = string2;
            this.addListener(this);
        }

        public void messageScreenExit(int n) {
            if (n == 2) {
                StorageDevice storageDevice = FileSystemHelper.getInstance().createStorageDevice(SystemMeasurementSettings.instance().getDataDeviceType());
                FileSystemHelper.getInstance().removeFile(storageDevice, this.fileName);
                ListScreen listScreen = (ListScreen)CatCard.this.screenManager.getCurrentScreen();
                int n2 = listScreen.getSelectedIndex();
                CatCard.this.pushCatScreen(true);
                listScreen = (ListScreen)CatCard.this.screenManager.getCurrentScreen();
                if (n2 >= listScreen.getListModel().size()) {
                    n2 = listScreen.getListModel().size() - 1;
                }
                ((ListScreen)CatCard.this.screenManager.getCurrentScreen()).setSelectedIndex(n2);
            }
        }

        public void installScreen(ScreenManager screenManager) {
            super.installScreen(screenManager);
            this.getHTMLRenderer().addVariableReplacment("$FILE$", this.fileName);
            this.setMessage(this.prompt);
        }
    }
}

