/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.DebugPort;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class DebugServer
extends Thread {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$DebugServer == null ? (class$elgato$infrastructure$util$DebugServer = DebugServer.class$("elgato.infrastructure.util.DebugServer")) : class$elgato$infrastructure$util$DebugServer);
    private static final int port = Integer.parseInt(System.getProperty("DebugServer.port", "5100"));
    private ServerSocket serverSocket;
    static /* synthetic */ Class class$elgato$infrastructure$util$DebugServer;

    private DebugServer() {
        super("DebugServer");
        try {
            this.serverSocket = new ServerSocket(port);
        }
        catch (IOException iOException) {
            logger.error("Couldn't bind DebugServer to port " + port, iOException);
        }
    }

    public static DebugServer startup() {
        DebugServer debugServer = new DebugServer();
        debugServer.start();
        return debugServer;
    }

    public void run() {
        ServerSocket serverSocket;
        if (this.serverSocket == null) {
            logger.info("Not bound to socket");
            return;
        }
        logger.info("DebugServer started on port " + this.serverSocket.getLocalPort());
        while ((serverSocket = this.serverSocket) != null) {
            Socket socket;
            if (logger.isDebugEnabled()) {
                logger.debug("Waiting for connection...");
            }
            try {
                socket = serverSocket.accept();
            }
            catch (IOException iOException) {
                logger.error("Couldn't accept connection", iOException);
                break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection received");
            }
            try {
                new DebugPort(socket).start();
            }
            catch (IOException iOException) {
                logger.error("Couldn't create DebugPort", iOException);
            }
        }
        logger.info("DebugServer stopped");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

