/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.Timer;

public final class FastMath {
    private static final int sintabSize = 8192;
    private static final int[] sintab;
    public static final int pi = 16384;
    public static final int ANG_SCALE = 32768;
    private static final int ANG_SCALE_MASK = Short.MAX_VALUE;
    public static final int ANG_Q1 = 8192;
    public static final int ANG_Q2 = 16384;
    public static final int ANG_Q3 = 24576;
    private static final short[] atantab;
    private static final float atanMaxReal = 32.0f;
    private static final int atanMax = 0x200000;
    private static final int atanUnitShift = 8;
    private static final float ln10;
    private static final int[] tens;

    public static int sin(int n) {
        if ((n &= Short.MAX_VALUE) < 8192) {
            return sintab[n];
        }
        if (n < 16384) {
            return sintab[16383 - n];
        }
        if (n < 24576) {
            return -sintab[n - 16384];
        }
        return -sintab[Short.MAX_VALUE - n];
    }

    public static int cos(int n) {
        return FastMath.sin(n + 8192);
    }

    public static int atan(int n) {
        if (n >= 0x200000) {
            return FastMath.float_radiansToAngle((float)Math.atan((double)n / 65536.0));
        }
        if (n >= 0) {
            return atantab[n >> 8];
        }
        return -atantab[-n >> 8];
    }

    public static int atan2(int n, int n2) {
        int n3;
        int n4;
        if (n2 != 0) {
            n4 = (n << 16) / n2;
            if (n4 < 0) {
                n4 = -n4;
            }
        } else {
            n4 = Integer.MAX_VALUE;
        }
        int n5 = FastMath.atan(n4);
        int n6 = n3 = n2 < 0 ? 1 : 0;
        if (n < 0) {
            n3 |= 2;
        }
        switch (n3) {
            case 0: {
                return n5;
            }
            case 1: {
                return 16384 - n5;
            }
            case 2: {
                return -n5;
            }
            case 3: {
                return n5 - 16384;
            }
        }
        throw new Error("Unreachable");
    }

    static int float_degreesToAngle(float f) {
        return Math.round(f * 32768.0f / 360.0f);
    }

    public static int float_radiansToAngle(float f) {
        return FastMath.float_degreesToAngle(f * 180.0f / (float)Math.PI);
    }

    public static int angleToDegrees(int n) {
        return n * 360 / 32768;
    }

    public static int degreesToAngle(int n) {
        return n * 32768 / 360;
    }

    public static int sqrt(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = n + 1 >> 1;
        for (int i = 0; i < 16; ++i) {
            n2 = n2 + n / n2 >> 1;
        }
        return n2;
    }

    public static int fp1616div(int n, int n2) {
        long l = (long)n << 32;
        return (int)(l / (long)n2 >> 16);
    }

    public static int fp1616sqrt(int n) {
        int n2 = n + 65536 >> 1;
        for (int i = 0; i < 8; ++i) {
            n2 = n2 + FastMath.fp1616div(n, n2) >> 1;
        }
        return n2;
    }

    public static int significantBits(int n) {
        int n2;
        int n3 = Integer.MIN_VALUE;
        for (n2 = 32; n2 > 0 && (n & n3) == 0; --n2) {
            n3 >>= 1;
        }
        return n2;
    }

    public static float float_log10(float f) {
        return (float)Math.log(f) / ln10;
    }

    public static int log10(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("x < 0");
        }
        if (n == 0) {
            return Integer.MIN_VALUE;
        }
        for (int i = 0; i < tens.length; ++i) {
            if (n >= tens[i]) continue;
            return i - 1;
        }
        return tens.length - 1;
    }

    public static int pow10(int n) {
        if (n < 0 || n >= tens.length) {
            throw new IllegalArgumentException("invalid x: " + n);
        }
        return tens[n];
    }

    public static int floor(int n, int n2) {
        int n3 = n % n2;
        if (n3 > 0) {
            return n - n3;
        }
        if (n3 < 0) {
            return n - n3 - n2;
        }
        return n;
    }

    public static int ceil(int n, int n2) {
        int n3 = n % n2;
        if (n3 > 0) {
            return n - n3 + n2;
        }
        if (n3 < 0) {
            return n - n3;
        }
        return n;
    }

    public static long ceil(long l, long l2) {
        long l3 = l % l2;
        if (l3 > 0L) {
            return l - l3 + l2;
        }
        if (l3 < 0L) {
            return l - l3;
        }
        return l;
    }

    public static void movingAverage(int[] nArray, int n, int[] nArray2, int n2, int n3, int n4) {
        if (n < 0) {
            throw new IllegalArgumentException("srcOffset < 0: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("dstOffset < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("length < 0: " + n3);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("width < 0: " + n4);
        }
        if (n + n3 > nArray.length) {
            throw new IllegalArgumentException("src violates bounds");
        }
        if (n2 + n3 > nArray2.length) {
            throw new IllegalArgumentException("dst violates bounds");
        }
        if (n4 > n3) {
            n4 = n3;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n + n3;
        while (n5 < n7) {
            int n8;
            int n9 = n5 - n4 / 2;
            if (n9 < n) {
                n9 = n;
            } else if (n9 > n7 - n4) {
                n9 = n7 - n4;
            }
            int n10 = 0;
            int n11 = 0;
            int n12 = n9 + n4;
            for (n8 = n9; n8 < n12; ++n8) {
                int n13 = 256;
                n10 += nArray[n8] * n13 / 256;
                n11 += n13;
            }
            nArray2[n6] = n8 = n10 / (n11 / 256);
            ++n5;
            ++n6;
        }
    }

    static {
        int n;
        sintab = new int[8192];
        atantab = new short[8192];
        Timer timer = new Timer("FastMath/init");
        Timer timer2 = new Timer("FastMath/sintab");
        Timer timer3 = new Timer("FastMath/atantab");
        timer.start();
        timer2.start();
        for (n = 0; n < sintab.length; ++n) {
            FastMath.sintab[n] = (int)Math.round(Math.sin((double)n * 1.5707963267948966 / (double)sintab.length) * 65536.0);
        }
        timer2.stop();
        timer3.start();
        for (n = 0; n < atantab.length; ++n) {
            float f = (float)n / (float)atantab.length * 32.0f;
            FastMath.atantab[n] = (short)FastMath.float_radiansToAngle((float)Math.atan(f));
        }
        timer3.stop();
        timer.stop();
        timer.dump();
        timer2.dump();
        timer3.dump();
        ln10 = (float)Math.log(10.0);
        tens = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }
}

