/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.NetworkConfiguration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FileNetworkConfiguration
extends NetworkConfiguration {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$FileNetworkConfiguration == null ? (class$elgato$infrastructure$util$FileNetworkConfiguration = FileNetworkConfiguration.class$("elgato.infrastructure.util.FileNetworkConfiguration")) : class$elgato$infrastructure$util$FileNetworkConfiguration);
    private static final String REGISTRY_DIRECTORY = "/flash/egServer/registry";
    private static final String SYSTEM_INI = "system.ini";
    private static final String HOSTNAME_KEY = "HOSTNAME";
    private static final String GATEWAY_KEY = "GATEWAY";
    private static final String NETMASK_KEY = "NETMASK";
    private static final String IPADDRESS_KEY = "IPADDR";
    private static final String DHCP_KEY = "BOOTPROTO";
    private static final String DHCP_ON = "dhcp";
    private static final String DHCP_OFF = "none";
    private static final String QUOTE = "\"";
    private static final String EQUALS = "=";
    static /* synthetic */ Class class$elgato$infrastructure$util$FileNetworkConfiguration;

    protected FileNetworkConfiguration() {
        this(FileNetworkConfiguration.getSystemIniFile());
    }

    FileNetworkConfiguration(File file) {
        try {
            this.initValues(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warn("Network configuration file " + file.getAbsolutePath() + " not found. Using defaults and continuing.");
        }
    }

    private static File getSystemIniFile() {
        return new File(REGISTRY_DIRECTORY, SYSTEM_INI);
    }

    public void saveChanges() throws IOException {
        this.saveChanges(FileNetworkConfiguration.getSystemIniFile());
    }

    public void saveChanges(File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        this.writeValue(bufferedWriter, HOSTNAME_KEY, this.getHostname().toString());
        this.writeValue(bufferedWriter, IPADDRESS_KEY, this.getIpAddress().toString());
        this.writeValue(bufferedWriter, GATEWAY_KEY, this.getGateway().toString());
        this.writeValue(bufferedWriter, NETMASK_KEY, this.getSubnetMask().toString());
        this.writeValue(bufferedWriter, DHCP_KEY, this.getDhcpEnabled().booleanValue() ? DHCP_ON : DHCP_OFF);
        bufferedWriter.close();
    }

    private void writeValue(BufferedWriter bufferedWriter, String string, String string2) throws IOException {
        bufferedWriter.write(string + EQUALS + QUOTE + string2 + QUOTE);
        bufferedWriter.newLine();
    }

    private void initValues(File file) throws FileNotFoundException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            while ((string = bufferedReader.readLine()) != null) {
                string.trim();
                if (string.length() <= 0) continue;
                hashtable.put(FileNetworkConfiguration.getKey(string), FileNetworkConfiguration.getValue(string));
            }
            bufferedReader.close();
            this.checkKeys(hashtable, file);
            this.initValues(DHCP_ON.equals(hashtable.get(DHCP_KEY)), hashtable.get(HOSTNAME_KEY).toString(), hashtable.get(IPADDRESS_KEY).toString(), hashtable.get(GATEWAY_KEY).toString(), hashtable.get(NETMASK_KEY).toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unknown IO Exception thrown while reading file " + file.getAbsolutePath() + iOException.getMessage());
        }
    }

    private void checkKeys(Hashtable hashtable, File file) {
        String[] stringArray = new String[]{DHCP_KEY, HOSTNAME_KEY, IPADDRESS_KEY, GATEWAY_KEY, NETMASK_KEY};
        for (int i = 0; i < stringArray.length; ++i) {
            if (hashtable.containsKey(stringArray[i])) continue;
            throw new IllegalStateException("Network configuration file " + file.getAbsolutePath() + " does not contain value for " + stringArray[i]);
        }
    }

    static String getValue(String string) {
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, EQUALS);
        stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            return FileNetworkConfiguration.stripQuotes(stringTokenizer.nextToken());
        }
        return "";
    }

    static String getKey(String string) {
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return new StringTokenizer(string, EQUALS).nextToken();
    }

    static String stripQuotes(String string) {
        if (string.startsWith(QUOTE) && string.endsWith(QUOTE)) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith(QUOTE) && !string.endsWith(QUOTE) || !string.startsWith(QUOTE) && string.endsWith(QUOTE)) {
            throw new IllegalStateException("Improperly quoted value " + string);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

