/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import java.io.File;
import java.util.Vector;

public class FileNode {
    private String filename = null;
    private Vector children = null;
    private boolean directoryNode = false;
    private FileNode parent = null;
    private boolean childrenSorted = false;

    public FileNode(String string) {
        this.filename = string;
    }

    public void addChild(FileNode fileNode) {
        this.childrenSorted = false;
        if (this.children == null) {
            this.children = new Vector();
        }
        if (fileNode == null) {
            return;
        }
        this.children.addElement(fileNode);
        fileNode.setParent(this);
    }

    public FileNode getChild(String string) {
        if (this.children == null) {
            return null;
        }
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            FileNode fileNode = (FileNode)this.children.elementAt(i);
            if (!fileNode.getFilename().equals(string)) continue;
            return fileNode;
        }
        return null;
    }

    public void sortChildren() {
        if (this.childrenSorted) {
            return;
        }
        if (this.children == null) {
            this.childrenSorted = true;
            return;
        }
        int n = this.children.size();
        for (int i = 0; i < n - 1; ++i) {
            FileNode fileNode = (FileNode)this.children.elementAt(i);
            for (int j = i + 1; j < n; ++j) {
                if (fileNode.getFilename().compareTo(((FileNode)this.children.elementAt(j)).getFilename()) <= 0) continue;
                this.children.setElementAt(this.children.elementAt(j), i);
                this.children.setElementAt(fileNode, j);
                fileNode = (FileNode)this.children.elementAt(i);
            }
        }
        this.childrenSorted = true;
    }

    public void setDirectoryNode(boolean bl) {
        this.directoryNode = bl;
    }

    public boolean isDirectoryNode() {
        return this.directoryNode;
    }

    public void setParent(FileNode fileNode) {
        this.parent = fileNode;
    }

    public FileNode getParent() {
        return this.parent;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getQualifiedFilename() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.parent != null) {
            stringBuffer.append(this.parent.getQualifiedFilename());
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(File.separator);
        }
        stringBuffer.append(this.filename);
        return stringBuffer.toString();
    }

    public String getFileTree() {
        return this.getFileTree(0);
    }

    public String getFileTreeAsHTML() {
        return this.getFileTreeAsHTML(0);
    }

    public String getFileTreeAsHTML(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer2.append("...");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer2.append("|- ");
        }
        stringBuffer.append(stringBuffer2.toString() + this.filename + (this.directoryNode ? File.separator : "") + "<BR>\n");
        if (this.children != null) {
            this.sortChildren();
            n2 = this.children.size();
            for (int i = 0; i < n2; ++i) {
                FileNode fileNode = (FileNode)this.children.elementAt(i);
                stringBuffer.append(fileNode.getFileTreeAsHTML(n + 1));
            }
        }
        return stringBuffer.toString();
    }

    public String getFileTree(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer2.append("\t");
        }
        stringBuffer.append(stringBuffer2.toString() + this.filename + (this.directoryNode ? File.separator : "") + "\n");
        if (this.children != null) {
            this.sortChildren();
            n2 = this.children.size();
            for (int i = 0; i < n2; ++i) {
                FileNode fileNode = (FileNode)this.children.elementAt(i);
                stringBuffer.append(fileNode.getFileTree(n + 1));
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.filename;
    }
}

