/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import com.sun.jimi.core.Jimi;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.util.Arrays;
import elgato.infrastructure.util.FileNode;
import elgato.infrastructure.util.IStorageDevice;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.StorageDevice;
import elgato.infrastructure.util.StringComparator;
import elgato.infrastructure.util.SystemProcess;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.WindowsStorageDevice;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileSystemHelper {
    public static final int DF_DEVICE = 0;
    public static final int DF_CAPACITY = 1;
    public static final int DF_USED = 2;
    public static final int DF_FREE = 3;
    public static final int DF_PERCENT_USED = 4;
    public static final int DF_DIRECTORY = 5;
    public static final int PCMCIA = 0;
    public static final int CF = 1;
    public static final String WINDOWS_DIR = "c:";
    public static final String LINUX_DIR = "/tmp";
    public static final String SCREEN_EXTENSION = ".png";
    public static final String DATA_EXTENSION = ".xls";
    public static final String TEXT_EXTENSION = ".txt";
    public static final String HTML_EXTENSION = ".html";
    public static final String[] DEVICE_MOUNT_DIR_KEYS = new String[]{"mount.directory.pcmcia", "mount.directory.cf"};
    public static final String[] DEVICE_TYPES = new String[]{"screen.system.media.pcmcia", "screen.system.media.cf"};
    public static final int DATA = 0;
    public static final int SCREEN = 1;
    public static final int OVERWRITE = 1;
    public static final int PROMPT = 0;
    public static final int AUTOINCREMENT = 2;
    public static final int TIMESTAMP = 3;
    public static final int APPEND = 4;
    public static final int FILENAME_AUTO = 1;
    public static final int FILENAME_USER = 0;
    public static final int FILENAME_ASK = 2;
    public static SettingsModel globalSettingsModel = null;
    public static final String DEFAULT_FILENAME = "file";
    static final String CONFIG_DIRECTORY_ON_UNIT = "/flash/scriptconfig/";
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$FileSystemHelper == null ? (class$elgato$infrastructure$util$FileSystemHelper = FileSystemHelper.class$("elgato.infrastructure.util.FileSystemHelper")) : class$elgato$infrastructure$util$FileSystemHelper);
    private static final Resources systemResources = Resources.getResources("elgato.system");
    private static final DecimalFormat twoZeroes = new DecimalFormat("00");
    private static Hashtable dirSemaphores;
    protected static String readFileResult;
    private static FileSystemHelper instance;
    public static final String EXCEPTION_INDICATOR = "Exception while reading from the file.";
    static String log;
    static /* synthetic */ Class class$elgato$infrastructure$util$FileSystemHelper;

    public static FileSystemHelper getInstance() {
        if (instance == null) {
            instance = new FileSystemHelper();
        }
        return instance;
    }

    public static void setInstance(FileSystemHelper fileSystemHelper) {
        instance = fileSystemHelper;
    }

    public DirSemaphore getDirSemaphore(String string) {
        try {
            return (DirSemaphore)dirSemaphores.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addDirSemaphore(DirSemaphore dirSemaphore) {
        try {
            if (dirSemaphores == null) {
                dirSemaphores = new Hashtable(3);
            }
            dirSemaphores.put(dirSemaphore.getKey(), dirSemaphore);
        }
        catch (Exception exception) {
            logger.debug("addDirSemaphore(): e> " + exception);
        }
    }

    public void removeDirSemaphore(DirSemaphore dirSemaphore) {
        try {
            if (dirSemaphores == null) {
                return;
            }
            dirSemaphores.remove(dirSemaphore.getKey());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializeDirSemaphore(String string, String string2) {
        try {
            DirSemaphore dirSemaphore = new DirSemaphore(string, string2);
            new Thread(dirSemaphore).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getFileExistsOptions() {
        return new String[]{Text.Prompt, Text.Overwrite, Text.Auto_Incr, Text.Timestamp, Text.Append};
    }

    public boolean isDirSemaphoreClear(String string) {
        try {
            return this.getDirSemaphore(string) == null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final String getBaseDirectory() {
        if (RuntimeConfiguration.isEmbedded()) {
            return "";
        }
        if (RuntimeConfiguration.isLinux()) {
            return LINUX_DIR;
        }
        return WINDOWS_DIR;
    }

    public final boolean isDeviceReady(int n) {
        String string = this.determineDevice(n);
        return string != null;
    }

    public String getLocalDirectory() {
        if (!RuntimeConfiguration.isEmbedded()) {
            if (RuntimeConfiguration.isLinux()) {
                return LINUX_DIR;
            }
            return WINDOWS_DIR;
        }
        return null;
    }

    public String[] getDeviceFileList(int n) {
        return this.getDeviceFileList(n, "", "", true);
    }

    public String[] getDeviceFileList(IStorageDevice iStorageDevice, String string) {
        return this.getDeviceFileList(iStorageDevice, string, "", true);
    }

    public String[] getDeviceFileList(int n, String string) {
        return this.getDeviceFileList(n, "", string, true);
    }

    public String[] getDeviceFileList(int n, String string, String string2, boolean bl) {
        String[] stringArray = null;
        StorageDevice storageDevice = null;
        storageDevice = this.createStorageDevice(n);
        stringArray = this.getDeviceFileList(storageDevice, string, string2, bl);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getDeviceFileList(IStorageDevice iStorageDevice, String string, String string2, boolean bl) {
        String[] stringArray = null;
        try {
            if (iStorageDevice != null) {
                iStorageDevice.mount();
                stringArray = this.getFileList(string.equals("") ? iStorageDevice.getDirectory() : iStorageDevice.getDirectory() + "/" + string, string2, bl);
            }
        }
        catch (Exception exception) {
            logger.warn("getDeviceFileList(): " + exception);
        }
        finally {
            try {
                iStorageDevice.unmount();
            }
            catch (Exception exception) {}
        }
        return stringArray;
    }

    private String stripFileExtension(String string) {
        try {
            int n;
            int n2 = string.length();
            for (n = n2 - 1; n >= 0 && string.charAt(n) != '.'; --n) {
            }
            if (n > 0) {
                return string.substring(0, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean noCardPresent(int n) {
        String string = FileSystemHelper.getInstance().getLocalDirectory();
        StorageDevice storageDevice = FileSystemHelper.getInstance().createStorageDevice(n);
        if (storageDevice == null && string != null && !string.equals("")) {
            return false;
        }
        return storageDevice == null;
    }

    public String[] getFileList(StorageDevice storageDevice, String string) {
        SystemProcess systemProcess;
        String string2 = FileSystemHelper.getInstance().getLocalDirectory();
        String[] stringArray = null;
        if (storageDevice == null && string2 != null && !string2.equals("")) {
            return this.getFileList(string2 + string);
        }
        if (storageDevice != null && ((systemProcess = this.mount(storageDevice.getDevice(), storageDevice.getDirectory())).getExitCode() == 0 || systemProcess.getExitCode() == 32)) {
            stringArray = FileSystemHelper.getInstance().getFileList(storageDevice.getDirectory() + string);
            systemProcess = this.unmount(storageDevice.getDevice());
        }
        return stringArray;
    }

    public String[] getFileList(String string) {
        return this.getFileList(string, "", true);
    }

    public String[] getFileList(String string, String string2) {
        return this.getFileList(string, string2, true);
    }

    public String[] getFileList(String string, String string2, boolean bl) {
        Object[] objectArray = null;
        try {
            File file = new File(string);
            if (file == null) {
                return null;
            }
            if (!file.exists()) {
                return null;
            }
            if (!file.isDirectory()) {
                return null;
            }
            objectArray = file.list(new EndsWithFilenameFilter(string2));
            Arrays.sort(objectArray, new StringComparator());
            if (!bl) {
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.stripFileExtension((String)objectArray[i]);
                }
            }
            return objectArray;
        }
        catch (Exception exception) {
            logger.warn("getFileList(" + string + "): " + exception);
            return null;
        }
    }

    public boolean isMounted(String string) {
        SystemProcess systemProcess = this.getSystemProcess("mount");
        systemProcess.execute(true);
        boolean bl = systemProcess.processOutputContains(string);
        return bl;
    }

    public SystemProcess mount(String string) {
        return this.mount(string, null);
    }

    public SystemProcess mount(String string, String string2) {
        String string3 = "mount " + string + (string2 == null ? "" : " " + string2);
        logger.info("mounting: " + string + " on" + (string2 == null ? "" : " " + string2));
        SystemProcess systemProcess = this.getSystemProcess(string3);
        int n = systemProcess.execute(true);
        if (n == 1) {
            n = 0;
        }
        systemProcess.setExitCode(n);
        return systemProcess;
    }

    SystemProcess getSystemProcess(String string) {
        SystemProcess systemProcess = new SystemProcess(string);
        return systemProcess;
    }

    public SystemProcess unmount(String string) {
        SystemProcess systemProcess = this.getSystemProcess("umount " + string);
        systemProcess.execute(true);
        return systemProcess;
    }

    public String getDeviceString(String string, int n) {
        SystemProcess systemProcess = new SystemProcess("df " + string);
        systemProcess.execute(true);
        Vector vector = systemProcess.getProcessOutput();
        if (vector == null) {
            return null;
        }
        int n2 = vector.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)vector.elementAt(i));
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (n3++ != n) continue;
                return string2;
            }
        }
        return null;
    }

    public int getDeviceStorage(String string, int n) {
        String string2 = this.getDeviceString(string, n);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getDeviceStorageCapacity(String string) {
        return this.getDeviceStorage(string, 1);
    }

    public int getDeviceStorageUsed(String string) {
        return this.getDeviceStorage(string, 2);
    }

    public String getDirectoryFromDevice(String string) {
        return this.getDeviceString(string, 5);
    }

    public long getFileSize(String string) throws FileNotFoundException {
        File file = new File(string);
        if (!file.isFile()) {
            throw new FileNotFoundException("File '" + string + "' was not found or is not a file.");
        }
        return file.length();
    }

    public SystemProcess format(String string) {
        if (!string.startsWith("/")) {
            string = "/dev/" + string + "1";
        }
        String string2 = "mkdosfs " + string;
        SystemProcess systemProcess = new SystemProcess(string2);
        systemProcess.execute(true);
        return systemProcess;
    }

    public void writeToFile(String string, InputStream inputStream) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            int n;
            byte[] byArray = new byte[512];
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            logger.error("error writing config file" + iOException.getMessage());
        }
    }

    public StorageDevice createStorageDevice(int n) {
        String string = this.determineDevice(n);
        if (string == null) {
            return null;
        }
        string = "/dev/" + string + "1";
        String string2 = systemResources.getString(DEVICE_MOUNT_DIR_KEYS[n]);
        StorageDevice storageDevice = null;
        try {
            storageDevice = new StorageDevice(string, string2, true);
        }
        catch (InstantiationException instantiationException) {
            logger.error("createStorageDevice(" + n + ")", instantiationException);
            return null;
        }
        return storageDevice;
    }

    public boolean fileExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fileExists(String string, int n) {
        if (n < 0) {
            return this.fileExists(string);
        }
        StorageDevice storageDevice = null;
        try {
            boolean bl;
            storageDevice = this.createStorageDevice(n);
            if (storageDevice == null) {
                boolean bl2 = false;
                return bl2;
            }
            if (!storageDevice.mount()) {
                boolean bl3 = false;
                return bl3;
            }
            boolean bl4 = bl = this.fileExists(string);
            return bl4;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            try {
                storageDevice.unmount();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public long getUniqueID() {
        long l = SettingsModel.getGlobalSettingsModel().getLong("display.global.systemUniqueID");
        SettingsModel.getGlobalSettingsModel().set("display.global.systemUniqueID", ++l);
        return l;
    }

    public String getTimestamp() {
        boolean bl = false;
        if (!RuntimeConfiguration.isEmbedded()) {
            bl = true;
        }
        if (!bl) {
            return "" + System.currentTimeMillis();
        }
        Calendar calendar = Calendar.getInstance();
        String string = "" + String.valueOf(calendar.get(1)) + twoZeroes.format(calendar.get(2)) + twoZeroes.format(calendar.get(5)) + "_" + twoZeroes.format(calendar.get(11)) + twoZeroes.format(calendar.get(12)) + twoZeroes.format(calendar.get(13));
        return string;
    }

    public SystemProcess saveImage(String string, Image image) {
        return this.saveImage(null, string, image, true);
    }

    public SystemProcess saveImage(StorageDevice storageDevice, String string, Image image, boolean bl) {
        SystemProcess systemProcess = null;
        if (storageDevice != null && (systemProcess = bl ? this.mount(storageDevice.getDevice()) : this.mount(storageDevice.getDevice(), storageDevice.getDirectory())).getExitCode() != 0) {
            logger.warn(systemProcess.getLogMessage());
            if (systemProcess.getExitCode() != 32) {
                return systemProcess;
            }
        }
        try {
            Jimi.putImage((Image)image, (String)string);
        }
        catch (Exception exception) {
            logger.error("saveImage(" + storageDevice + ", " + string + ", image, " + bl + "): ", exception);
            systemProcess = new SystemProcess("Jimi.putImage(image," + string + ")");
            systemProcess.setException(exception);
            systemProcess.setExitCode(1);
            if (storageDevice != null) {
                try {
                    this.unmount(storageDevice.getDevice());
                }
                catch (Exception exception2) {
                    logger.error("failed unmounting : " + storageDevice.getDevice(), exception);
                }
            }
            return systemProcess;
        }
        if (storageDevice != null) {
            systemProcess = this.unmount(storageDevice.getDevice());
        } else {
            systemProcess = new SystemProcess("Jimi.putImage(image," + string + ")");
            systemProcess.setExitCode(0);
            systemProcess.put("imageName", string);
        }
        try {
            if (storageDevice != null && storageDevice.isMounted()) {
                storageDevice.unmount();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return systemProcess;
    }

    public String getReadFileResult() {
        return readFileResult;
    }

    public String readFromFile(String string) {
        String string2 = "";
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[512];
            while ((n = fileInputStream.read(byArray)) > 0) {
                String string3 = new String(byArray);
                if (n < 512) {
                    string3 = string3.substring(0, n);
                }
                string2 = string2 + string3;
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            return "Exception while reading from the file.\n" + iOException.getMessage();
        }
        return string2;
    }

    public boolean save(String string, String string2, String string3) {
        StorageDevice storageDevice = this.createStorageDevice(SystemMeasurementSettings.instance().getDataDeviceType());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes());
        if (storageDevice == null) {
            String string4 = this.getLocalDirectory();
            if (string4.equals("")) {
                return false;
            }
            try {
                this.writeToFile(string4 + "/" + string2 + string, byteArrayInputStream);
            }
            catch (IOException iOException) {
                return false;
            }
        } else {
            this.saveFile(storageDevice, storageDevice.getDirectory() + "/" + string2 + string, byteArrayInputStream);
        }
        return true;
    }

    public String readLicensedOptions(String string) {
        String string2 = this.getLocalDirectory() == null ? CONFIG_DIRECTORY_ON_UNIT : "c:\\";
        return this.readFromFile(string2 + string);
    }

    public String read(String string, String string2) {
        StorageDevice storageDevice = this.createStorageDevice(SystemMeasurementSettings.instance().getDataDeviceType());
        String string3 = "";
        if (storageDevice == null) {
            String string4 = this.getLocalDirectory();
            string3 = string4 == null ? this.readFromFile(CONFIG_DIRECTORY_ON_UNIT + string2 + string) : this.readFromFile(string4 + "/" + string2 + string);
        } else {
            this.readFile(storageDevice, string2 + string);
            string3 = this.getReadFileResult();
        }
        return string3;
    }

    public SystemProcess readFile(StorageDevice storageDevice, String string) {
        readFileResult = "";
        SystemProcess systemProcess = this.mount(storageDevice.getDevice(), storageDevice.getDirectory());
        if (systemProcess.getExitCode() == 0 || systemProcess.getExitCode() == 32) {
            readFileResult = this.readFromFile(storageDevice.getDirectory() + "/" + string);
            systemProcess = this.unmount(storageDevice.getDevice());
        }
        return systemProcess;
    }

    public SystemProcess saveFile(StorageDevice storageDevice, String string, InputStream inputStream) {
        SystemProcess systemProcess = this.mount(storageDevice.getDevice(), storageDevice.getDirectory());
        if (systemProcess.getExitCode() == 0 || systemProcess.getExitCode() == 32) {
            try {
                this.writeToFile(string, inputStream);
            }
            catch (IOException iOException) {
                systemProcess = new SystemProcess("FileSystemHelper.writeToFile(" + string + ")");
                systemProcess.setException(iOException);
                return systemProcess;
            }
        }
        systemProcess = this.unmount(storageDevice.getDevice());
        return systemProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter getPrintWriter(StorageDevice storageDevice, String string, String string2, SystemProcess systemProcess) {
        PrintWriter printWriter;
        block16: {
            printWriter = null;
            try {
                boolean bl;
                if (storageDevice != null && !(bl = storageDevice.mount())) {
                    systemProcess.setExitCode(1);
                    systemProcess.setException(new IOException("Unable to mount device."));
                    return null;
                }
                String string3 = "UnicodeLittle";
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(string)), string3));
                if (printWriter == null) {
                    systemProcess.setException(new NullPointerException("Unable to create a writable file. '" + string + "'."));
                    systemProcess.setExitCode(2);
                }
                if (string2 == null) break block16;
                Reader reader = null;
                try {
                    int n;
                    reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(string2)), string3);
                    while ((n = reader.read()) != -1) {
                        printWriter.write(n);
                    }
                    printWriter.write(46);
                    printWriter.write(10);
                }
                catch (Exception exception) {
                    systemProcess.setException(exception);
                    systemProcess.setExitCode(3);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                    this.removeFile(string2);
                }
            }
            catch (Exception exception) {
                systemProcess.setException(exception);
                systemProcess.setExitCode(1);
            }
        }
        return printWriter;
    }

    public void unmountAll() {
        int n = DEVICE_MOUNT_DIR_KEYS.length;
        for (int i = 0; i < n; ++i) {
            this.unmount(systemResources.getString(DEVICE_MOUNT_DIR_KEYS[i]));
        }
    }

    public String determineDevice(int n) {
        File file = new File("/var/lib/pcmcia/stab");
        if (!file.exists() && !(file = new File("/var/run/stab")).exists()) {
            logger.debug("determineDevice(" + n + "): stab file not found.");
            return null;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                logger.debug("determineDevice(" + n + "): out> " + string);
                if (!string.startsWith(String.valueOf(n))) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!string2.startsWith("hd")) continue;
                    return string2;
                }
            }
        }
        catch (Exception exception) {
            logger.error("determineDevice(" + n + ")", exception);
        }
        return null;
    }

    public void removeFile(String string) {
        File file = new File(string);
        file.delete();
    }

    public SystemProcess removeFile(StorageDevice storageDevice, String string) {
        if (RuntimeConfiguration.isLinux()) {
            SystemProcess systemProcess = this.mount(storageDevice.getDevice(), storageDevice.getDirectory());
            if (systemProcess.getExitCode() == 0 || systemProcess.getExitCode() == 32) {
                this.removeFile(storageDevice.getDirectory() + "/" + string);
                systemProcess = this.unmount(storageDevice.getDevice());
            }
            return systemProcess;
        }
        string = this.convertSlashes(string);
        this.removeFile(FileSystemHelper.getInstance().getLocalDirectory() + "\\" + string);
        return null;
    }

    public String convertSlashes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while ((n = string.indexOf("/", n)) != -1) {
            stringBuffer.setCharAt(n++, '\\');
        }
        return stringBuffer.toString();
    }

    public SystemProcess untar(String string, String string2) {
        return this.tar(string, "", "--directory=" + string2 + " -xvf ", null);
    }

    public SystemProcess untar(String string, String string2, SystemProcess.ProcessOutputListener processOutputListener) {
        return this.tar(string, "", "--directory=" + string2 + " -xvf ", processOutputListener);
    }

    public SystemProcess tar(String string, String string2, String string3) {
        return this.tar(string, string2, string3, null);
    }

    public SystemProcess tar(String string, String string2, String string3, SystemProcess.ProcessOutputListener processOutputListener) {
        SystemProcess systemProcess = null;
        String string4 = "";
        string4 = RuntimeConfiguration.isEmbedded() || RuntimeConfiguration.isLinux() ? "tar " + string3 : "move ";
        string4 = string4 + string + " " + string2;
        systemProcess = new SystemProcess(string4);
        if (processOutputListener != null) {
            systemProcess.addProcessOutputListener(processOutputListener);
        }
        systemProcess.executeWithNotification(true);
        systemProcess.put("tarFilename", string);
        systemProcess.put("targetDir", string2);
        return systemProcess;
    }

    public final SystemProcess moveFile(String string, String string2) {
        SystemProcess systemProcess = null;
        String string3 = "";
        string3 = RuntimeConfiguration.isEmbedded() || RuntimeConfiguration.isLinux() ? "mv -f " : "move ";
        string3 = string3 + string + " " + string2;
        systemProcess = new SystemProcess(string3);
        systemProcess.execute(true);
        systemProcess.put("source", string);
        systemProcess.put("target", string2);
        return systemProcess;
    }

    public final SystemProcess removeDirectory(String string) {
        SystemProcess systemProcess = null;
        String string2 = "";
        string2 = RuntimeConfiguration.isEmbedded() || RuntimeConfiguration.isLinux() ? "rm -Rf " : "rmdir ";
        string2 = string2 + string;
        systemProcess = new SystemProcess(string2);
        systemProcess.execute(true);
        systemProcess.put("directory", string);
        return systemProcess;
    }

    public final SystemProcess copyFile(String string, String string2) {
        String string3 = "";
        string3 = RuntimeConfiguration.isEmbedded() || RuntimeConfiguration.isLinux() ? "cp -f " : "copy ";
        string3 = string3 + string + " " + string2;
        SystemProcess systemProcess = new SystemProcess(string3);
        systemProcess.execute(true);
        systemProcess.put("source", string);
        systemProcess.put("target", string2);
        return systemProcess;
    }

    public final SystemProcess copyDirectory(String string, String string2) {
        SystemProcess systemProcess = null;
        String string3 = "";
        string3 = RuntimeConfiguration.isEmbedded() || RuntimeConfiguration.isLinux() ? "cp -Rf " : "copy ";
        string3 = string3 + string + " " + string2;
        systemProcess = new SystemProcess(string3);
        systemProcess.execute(true);
        systemProcess.put("source", string);
        systemProcess.put("target", string2);
        return systemProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SystemProcess copyFile(String string, String string2, int n) {
        if (n < 0) {
            return this.copyFile(string, string2);
        }
        SystemProcess systemProcess = new SystemProcess("copyFile(" + string + ", " + string2 + ", " + n + ")");
        StorageDevice storageDevice = null;
        try {
            storageDevice = this.createStorageDevice(n);
            if (storageDevice == null) {
                systemProcess.setExitCode(11);
                logger.error("could not create device with magic device number: " + n);
                SystemProcess systemProcess2 = systemProcess;
                return systemProcess2;
            }
            if (!storageDevice.mount()) {
                systemProcess.setExitCode(12);
                logger.error("could not mount " + storageDevice.getDirectory());
                SystemProcess systemProcess3 = systemProcess;
                return systemProcess3;
            }
            SystemProcess systemProcess4 = this.copyFile(string, string2);
            return systemProcess4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            systemProcess.setException(exception);
            systemProcess.setExitCode(13);
            return systemProcess;
        }
        finally {
            try {
                storageDevice.unmount();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final SystemProcess getFileSystemTree(int n, String string) {
        StorageDevice storageDevice;
        SystemProcess systemProcess;
        block25: {
            block23: {
                systemProcess = new SystemProcess("getFileSystemTree(" + n + ")");
                systemProcess.setExitCode(0);
                storageDevice = null;
                storageDevice = this.createStorageDevice(n);
                if (storageDevice != null) break block23;
                systemProcess.setExitCode(11);
                SystemProcess systemProcess2 = systemProcess;
                Object var8_9 = null;
                try {
                    if (storageDevice != null) {
                        storageDevice.unmount();
                    }
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return systemProcess2;
            }
            if (storageDevice.mount()) break block25;
            systemProcess.setExitCode(12);
            SystemProcess systemProcess3 = systemProcess;
            Object var8_10 = null;
            try {
                if (storageDevice != null) {
                    storageDevice.unmount();
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return systemProcess3;
        }
        FileNode fileNode = this.getFileSystemTree(null, storageDevice.getDirectory() + File.separator + string, 0, 5);
        if (fileNode != null) {
            systemProcess.put("fileNode", fileNode);
        }
        SystemProcess systemProcess4 = systemProcess;
        Object var8_11 = null;
        try {
            if (storageDevice != null) {
                storageDevice.unmount();
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return systemProcess4;
        catch (Exception exception) {
            try {
                systemProcess.setException(exception);
                systemProcess.setExitCode(13);
                Object var8_12 = null;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                try {
                    if (storageDevice != null) {
                        storageDevice.unmount();
                    }
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (storageDevice != null) {
                    storageDevice.unmount();
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        return systemProcess;
    }

    public FileNode getFileSystemTree(String string, String string2, int n, int n2) {
        if (logger.isDebugEnabled()) {
            logger.debug("getFileSystemTree(" + string2 + "): starting...");
        }
        FileNode fileNode = new FileNode(string2);
        try {
            string = string != null ? string + File.separator : "";
            File file = new File(string + string2);
            if (file.isDirectory() && n2 >= n) {
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    fileNode.addChild(this.getFileSystemTree(string + string2, stringArray[i], n + 1, n2));
                }
            }
            return fileNode;
        }
        catch (Exception exception) {
            logger.error("Couldn't get file system tree for file " + string2, exception);
            return null;
        }
    }

    public boolean mkdir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
            return true;
        }
        return false;
    }

    public boolean isDirectory(IStorageDevice iStorageDevice, String string) {
        String string2 = iStorageDevice instanceof WindowsStorageDevice ? iStorageDevice.getDirectory() + string : iStorageDevice.getDirectory() + "/" + string;
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.lastIndexOf("/"));
        }
        return new File(string2).isDirectory();
    }

    public void debugOut(String string) {
        if (RuntimeConfiguration.isEmbedded()) {
            log = log + string;
            StorageDevice storageDevice = this.createStorageDevice(0);
            FileSystemHelper.getInstance().saveFile(storageDevice, storageDevice.getDirectory() + "/" + "debug", new ByteArrayInputStream(log.getBytes()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = "";
    }

    public static class EndsWithFilenameFilter
    implements FilenameFilter {
        String pattern = null;

        public EndsWithFilenameFilter(String string) {
            this.pattern = string;
        }

        public boolean accept(File file, String string) {
            return string.endsWith(this.pattern);
        }
    }

    public static class DirectoryFilenameFilter
    implements FilenameFilter {
        String[] excludeList = new String[0];

        public DirectoryFilenameFilter(String[] stringArray) {
            this.excludeList = stringArray;
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file.getAbsolutePath() + File.separator + string);
            if (!file2.isDirectory()) {
                return false;
            }
            for (int i = 0; i < this.excludeList.length; ++i) {
                if (!string.equals(this.excludeList[i])) continue;
                return false;
            }
            return true;
        }
    }

    private class DirSemaphore
    implements Runnable {
        String key;
        String dirname;
        int timeout;

        public DirSemaphore(String string, String string2) {
            this(string, string2, 0);
        }

        public DirSemaphore(String string, String string2, int n) {
            this.key = string;
            this.dirname = string2;
            this.timeout = n;
        }

        public String getKey() {
            return this.key;
        }

        public void run() {
            FileSystemHelper.this.addDirSemaphore(this);
            int n = 0;
            SystemProcess systemProcess = new SystemProcess("mkdir " + this.dirname);
            while (true) {
                try {
                    systemProcess.execute();
                    if (systemProcess.getExitCode() == 0) {
                        FileSystemHelper.this.removeDirSemaphore(this);
                        break;
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.timeout <= 0 || n++ < this.timeout) continue;
                FileSystemHelper.this.removeDirSemaphore(this);
            }
        }
    }
}

