/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.WebplugConversion;
import elgato.infrastructure.mainScreens.RestartScreen;
import elgato.infrastructure.util.LocaleData;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Vector;

public class LocaleManager {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$LocaleManager == null ? (class$elgato$infrastructure$util$LocaleManager = LocaleManager.class$("elgato.infrastructure.util.LocaleManager")) : class$elgato$infrastructure$util$LocaleManager);
    private static Locale currentLocale = LocaleManager.selectLocaleToUse();
    private static final Value[] localeValues = LocaleManager.getLocaleValues();
    private static ListActuator localeActuator = new ListActuator("", "", "", localeValues){

        public String getLabel() {
            return Text.Language;
        }
    };
    static /* synthetic */ Class class$elgato$infrastructure$util$LocaleManager;

    private static Locale getLocaleFromSystemProperty() {
        String string = System.getProperty("locale");
        if (string == null) {
            return null;
        }
        return LocaleManager.parseLocaleCode(string);
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale[] getAvailableLocales() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("elgato/locales.dat")));
        Vector<Locale> vector = new Vector<Locale>();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.startsWith("#")) continue;
                vector.addElement(LocaleManager.parseLocaleCode(string));
            }
        }
        catch (IOException iOException) {
            logger.error("Couldn't load available locales", iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        Object[] objectArray = new Locale[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static ListActuator getLocaleActuator() {
        return localeActuator;
    }

    private static Value[] getLocaleValues() {
        Locale[] localeArray = LocaleManager.getAvailableLocales();
        Value[] valueArray = new LocaleValue[localeArray.length];
        for (int i = 0; i < localeArray.length; ++i) {
            Locale locale = localeArray[i];
            valueArray[i] = new LocaleValue(locale);
        }
        return valueArray;
    }

    private static Locale selectLocaleToUse() {
        Locale locale = LocaleManager.getLocaleFromSystemProperty();
        if (locale != null) {
            return locale;
        }
        if (RuntimeConfiguration.isUnitTestMode()) {
            return Locale.getDefault();
        }
        locale = LocaleManager.retreiveLocale();
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Locale retreiveLocale() {
        Locale locale;
        File file = new File(LocaleManager.getLocaleFilePath());
        if (!file.exists()) {
            logger.info("No locale set, using default.");
            return Locale.getDefault();
        }
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                locale = LocaleManager.parseLocaleCode(string.trim());
                Object var5_6 = null;
            }
            catch (IOException iOException) {
                logger.error("Error reading locale from file");
                Locale locale2 = Locale.getDefault();
                Object var5_7 = null;
                try {
                    if (bufferedReader == null) return locale2;
                    bufferedReader.close();
                    return locale2;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return locale2;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return locale;
        }
        if (bufferedReader == null) return locale;
        bufferedReader.close();
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void storeLocale(Locale locale) {
        block11: {
            FileWriter fileWriter = null;
            fileWriter = new FileWriter(LocaleManager.getLocaleFilePath());
            fileWriter.write(locale.toString());
            Object var4_2 = null;
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
                break block11;
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (IOException iOException) {
                    logger.error("Error writing locale to file", iOException);
                    Object var4_3 = null;
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                        break block11;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static String getLocaleFilePath() {
        if (RuntimeConfiguration.isEmbedded()) {
            return "/flash/egGui/locale";
        }
        return System.getProperty("java.io.tmpdir") + "/.egGui_locale";
    }

    private static Locale parseLocaleCode(String string) {
        String string2;
        String string3;
        String string4;
        int n = string.indexOf(95);
        if (n < 0) {
            string4 = string;
            string3 = "";
            string2 = "";
        } else {
            string4 = string.substring(0, n);
            int n2 = string.indexOf(95, n + 1);
            if (n2 < 0) {
                string3 = string.substring(n + 1);
                string2 = "";
            } else {
                string3 = string.substring(n + 1, n2);
                string2 = string.substring(n2 + 1);
            }
        }
        return new Locale(string4, string3, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        localeActuator.setWebPlugConversion(new LocaleWebplugConversion(localeActuator));
        localeActuator.setValueObject(new LocaleValue(currentLocale));
    }

    private static class LocaleWebplugConversion
    implements WebplugConversion {
        private ListActuator actuator;

        public LocaleWebplugConversion(ListActuator listActuator) {
            this.actuator = listActuator;
        }

        public String getTopic() {
            return "";
        }

        public String getPropertyName() {
            return "";
        }

        public Command buildInitialGet(Command command) {
            return command;
        }

        public void receive(Command command) {
        }

        public void send(Command command) {
        }

        public void send() {
            LocaleManager.storeLocale(((LocaleValue)this.actuator.getSelectedValue()).getLocale());
            RestartScreen.promptForRestart(RestartScreen.restartGUI);
        }
    }

    private static class LocaleValue
    extends Value {
        public LocaleValue(Locale locale) {
            super(LocaleData.getDisplayName(locale, LocaleManager.getCurrentLocale()), locale);
        }

        public LocaleValue(String string) {
            this(LocaleManager.parseLocaleCode(string));
        }

        public boolean isValid(String string) {
            return true;
        }

        public boolean isValid() {
            return true;
        }

        public long longValue() {
            throw new RuntimeException("not implemented");
        }

        public int intValue() {
            throw new RuntimeException("not implemented");
        }

        public boolean booleanValue() {
            throw new RuntimeException("not implemented");
        }

        public void setValue(long l) {
            throw new RuntimeException("not implemented");
        }

        public void setValue(String string) {
            this.changeValue(LocaleManager.parseLocaleCode(string));
        }

        public void setValue(int n) {
            throw new RuntimeException("not implemented");
        }

        public Locale getLocale() {
            return (Locale)this.getValueObject();
        }
    }
}

