/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.Socket;
import java.util.Properties;

public class LogClient
implements Runnable {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$LogClient == null ? (class$elgato$infrastructure$util$LogClient = LogClient.class$("elgato.infrastructure.util.LogClient")) : class$elgato$infrastructure$util$LogClient);
    private static final String END_OF_MESSAGE = "\n.\n";
    private static final int MAX_FAILURES = 1;
    private static int connectFailures = 0;
    private static int sendFailures = 0;
    private static Socket logSocket = null;
    private String host;
    private int port;
    private Properties properties = new Properties();
    private static boolean logging = false;
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8000;
    private static LogClient instance = null;
    static /* synthetic */ Class class$elgato$infrastructure$util$LogClient;

    public LogClient(String string) {
        this.loadProperties(string);
        this.loadValues();
    }

    public LogClient(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public static void setInstance(String string, int n) {
        instance = new LogClient(string, n);
    }

    public static void setInstance(String string) {
        instance = new LogClient(string);
    }

    public static LogClient getInstance() {
        return instance;
    }

    public static void setLogging(boolean bl) {
        logging = bl;
    }

    public static boolean isLogging() {
        return logging;
    }

    public static boolean initialize() {
        try {
            String string = FileSystemHelper.getInstance().getBaseDirectory() + File.separator + "flash" + File.separator + "logClient.properties";
            File file = new File(string);
            if (!file.exists()) {
                LogClient.setLogging(false);
                instance = new LogClient(DEFAULT_HOST, 8000);
                return false;
            }
            LogClient.setInstance(string);
            LogClient.setLogging(true);
            return true;
        }
        catch (Exception exception) {
            logger.debug("initialize: " + exception);
            return false;
        }
    }

    private void loadValues() {
        if (this.properties == null) {
            this.host = DEFAULT_HOST;
            this.port = 8000;
        }
        this.host = this.properties.getProperty("host");
        this.port = Integer.parseInt(this.properties.getProperty("port"));
    }

    private void loadProperties(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            if (fileInputStream == null) {
                return;
            }
            this.properties.load(fileInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int open(String string, int n) {
        try {
            if (logSocket != null) {
                return 1;
            }
            instance.setLogSocket(new Socket(string, n));
            return 0;
        }
        catch (Exception exception) {
            if (++connectFailures >= 1) {
                logging = false;
            }
            logger.debug("open(" + string + ", " + n + "): " + exception);
            return -1;
        }
    }

    public static int open() {
        if (instance == null) {
            return -1;
        }
        return LogClient.open(LogClient.instance.host, LogClient.instance.port);
    }

    public void setLogSocket(Socket socket) {
        logSocket = socket;
    }

    public static void log(String string) {
        try {
            if (instance == null) {
                LogClient.initialize();
            }
            if (!logging) {
                return;
            }
            Thread thread = new Thread((Runnable)LogClient.getInstance(), "logMessage:" + string);
            thread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void logDatagramPacket(DatagramPacket datagramPacket) {
        LogClient.logDatagramPacket(datagramPacket, -1);
    }

    public static void logDatagramPacket(DatagramPacket datagramPacket, int n) {
        try {
            byte[] byArray = datagramPacket.getData();
            StringBuffer stringBuffer = new StringBuffer();
            if (n < 0) {
                n = byArray.length;
            }
            if (n > byArray.length) {
                n = byArray.length;
            }
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(byArray[i] + ".");
            }
            LogClient.log(stringBuffer.toString());
        }
        catch (Exception exception) {
            logger.debug("e> logDatagramPacket(): " + exception);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendLogMessage(String string) {
        try {
            if (LogClient.open() < 0) {
                return;
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(logSocket.getOutputStream());
            LogClient logClient = instance;
            synchronized (logClient) {
                outputStreamWriter.write(string);
                outputStreamWriter.write(END_OF_MESSAGE);
                outputStreamWriter.flush();
            }
        }
        catch (Exception exception) {
            if (++sendFailures >= 1) {
                logging = false;
                return;
            }
            logger.debug("sendLogMessage(" + string + "): " + exception);
        }
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.startsWith("logMessage:")) {
            LogClient.sendLogMessage(string.substring(11));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

