/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.util.Handler;
import elgato.infrastructure.util.LogClient;
import elgato.infrastructure.util.SystemOutHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class Logger {
    public static final int FATAL = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private static int level;
    private static boolean alwaysLogStackTrace;
    private static String[] enabledPatterns;
    private static Handler handler;
    private static boolean trackInstances;
    private final String name;

    Logger(String string) {
        this.name = this.removeCommonNamePrefixes(string);
    }

    private String removeCommonNamePrefixes(String string) {
        if (string.startsWith("elgato.infrastructure.")) {
            return string.substring("elgato.infrastructure.".length());
        }
        if (string.startsWith("elgato.measurement.")) {
            return string.substring("elgato.measurement.".length());
        }
        if (string.startsWith("elgato.")) {
            return string.substring("elgato.".length());
        }
        return string;
    }

    public static void setGlobalLevel(int n) {
        level = n;
    }

    public static int getGlobalLevel() {
        return level;
    }

    public static boolean isAlwaysLogStackTrace() {
        return alwaysLogStackTrace;
    }

    public static void setAlwaysLogStackTrace(boolean bl) {
        alwaysLogStackTrace = bl;
    }

    public static String[] getEnabledPatterns() {
        return enabledPatterns;
    }

    public static void setEnabledPatterns(String[] stringArray) {
        enabledPatterns = stringArray;
    }

    public static void setHandler(Handler handler) {
        Logger.handler = handler;
    }

    public void error(String string, Throwable throwable) {
        if (level >= 1) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.log("ERROR: ", string + "\n" + throwable.getMessage() + "\n" + stringWriter.toString());
        }
    }

    private boolean isEnabled(int n) {
        if (n > level) {
            return false;
        }
        if (enabledPatterns == null || enabledPatterns.length == 0) {
            return true;
        }
        for (int i = 0; i < enabledPatterns.length; ++i) {
            String string = enabledPatterns[i];
            if (this.name.indexOf(string) == -1) continue;
            return true;
        }
        return false;
    }

    public void error(String string) {
        LogClient.log("ERROR: " + this.name + " " + string);
        if (this.isEnabled(1)) {
            this.log("ERROR: ", string);
        }
    }

    public void warn(String string) {
        LogClient.log("WARN: " + this.name + " " + string);
        if (this.isEnabled(2)) {
            this.log("WARN", string);
        }
    }

    public void info(String string) {
        LogClient.log("INFO: " + this.name + " " + string);
        if (this.isEnabled(3)) {
            this.log("INFO", string);
        }
    }

    public void debug(String string) {
        LogClient.log("DEBUG: " + this.name + " " + string);
        if (this.isEnabled(4)) {
            this.log("DEBUG", string);
        }
    }

    public void keyPress(String string) {
        LogClient.log("KEYPRESS: " + this.name + " " + string);
        if (this.isKeyPressEnabled()) {
            this.log("KEYPRESS", string);
        }
    }

    public void instanceTrack(String string, String string2) {
        String string3 = string + " " + string2;
        LogClient.log("INSTANCE: " + this.name + string3);
        if (this.isInstanceTrackEnabled()) {
            this.log("INSTANCE", string3);
        }
    }

    public void instanceTrack(Object object, String string) {
        String string2 = this.removeCommonNamePrefixes(object.getClass().getName()) + "@" + Integer.toHexString(object.hashCode());
        this.instanceTrack(string2, string);
    }

    private void log(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(System.currentTimeMillis());
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.name);
        stringBuffer.append(' ');
        stringBuffer.append(string2);
        if (alwaysLogStackTrace) {
            StringWriter stringWriter = new StringWriter();
            new Exception("Stack trace").printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append('\n');
            stringBuffer.append((Object)stringWriter.getBuffer());
        }
        handler.publish(stringBuffer.toString());
    }

    public final boolean isDebugEnabled() {
        return this.isEnabled(4);
    }

    public final boolean isInfoEnabled() {
        return this.isEnabled(3);
    }

    public final boolean isKeyPressEnabled() {
        return this.isEnabled(4) || GlobalKeyManager.doDebugKeyTiming();
    }

    public final boolean isInstanceTrackEnabled() {
        return trackInstances || this.isEnabled(4);
    }

    static {
        Object object;
        String string = System.getProperty("Logger.level");
        level = string != null ? Integer.parseInt(string) : 3;
        Vector<String> vector = new Vector<String>();
        string = System.getProperty("Logger.enabledPatterns");
        if (string != null) {
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                vector.addElement(((StringTokenizer)object).nextToken());
            }
            enabledPatterns = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                Logger.enabledPatterns[i] = (String)vector.elementAt(i);
            }
        }
        alwaysLogStackTrace = (string = System.getProperty("Logger.alwaysLogStackTrace")) != null && string.equals("true");
        string = System.getProperty("Logger.instanceTrack");
        trackInstances = string != null && string.equals("true");
        object = System.getProperty("Logger.handler", "elgato.infrastructure.util.SystemOutHandler");
        try {
            handler = (Handler)Class.forName((String)object).newInstance();
        }
        catch (Exception exception) {
            handler = new SystemOutHandler();
            handler.publish("Could not instantiate correct handler. Using SystemOutHandler\n" + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

