/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.NetworkConfiguration;
import elgato.infrastructure.util.NetworkUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MulticastNetworkConfiguration
extends NetworkConfiguration {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$MulticastNetworkConfiguration == null ? (class$elgato$infrastructure$util$MulticastNetworkConfiguration = MulticastNetworkConfiguration.class$("elgato.infrastructure.util.MulticastNetworkConfiguration")) : class$elgato$infrastructure$util$MulticastNetworkConfiguration);
    private static final int RETURN_PACKET_SIZE = 1500;
    static final String REQUEST_HEADER = "DMC Multicast Command";
    static final String RESPONSE_HEADER = "DMC Multicast Alert";
    static final String KEY_DHCP = "bootp";
    static final String KEY_HOSTNAME = "hostname";
    static final String KEY_IP = "ip";
    static final String KEY_SUBNET_MASK = "subnet-mask";
    static final String KEY_GATEWAY = "gateway";
    static final String KEY_MAC_ADDRESS = "id";
    protected final String macAddress;
    static final int DMC_TALK_PORT = 2241;
    static final int DMC_LISTEN_PORT = 2242;
    static final String DMC_MULTICAST_TALK_ADDR = "224.0.15.1";
    static final String DMC_MULTICAST_LISTEN_ADDR = "224.0.15.2";
    static final String STUB_HOSTNAME = "0000A00000";
    static final String STUB_IP_ADDRESS = "1.1.1.1";
    static final String STUB_SUBNET_MASK = "255.255.255.255";
    static final String STUB_GATEWAY = "0.0.0.0";
    static final String STUB_BOOTP = "ON";
    static /* synthetic */ Class class$elgato$infrastructure$util$MulticastNetworkConfiguration;

    MulticastNetworkConfiguration(boolean bl, String string, String string2, String string3, String string4, String string5) {
        super(bl, string, string2, string3, string4);
        this.macAddress = string5;
    }

    public static NetworkConfiguration getMulticastNetworkConfiguration() throws IOException {
        String string = System.getProperty("server") == null && "true".equals(System.getProperty("stub")) ? MulticastNetworkConfiguration.generateStubResponse() : MulticastNetworkConfiguration.sendRequest(MulticastNetworkConfiguration.getQueryNetworkConfigurationCommand());
        return MulticastNetworkConfiguration.parseResponseIntoModel(string);
    }

    private static String sendRequest(String string) throws IOException {
        DatagramSocket datagramSocket = MulticastNetworkConfiguration.getReceiverSocket();
        MulticastNetworkConfiguration.sendCommand(string);
        String string2 = null;
        try {
            string2 = MulticastNetworkConfiguration.getResponse(datagramSocket);
            logger.debug("NETWORK CONFIG RESPONSE:\n" + string2);
            String string3 = string2;
            return string3;
        }
        catch (IOException iOException) {
            logger.error("Unexpected exception while reading a network configuration response", iOException);
            throw iOException;
        }
        finally {
            datagramSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendCommand(String string) throws IOException {
        MulticastSocket multicastSocket = new MulticastSocket(2241);
        try {
            InetAddress inetAddress = NetworkUtils.getInetAddress(DMC_MULTICAST_TALK_ADDR);
            byte[] byArray = string.getBytes();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 2241);
            logger.debug("NETWORK COMMAND:\n" + string);
            multicastSocket.send(datagramPacket);
        }
        finally {
            multicastSocket.close();
        }
    }

    private static DatagramSocket getReceiverSocket() throws IOException {
        MulticastSocket multicastSocket = new MulticastSocket(2242);
        InetAddress inetAddress = NetworkUtils.getInetAddress(DMC_MULTICAST_LISTEN_ADDR);
        multicastSocket.joinGroup(inetAddress);
        return multicastSocket;
    }

    private static String getResponse(DatagramSocket datagramSocket) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(new byte[1500], 1500);
        datagramSocket.receive(datagramPacket);
        String string = new String(datagramPacket.getData());
        return string;
    }

    static MulticastNetworkConfiguration parseResponseIntoModel(String string) {
        String string2;
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string3 = stringTokenizer.nextToken();
        if (!string3.equals(RESPONSE_HEADER)) {
            throw new IllegalStateException("Expected first line in response to be DMC Multicast Alert, but was " + string3);
        }
        while (stringTokenizer.hasMoreTokens() && (n = (string2 = stringTokenizer.nextToken()).indexOf(":")) != -1) {
            String string4 = string2.substring(0, n).trim();
            String string5 = string2.substring(n + 1).trim();
            hashtable.put(string4, string5);
        }
        return new MulticastNetworkConfiguration(hashtable.get(KEY_DHCP).equals(STUB_BOOTP), hashtable.get(KEY_HOSTNAME).toString(), hashtable.get(KEY_IP).toString(), hashtable.get(KEY_GATEWAY).toString(), hashtable.get(KEY_SUBNET_MASK).toString(), hashtable.get(KEY_MAC_ADDRESS).toString());
    }

    static String getQueryNetworkConfigurationCommand() {
        logger.debug("Building network config query...");
        StringBuffer stringBuffer = new StringBuffer();
        MulticastNetworkConfiguration.appendLine(stringBuffer, REQUEST_HEADER);
        MulticastNetworkConfiguration.appendLine(stringBuffer, "ip: " + NetworkUtils.getServerAddress().getHostAddress());
        MulticastNetworkConfiguration.appendLine(stringBuffer, "user: chris");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "password: chrischris");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "cmd:");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "send " + NetworkUtils.getLocalAddress().getHostAddress());
        logger.debug("Done building network config query.\n" + stringBuffer.toString());
        return stringBuffer.toString();
    }

    static void appendLine(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + "\n");
    }

    String getSaveNetworkConfigurationCommand() throws UnknownHostException {
        StringBuffer stringBuffer = new StringBuffer();
        MulticastNetworkConfiguration.appendLine(stringBuffer, REQUEST_HEADER);
        MulticastNetworkConfiguration.appendLine(stringBuffer, "id: " + this.getMacAddress());
        MulticastNetworkConfiguration.appendLine(stringBuffer, "user: chris");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "password: chrischris");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "cmd:");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "bootp " + this.getDhcpCommandString());
        MulticastNetworkConfiguration.appendLine(stringBuffer, "hostname " + this.getHostname());
        MulticastNetworkConfiguration.appendLine(stringBuffer, "ip " + this.getIpAddress());
        MulticastNetworkConfiguration.appendLine(stringBuffer, "subnet-mask " + this.getSubnetMask());
        MulticastNetworkConfiguration.appendLine(stringBuffer, "gateway " + this.getGateway());
        return stringBuffer.toString();
    }

    private String getMacAddress() {
        return this.macAddress;
    }

    String getDhcpCommandString() {
        return this.getDhcpEnabled().booleanValue() ? STUB_BOOTP : "OFF";
    }

    static String generateStubResponse() {
        StringBuffer stringBuffer = new StringBuffer();
        MulticastNetworkConfiguration.appendLine(stringBuffer, RESPONSE_HEADER);
        MulticastNetworkConfiguration.appendLine(stringBuffer, "mid: myMessageId");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "id: 00600c0017e5");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "reason: Command");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "hostname: 0000A00000");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "ip: 1.1.1.1");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "subnet-mask: 255.255.255.255");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "gateway: 0.0.0.0");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "dapi: 0x0000000f");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "sn: 0000A00000");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "location: unknown");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "product: Agilent Technologies Embedded Ethernet Controller");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "revision: ROM B.04.20 Arms Beta 1 Build 1, HW elgato:0x00000001");
        MulticastNetworkConfiguration.appendLine(stringBuffer, "bootp: ON");
        return stringBuffer.toString();
    }

    public void saveChanges() throws IOException {
        MulticastNetworkConfiguration.sendCommand(this.getSaveNetworkConfigurationCommand());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

