/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.util.FileNetworkConfiguration;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.StubNetworkConfiguration;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import java.io.IOException;

public abstract class NetworkConfiguration {
    private final Value dhcpEnabled = Value.createValue(Text.DHCP, true);
    private final Value hostname = Value.createValue(Text.Sys_Name, "localhost");
    private final Value ipAddress = Value.createIpAddressValue(Text.IP_Address, "127.0.0.1");
    private final Value gateway = Value.createIpAddressValue(Text.Gateway, "0.0.0.0");
    private final Value netmask = Value.createIpAddressValue(Text.Net_Mask, "255.255.255.0");

    protected NetworkConfiguration() {
    }

    protected NetworkConfiguration(boolean bl, String string, String string2, String string3, String string4) {
        this.checkForNullParameters(string, string2, string3, string4);
        this.initValues(bl, string, string2, string3, string4);
        this.hostname.setPalette(Palette.createHostName());
    }

    protected void initValues(boolean bl, String string, String string2, String string3, String string4) {
        this.setDhcpEnabled(bl);
        this.hostname.setValue(string);
        this.ipAddress.setValue(string2);
        this.gateway.setValue(string3);
        this.netmask.setValue(string4);
    }

    public Value getHostname() {
        return this.hostname;
    }

    public Value getIpAddress() {
        return this.ipAddress;
    }

    public Value getSubnetMask() {
        return this.netmask;
    }

    public Value getGateway() {
        return this.gateway;
    }

    public Value getDhcpEnabled() {
        return this.dhcpEnabled;
    }

    public void setDhcpEnabled(boolean bl) {
        this.dhcpEnabled.setValue(bl ? 1 : 0);
    }

    public String toString() {
        return "NETWORKCONFIG: HOST=" + this.getHostname() + ", IP=" + this.getIpAddress() + ", NETMASK=" + this.getSubnetMask() + ", GW=" + this.getGateway();
    }

    private void checkForNullParameters(String string, String string2, String string3, String string4) {
        if (string == null) {
            throw new IllegalArgumentException("precondition failed: hostName was null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("precondition failed: ipAddress was null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("precondition failed: gateway was null");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("precondition failed: netmask was null");
        }
    }

    public abstract void saveChanges() throws IOException;

    public static NetworkConfiguration create() {
        if (RuntimeConfiguration.isEmbedded()) {
            return new FileNetworkConfiguration();
        }
        return new StubNetworkConfiguration();
    }
}

