/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.valueobject.IpAddressValue;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetworkUtils {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$NetworkUtils == null ? (class$elgato$infrastructure$util$NetworkUtils = NetworkUtils.class$("elgato.infrastructure.util.NetworkUtils")) : class$elgato$infrastructure$util$NetworkUtils);
    public static final String PROPERTY_LOCAL_ADDRESS = "localAddress";
    public static final String PROPERTY_SERVER = "server";
    static /* synthetic */ Class class$elgato$infrastructure$util$NetworkUtils;

    public static InetAddress getLocalAddress() {
        return NetworkUtils.getInetAddress(System.getProperty(PROPERTY_LOCAL_ADDRESS));
    }

    public static InetAddress getServerAddress() {
        return NetworkUtils.getInetAddress(System.getProperty(PROPERTY_SERVER));
    }

    public static InetAddress getInetAddress(String string) {
        InetAddress inetAddress;
        try {
            if (string == null) {
                inetAddress = InetAddress.getLocalHost();
                if (logger.isDebugEnabled()) {
                    logger.debug("Using default local host address: " + inetAddress);
                }
            } else {
                if (IpAddressValue.isValidAddress(string)) {
                    InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
                    if (inetAddressArray.length != 1) {
                        throw new RuntimeException("Expected only one ip address to be returned. Received " + inetAddressArray.length);
                    }
                    inetAddress = inetAddressArray[0];
                } else {
                    logger.warn("Hostname " + string + " is not a valid ip address. Attempting hostname lookup.");
                    inetAddress = InetAddress.getByName(string);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Using user-specified local address: " + inetAddress + " (" + string + ")");
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("UnknownHostException: Couldn't get local address: " + unknownHostException);
        }
        return inetAddress;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

