/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

public class Queue {
    private Object[] elements;
    private int head;
    private int tail;
    private int size;

    public Queue(int n) {
        this.elements = new Object[n];
    }

    public synchronized int size() {
        return this.size;
    }

    public int capacity() {
        return this.elements.length;
    }

    public synchronized boolean enqueue(Object object) {
        if (object == null) {
            throw new NullPointerException("Attempt to enqueue null object");
        }
        if (this.size == this.elements.length) {
            return false;
        }
        this.elements[this.tail] = object;
        ++this.size;
        ++this.tail;
        if (this.tail == this.elements.length) {
            this.tail = 0;
        }
        return true;
    }

    public synchronized Object dequeue() {
        if (this.size == 0) {
            return null;
        }
        int n = this.head++;
        if (this.head == this.elements.length) {
            this.head = 0;
        }
        --this.size;
        return this.elements[n];
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Queue(cap=" + this.elements.length + ",size=" + this.size + ",head=" + this.head + ",tail=" + this.tail);
        stringBuffer.append(",elements={");
        for (int i = 0; i < this.elements.length; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.elements[i]);
        }
        stringBuffer.append("})");
        return stringBuffer.toString();
    }
}

