/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.StringTokenizer;

public class Resources {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$Resources == null ? (class$elgato$infrastructure$util$Resources = Resources.class$("elgato.infrastructure.util.Resources")) : class$elgato$infrastructure$util$Resources);
    private static Hashtable resourcesFiles = new Hashtable();
    private ResourceFile file;
    private String keyPrefix;
    private StringBuffer buffer = new StringBuffer();
    static /* synthetic */ Class class$elgato$infrastructure$util$Resources;

    private Resources(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        this.file = null;
        StringBuffer stringBuffer = new StringBuffer(64);
        for (int i = n; i > 0; --i) {
            InputStream inputStream;
            for (int j = 0; j < i; ++j) {
                stringBuffer.append('/');
                stringBuffer.append(stringArray[j]);
            }
            stringBuffer.append(".properties");
            String string2 = stringBuffer.toString();
            stringBuffer.setLength(0);
            ResourceFile resourceFile = (ResourceFile)resourcesFiles.get(string2);
            if (resourceFile == null && (inputStream = this.getClass().getResourceAsStream(string2)) != null) {
                try {
                    resourceFile = new ResourceFile(inputStream, string2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new MissingResourceException("IO error reading resources for " + string, string, null);
                }
                resourcesFiles.put(string2, resourceFile);
            }
            if (resourceFile == null) continue;
            for (int j = i; j < stringArray.length; ++j) {
                stringBuffer.append(stringArray[j]);
                stringBuffer.append('.');
            }
            this.keyPrefix = stringBuffer.toString();
            this.file = resourceFile;
            break;
        }
        if (this.file == null) {
            logger.error("Could not find resource for:" + string);
            throw new MissingResourceException("Couldn't find resources for " + string, string, null);
        }
    }

    public static Resources getResources(String string) {
        return new Resources(string);
    }

    private String fullKey(String string) {
        this.buffer.setLength(0);
        this.buffer.append(this.keyPrefix);
        this.buffer.append(string);
        return this.buffer.toString();
    }

    public String getString(String string, boolean bl) {
        return (String)this.file.get(this.fullKey(string), StringParser.instance, bl);
    }

    public String getString(String string) {
        return (String)this.file.get(this.fullKey(string), StringParser.instance, false);
    }

    public int getInt(String string) {
        return (Integer)this.file.get(this.fullKey(string), IntParser.instance, false);
    }

    public Color getColor(String string) {
        return (Color)this.file.get(this.fullKey(string), ColorParser.instance, false);
    }

    public Font getFont(String string) {
        return (Font)this.file.get(this.fullKey(string), FontParser.instance, false);
    }

    public HydroBorderPainterConfig getBorderConfig(String string) {
        return (HydroBorderPainterConfig)this.file.get(this.fullKey(string), BorderConfigParser.instance, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ResourceFile {
        private Properties bundle;
        private Hashtable table = new Hashtable(64);
        private final String filename;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResourceFile(InputStream inputStream, String string) throws IOException {
            this.filename = string;
            this.bundle = new Properties();
            try {
                this.bundle.load(inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (logger.isInfoEnabled()) {
                logger.info("Loaded resource file: " + string);
            }
        }

        Object get(String string, Parser parser, boolean bl) {
            Object object = this.table.get(string);
            if (object == null) {
                String string2 = this.bundle.getProperty(string);
                if (string2 == null) {
                    String string3 = "Resources property '" + string + "' not found in '" + this.filename + "'";
                    if (!bl) {
                        logger.error(string3);
                    } else {
                        logger.debug(string3);
                    }
                    throw new RuntimeException(string3);
                }
                object = parser.parse(string2);
                if (object == null) {
                    String string4 = "Resources property '" + string + "' unexpectedly parsed as null: '" + string2 + "' not found in '" + this.filename + "'";
                    if (!bl) {
                        logger.error(string4);
                    } else {
                        logger.debug(string4);
                    }
                    throw new RuntimeException(string4);
                }
                this.table.put(string, object);
                ((Hashtable)this.bundle).remove(string);
            }
            return object;
        }
    }

    private static final class BorderConfigParser
    implements Parser {
        static Parser instance = new BorderConfigParser();

        private BorderConfigParser() {
        }

        public Object parse(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.countTokens() != 6) {
                throw new RuntimeException("Bad border resource format: incorrect # of tokens (" + stringTokenizer.countTokens() + "): " + string);
            }
            return new HydroBorderPainterConfig((Color)ColorParser.instance.parse(stringTokenizer.nextToken()), (Integer)IntParser.instance.parse(stringTokenizer.nextToken()), new Color[]{(Color)ColorParser.instance.parse(stringTokenizer.nextToken()), (Color)ColorParser.instance.parse(stringTokenizer.nextToken()), (Color)ColorParser.instance.parse(stringTokenizer.nextToken()), (Color)ColorParser.instance.parse(stringTokenizer.nextToken())});
        }
    }

    private static final class FontParser
    implements Parser {
        static Parser instance = new FontParser();

        private FontParser() {
        }

        public Object parse(String string) {
            int n;
            int n2 = string.indexOf(44);
            if ((n2 | (n = string.indexOf(44, n2 + 1))) < 0) {
                throw new RuntimeException("Bad font resource format: need two commas: " + string);
            }
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1, n);
            String string4 = string.substring(n + 1);
            int n3 = 0;
            if (string3.indexOf(66) >= 0) {
                n3 |= 1;
            }
            if (string3.indexOf(73) >= 0) {
                n3 |= 2;
            }
            return new Font(string2, n3, Integer.parseInt(string4));
        }
    }

    private static final class ColorParser
    implements Parser {
        static Parser instance = new ColorParser();

        private ColorParser() {
        }

        public Object parse(String string) {
            return Color.decode(string);
        }
    }

    private static final class IntParser
    implements Parser {
        static Parser instance = new IntParser();

        private IntParser() {
        }

        public Object parse(String string) {
            return Integer.valueOf(string);
        }
    }

    private static final class StringParser
    implements Parser {
        static Parser instance = new StringParser();

        private StringParser() {
        }

        public Object parse(String string) {
            return string;
        }
    }

    private static interface Parser {
        public Object parse(String var1);
    }
}

