/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

public class RuntimeConfiguration {
    private static RuntimeConfiguration instance;

    boolean isEmbeddedUsingInstance() {
        return System.getProperty("os.arch").indexOf("arm") != -1;
    }

    public static boolean isEmbedded() {
        return RuntimeConfiguration.getInstance().isEmbeddedUsingInstance();
    }

    private static RuntimeConfiguration getInstance() {
        if (instance == null) {
            instance = new RuntimeConfiguration();
        }
        return instance;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").equals("Linux");
    }

    public static boolean runningInStubMode() {
        return "true".equals(System.getProperty("stub"));
    }

    public static boolean isUnitTestMode() {
        return "true".equals(System.getProperty("test"));
    }

    public static int getEndOfLine() {
        if (RuntimeConfiguration.isLinux()) {
            return 10;
        }
        return 13;
    }

    public static boolean showMessagesOnError() {
        return true;
    }

    public static void setTestInstance(RuntimeConfiguration runtimeConfiguration) {
        instance = runtimeConfiguration;
    }
}

