/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.SemaphoreTimeoutException;

public class Semaphore {
    private int value;

    public Semaphore() {
    }

    public Semaphore(int n) {
        this.value = n;
    }

    public synchronized void release() {
        ++this.value;
        this.notify();
    }

    public synchronized void pass() {
        try {
            while (this.value == 0) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted exception: " + interruptedException);
        }
        --this.value;
    }

    public synchronized void pass(long l) throws SemaphoreTimeoutException {
        long l2 = System.currentTimeMillis() + l;
        long l3 = l;
        try {
            while (this.value == 0 && l3 > 0L) {
                this.wait(l3);
                l3 = l2 - System.currentTimeMillis();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted exception: " + interruptedException);
        }
        if (l3 <= 0L) {
            throw new SemaphoreTimeoutException("Semaphore timed out (" + l + "ms)");
        }
        --this.value;
    }

    public synchronized void clear() {
        this.value = 0;
    }

    public String toString() {
        return "Semaphore(value=" + this.value + ")";
    }
}

