/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.IStorageDevice;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.SystemProcess;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;

public class StorageDevice
implements IStorageDevice {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$StorageDevice == null ? (class$elgato$infrastructure$util$StorageDevice = StorageDevice.class$("elgato.infrastructure.util.StorageDevice")) : class$elgato$infrastructure$util$StorageDevice);
    private String device;
    private String directory;
    private int capacity;
    private int used;
    private SystemProcess systemProcess;
    static /* synthetic */ Class class$elgato$infrastructure$util$StorageDevice;

    public StorageDevice(String string, String string2) throws InstantiationException {
        this(string, string2, false);
    }

    public StorageDevice(String string, String string2, boolean bl) throws InstantiationException {
        this.device = string;
        this.directory = string2;
        if (bl) {
            try {
                this.mount();
            }
            catch (Exception exception) {
                String string3 = "Cannot mount storage device with device='" + string + "' and directory='" + string2 + "'.";
                logger.error(string3);
                throw new InstantiationException(string3);
            }
        }
        this.initDevice();
    }

    public String getDevice() {
        return this.device;
    }

    public String getDirectory() {
        return this.directory;
    }

    private void initDevice() {
        try {
            if (!this.isMounted()) {
                this.capacity = -1;
                this.used = -1;
                return;
            }
            if (this.directory == null) {
                this.directory = FileSystemHelper.getInstance().getDirectoryFromDevice(this.device);
            }
            this.capacity = FileSystemHelper.getInstance().getDeviceStorageCapacity(this.device);
            this.used = FileSystemHelper.getInstance().getDeviceStorageUsed(this.device);
            return;
        }
        catch (Exception exception) {
            this.capacity = -1;
            this.used = -1;
            this.directory = "";
            return;
        }
    }

    public boolean isMounted() throws IOException, InterruptedException {
        return FileSystemHelper.getInstance().isMounted(this.device);
    }

    public boolean mount() throws IOException, InterruptedException {
        return this.mount(false);
    }

    public boolean mount(boolean bl) throws IOException, InterruptedException {
        if (this.isMounted()) {
            return true;
        }
        SystemProcess systemProcess = null;
        systemProcess = bl ? FileSystemHelper.getInstance().mount(this.device) : FileSystemHelper.getInstance().mount(this.device, this.directory);
        int n = systemProcess.getExitCode();
        if (n != 0) {
            if (systemProcess.exceptionOccurred()) {
                logger.error(systemProcess.getLogMessage(), systemProcess.getException());
            } else {
                logger.warn(systemProcess.getLogMessage());
            }
        }
        return n == 0;
    }

    public boolean unmount() throws IOException, InterruptedException {
        boolean bl;
        SystemProcess systemProcess = FileSystemHelper.getInstance().unmount(this.device);
        int n = systemProcess.getExitCode();
        if (n != 0) {
            if (systemProcess.exceptionOccurred()) {
                logger.error(systemProcess.getLogMessage(), systemProcess.getException());
            } else {
                logger.warn(systemProcess.getLogMessage());
            }
        }
        boolean bl2 = bl = n == 0;
        if (bl) {
            this.initDevice();
        }
        return bl;
    }

    public boolean hasStorageCapacity(long l) {
        return (long)(this.capacity - this.used * 1024) < l;
    }

    public boolean hasStorageCapacityForFile(String string) throws FileNotFoundException {
        long l = 0L;
        l = FileSystemHelper.getInstance().getFileSize(string);
        return this.hasStorageCapacity(l);
    }

    public SystemProcess format() throws IOException, InterruptedException {
        SystemProcess systemProcess;
        this.systemProcess = systemProcess = FileSystemHelper.getInstance().format(this.device);
        int n = systemProcess.getExitCode();
        if (n != 0) {
            if (systemProcess.exceptionOccurred()) {
                logger.error(systemProcess.getLogMessage(), systemProcess.getException());
            } else {
                logger.warn(systemProcess.getLogMessage());
            }
        }
        return systemProcess;
    }

    public String getSystemProcessOutput() {
        return this.getSystemProcessOutput(false);
    }

    public String getSystemProcessOutput(boolean bl) {
        if (this.systemProcess == null) {
            return "No system process available for storage device (" + this.device + ").";
        }
        if (bl) {
            return this.systemProcess.getOutputAsHTML();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.systemProcess.getProcessOutput();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((String)vector.elementAt(i));
            stringBuffer.append("\n");
        }
        Vector vector2 = this.systemProcess.getProcessErrorOutput();
        n = vector2.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((String)vector2.elementAt(i));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("dev: " + this.device);
        stringBuffer.append("; dir: " + this.directory);
        boolean bl = false;
        try {
            bl = this.isMounted();
        }
        catch (Exception exception) {
            stringBuffer.append("; trouble determining mount..aborting");
            return stringBuffer.toString();
        }
        stringBuffer.append("; mnt: " + bl);
        if (bl) {
            stringBuffer.append("; cap: " + this.capacity);
            stringBuffer.append("; used: " + this.used);
            stringBuffer.append("; free: " + (this.capacity - this.used));
            stringBuffer.append("; %used: " + (int)(100.0 * (double)this.used / (double)this.capacity) + "%");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

