/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.RuntimeConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class SystemProcess {
    public static final int EXCEPTION = -99999;
    static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$SystemProcess == null ? (class$elgato$infrastructure$util$SystemProcess = SystemProcess.class$("elgato.infrastructure.util.SystemProcess")) : class$elgato$infrastructure$util$SystemProcess);
    private String command;
    private int exitCode = -99999;
    private Vector processOutput;
    private Vector processErrorOutput;
    private Exception exception;
    private Hashtable storedValues;
    private Vector processOutputListeners;
    InputStream errStream = null;
    InputStream stdStream = null;
    BufferedInputStream stdBufStream = null;
    boolean stdOver = false;
    boolean errOver = false;
    private boolean captureProcessOutput = false;
    static /* synthetic */ Class class$elgato$infrastructure$util$SystemProcess;

    public SystemProcess(String string) {
        this.command = string;
    }

    public String getCommand() {
        return this.command;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Vector getAllOutput() {
        Vector vector = new Vector();
        try {
            int n;
            int n2;
            if (this.processErrorOutput != null) {
                n2 = this.processErrorOutput.size();
                for (n = 0; n < n2; ++n) {
                    vector.addElement(this.processErrorOutput.elementAt(n));
                }
            }
            if (this.processOutput != null) {
                n2 = this.processOutput.size();
                for (n = 0; n < n2; ++n) {
                    vector.addElement(this.processOutput.elementAt(n));
                }
            }
            return vector;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Vector getProcessOutput() {
        return this.processOutput;
    }

    public Vector getProcessErrorOutput() {
        return this.processErrorOutput;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setExitCode(int n) {
        this.exitCode = n;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean exceptionOccurred() {
        return this.exception != null;
    }

    private Vector buildProcessOutput(Process process) {
        return this.buildOutput(process.getInputStream());
    }

    private Vector buildProcessErrorOutput(Process process) {
        return this.buildOutput(process.getErrorStream());
    }

    private Vector buildOutput(InputStream inputStream) {
        Vector<String> vector = new Vector<String>(11);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                if (n == 10) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
        }
        return vector;
    }

    public void addProcessOutputListener(ProcessOutputListener processOutputListener) {
        if (this.processOutputListeners == null) {
            this.processOutputListeners = new Vector();
        }
        this.processOutputListeners.addElement(processOutputListener);
    }

    public void addOutput(String string) {
        if (this.processOutput == null) {
            this.processOutput = new Vector();
        }
        this.processOutput.addElement(string);
    }

    public void addErrorOutput(String string) {
        if (this.processErrorOutput == null) {
            this.processErrorOutput = new Vector();
        }
        this.processErrorOutput.addElement(string);
    }

    public boolean processOutputContains(String string) {
        return this.outputContains(this.processOutput, string);
    }

    public boolean processErrorOutputContains(String string) {
        return this.outputContains(this.processErrorOutput, string);
    }

    private boolean outputContains(Vector vector, String string) {
        if (vector == null) {
            return false;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)vector.elementAt(i);
            if (string2.indexOf(string) <= -1) continue;
            return true;
        }
        return false;
    }

    public int execute() {
        return this.execute(false);
    }

    void notifyProcessOutputListeners(String string, int n) {
        if (this.captureProcessOutput) {
            if (n == 0) {
                this.addOutput(string);
            } else {
                this.addErrorOutput(string);
            }
        }
        if (this.processOutputListeners == null) {
            return;
        }
        int n2 = this.processOutputListeners.size();
        for (int i = 0; i < n2; ++i) {
            ProcessOutputListener processOutputListener = (ProcessOutputListener)this.processOutputListeners.elementAt(i);
            if (n == 0) {
                processOutputListener.handleSystemProcessOutputLine(string);
                continue;
            }
            processOutputListener.handleSystemProcessErrorOutputLine(string);
        }
    }

    public int executeWithNotification(boolean bl) {
        return this.executeWithNotification(bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int executeWithNotification(boolean bl, InputStream inputStream) {
        block31: {
            IOException iOException2222;
            block29: {
                Object object;
                Process process = null;
                this.exception = null;
                this.exitCode = -99999;
                this.captureProcessOutput = bl;
                process = Runtime.getRuntime().exec(this.command);
                if (inputStream != null) {
                    int n;
                    object = new BufferedOutputStream(process.getOutputStream());
                    while ((n = inputStream.read()) != -1) {
                        ((BufferedOutputStream)object).write(n);
                    }
                    ((BufferedOutputStream)object).flush();
                    ((FilterOutputStream)object).close();
                }
                if (this.processOutputListeners == null) {
                    process.waitFor();
                    if (bl) {
                        this.processOutput = this.buildProcessOutput(process);
                        this.processErrorOutput = this.buildProcessErrorOutput(process);
                    } else {
                        this.processOutput = null;
                        this.processErrorOutput = null;
                    }
                } else {
                    this.stdStream = process.getInputStream();
                    this.errStream = process.getErrorStream();
                    object = new Thread(new ProcessOutputHandler());
                    ((Thread)object).start();
                    Thread thread = new Thread(new ProcessErrorOutputHandler());
                    thread.start();
                    Thread.yield();
                    while (!this.stdOver || !this.errOver) {
                    }
                }
                this.exitCode = process.exitValue();
                Object var7_9 = null;
                if (this.stdStream == null) break block29;
                try {
                    this.stdStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (this.errStream != null) {
                try {
                    this.errStream.close();
                }
                catch (IOException iOException2222) {}
            }
            break block31;
            {
                catch (IOException iOException3) {
                    IOException iOException42222;
                    logger.error("execute(" + bl + ")", iOException3);
                    this.exception = iOException3;
                    Object var7_10 = null;
                    if (this.stdStream != null) {
                        try {
                            this.stdStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (this.errStream != null) {
                        try {
                            this.errStream.close();
                        }
                        catch (IOException iOException42222) {}
                    }
                    break block31;
                }
                catch (InterruptedException interruptedException) {
                    IOException iOException52222;
                    logger.error("execute(" + bl + ")", interruptedException);
                    this.exception = interruptedException;
                    Object var7_11 = null;
                    if (this.stdStream != null) {
                        try {
                            this.stdStream.close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    if (this.errStream != null) {
                        try {
                            this.errStream.close();
                        }
                        catch (IOException iOException52222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException iOException62222;
                Object var7_12 = null;
                if (this.stdStream != null) {
                    try {
                        this.stdStream.close();
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                }
                if (this.errStream != null) {
                    try {
                        this.errStream.close();
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return this.exitCode;
    }

    public int execute(boolean bl) {
        return this.execute(bl, null);
    }

    public int execute(boolean bl, InputStream inputStream) {
        Process process = null;
        this.exception = null;
        this.exitCode = -99999;
        try {
            process = Runtime.getRuntime().exec(this.command);
            if (inputStream != null) {
                int n;
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(process.getOutputStream());
                while ((n = inputStream.read()) != -1) {
                    bufferedOutputStream.write(n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            process.waitFor();
            if (bl) {
                this.processOutput = this.buildProcessOutput(process);
                this.processErrorOutput = this.buildProcessErrorOutput(process);
            } else {
                this.processOutput = null;
                this.processErrorOutput = null;
            }
            this.exitCode = process.exitValue();
        }
        catch (IOException iOException) {
            logger.error("execute(" + bl + ")", iOException);
            this.exception = iOException;
        }
        catch (InterruptedException interruptedException) {
            logger.error("execute(" + bl + ")", interruptedException);
            this.exception = interruptedException;
        }
        return this.exitCode;
    }

    public int executeWithPipe(String string) {
        return this.executeWithPipe(string, false);
    }

    public int executeWithPipe(String string, boolean bl) {
        try {
            Process process = Runtime.getRuntime().exec(string);
            process.waitFor();
            if (process.exitValue() != 0) {
                return -1;
            }
            return this.execute(bl, process.getInputStream());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public void put(String string, Object object) {
        if (this.storedValues == null) {
            this.storedValues = new Hashtable();
        }
        this.storedValues.put(string, object);
    }

    public Object get(String string) {
        if (this.storedValues == null) {
            return null;
        }
        return this.storedValues.get(string);
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cmd:" + this.command);
        stringBuffer.append(";exit:" + this.exitCode);
        if (this.processOutput != null) {
            n2 = this.processOutput.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append("\n" + n + ": " + this.processOutput.elementAt(n));
            }
            stringBuffer.append("\n");
        }
        if (this.processErrorOutput != null) {
            n2 = this.processErrorOutput.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append("\ne> " + n + ": " + this.processErrorOutput.elementAt(n));
            }
            stringBuffer.append("\n");
        }
        if (this.exception != null) {
            stringBuffer.append("exception: " + this.exception);
        }
        return stringBuffer.toString();
    }

    public String getOutputAsHTML() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.processOutput != null) {
            n2 = this.processOutput.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append("<LI>");
                stringBuffer.append((String)this.processOutput.elementAt(n));
                stringBuffer.append("</LI>\n");
            }
        }
        if (this.processErrorOutput != null) {
            n2 = this.processErrorOutput.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append("<LI><i>");
                stringBuffer.append((String)this.processErrorOutput.elementAt(n));
                stringBuffer.append("</i></LI>\n");
            }
        }
        if (this.exception != null) {
            stringBuffer.append("<UL><LI>" + this.exception + "</LI></UL>");
        }
        return stringBuffer.toString();
    }

    public String getLogMessage() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cmd: " + this.command);
        stringBuffer.append("; exit code: " + this.exitCode);
        if (this.processOutput != null) {
            stringBuffer.append("; stdout: ");
            n2 = this.processOutput.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append("|" + n + ": " + this.processOutput.elementAt(n));
            }
        }
        if (this.processErrorOutput != null) {
            stringBuffer.append("; errout: ");
            n2 = this.processErrorOutput.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append("| " + n + ": " + this.processErrorOutput.elementAt(n));
            }
        }
        if (this.exception != null) {
            stringBuffer.append("; exception: " + this.exception);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ProcessOutputListener {
        public void handleSystemProcessOutputLine(String var1);

        public void handleSystemProcessErrorOutputLine(String var1);
    }

    private class ProcessOutputHandler
    implements Runnable {
        private ProcessOutputHandler() {
        }

        public void run() {
            this.handleProcessOutput();
        }

        private void handleProcessOutput() {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                int n = RuntimeConfiguration.getEndOfLine();
                SystemProcess.this.stdBufStream = new BufferedInputStream(SystemProcess.this.stdStream);
                while (!SystemProcess.this.stdOver) {
                    int n2 = SystemProcess.this.stdBufStream.read();
                    if (n2 == -1) {
                        SystemProcess.this.stdOver = true;
                        if (stringBuffer.length() <= 0) continue;
                        SystemProcess.this.notifyProcessOutputListeners(stringBuffer.toString(), 0);
                        continue;
                    }
                    if (n2 == n) {
                        SystemProcess.this.notifyProcessOutputListeners(stringBuffer.toString(), 0);
                        stringBuffer.setLength(0);
                        continue;
                    }
                    stringBuffer.append((char)n2);
                }
            }
            catch (Exception exception) {
                logger.warn("handleProcessOutput: " + exception);
            }
        }
    }

    private class ProcessErrorOutputHandler
    implements Runnable {
        private ProcessErrorOutputHandler() {
        }

        public void run() {
            this.handleProcessOutput();
        }

        private void handleProcessOutput() {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                int n = RuntimeConfiguration.getEndOfLine();
                while (!SystemProcess.this.errOver) {
                    int n2 = SystemProcess.this.errStream.read();
                    if (n2 == -1) {
                        SystemProcess.this.errOver = true;
                        if (stringBuffer.length() <= 0) continue;
                        SystemProcess.this.notifyProcessOutputListeners(stringBuffer.toString(), 1);
                        continue;
                    }
                    if (n2 == n) {
                        SystemProcess.this.notifyProcessOutputListeners(stringBuffer.toString(), 1);
                        stringBuffer.setLength(0);
                        continue;
                    }
                    stringBuffer.append((char)n2);
                }
            }
            catch (Exception exception) {
                logger.warn("handleProcessOutput: " + exception);
            }
        }
    }
}

