/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

public final class Timer {
    private static final int DUMP_FREQ = 10000;
    private static boolean enabled = "true".equals(System.getProperty("timer"));
    private final String name;
    private long nextDump;
    private long start;
    private long stop;
    private long total;
    private int count;
    private boolean started;

    public Timer(String string) {
        this.name = string;
        this.nextDump = System.currentTimeMillis() + 10000L;
    }

    public void start() {
        if (enabled) {
            if (this.started) {
                System.err.println("Error: Timer started twice: " + this);
                Thread.dumpStack();
                return;
            }
            this.started = true;
            this.start = System.currentTimeMillis();
        }
    }

    public void stop() {
        if (enabled) {
            if (!this.started) {
                System.err.println("Error: Timer stopped twice: " + this);
                Thread.dumpStack();
                return;
            }
            this.stop = System.currentTimeMillis();
            this.total += this.stop - this.start;
            this.started = false;
            ++this.count;
            this.maybeDump(this.stop);
        }
    }

    private void maybeDump(long l) {
        if (l > this.nextDump) {
            this.nextDump = l + 10000L;
            this.dump(l);
        }
    }

    public void dump() {
        if (enabled) {
            this.dump(System.currentTimeMillis());
        }
    }

    private void dump(long l) {
        System.out.println("Dump, now=" + l + " " + this.toString());
    }

    public int averageMicros() {
        if (this.count == 0) {
            return -1;
        }
        return (int)(this.total * 1000L / (long)this.count);
    }

    public long totalMillis() {
        return this.total;
    }

    public String toString() {
        return this.name + ": avg=" + this.averageMicros() + "us total=" + this.total + "ms count=" + this.count;
    }

    public static void setEnabled(boolean bl) {
        enabled = bl;
    }

    public static boolean isEnabled() {
        return enabled;
    }
}

