/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import elgato.infrastructure.util.FastMath;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.RuntimeConfiguration;
import java.awt.Dimension;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class UIHelper {
    private static final int[] TENS = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final int WINDOW_BORDER_WIDTH = 4;
    private static final int WINDOW_TITLEBAR_HEIGHT = 20;
    static /* synthetic */ Class class$elgato$infrastructure$util$UIHelper$DebugTimer;

    public static String formatFixed(int n, int n2) {
        int n3;
        char[] cArray = new char[12];
        long l = UIHelper.roundThousandScaledValue(n, n2);
        int n4 = 0;
        if (n < 0) {
            cArray[n4++] = 45;
        }
        int n5 = n2 > 3 ? 3 : n2;
        int n6 = 3 - n5;
        boolean bl = true;
        for (n3 = 9; n3 >= n6; --n3) {
            long l2 = l / (long)TENS[n3] % 10L;
            if (bl) {
                if (l2 == 0L) {
                    if (n3 != 3) continue;
                    cArray[n4++] = 48;
                    bl = false;
                    continue;
                }
                bl = false;
            }
            if (n3 == 2) {
                cArray[n4++] = 46;
            }
            cArray[n4++] = (char)(48L + (l2 < 0L ? -l2 : l2));
        }
        for (n3 = n5; n3 < n2; ++n3) {
            cArray[n4++] = 48;
        }
        return new String(cArray, 0, n4);
    }

    public static String formatFixedByPower(int n, int n2, int n3) {
        int n4;
        char[] cArray = new char[12];
        long l = UIHelper.roundScaledValue(n, n2, n3);
        int n5 = 0;
        if (n < 0) {
            cArray[n5++] = 45;
        }
        int n6 = n2 > n3 ? n3 : n2;
        int n7 = n3 - n6;
        boolean bl = true;
        for (n4 = 9; n4 >= n7; --n4) {
            long l2 = l / (long)TENS[n4] % 10L;
            if (bl) {
                if (l2 == 0L) {
                    if (n4 != n3) continue;
                    cArray[n5++] = 48;
                    bl = false;
                    continue;
                }
                bl = false;
            }
            if (n4 == n3 - 1) {
                cArray[n5++] = 46;
            }
            cArray[n5++] = (char)(48L + (l2 < 0L ? -l2 : l2));
        }
        if (n3 == 0 && n2 > 0) {
            cArray[n5++] = 46;
        }
        for (n4 = n6; n4 < n2; ++n4) {
            cArray[n5++] = 48;
        }
        return new String(cArray, 0, n5);
    }

    private static long roundThousandScaledValue(int n, int n2) {
        long l = n;
        if (n > 0) {
            if (n2 == 2) {
                l += 5L;
            } else if (n2 == 1) {
                l += 50L;
            } else if (n2 == 0) {
                l += 500L;
            }
        } else if (n < 0) {
            if (n2 == 2) {
                l += -5L;
            } else if (n2 == 1) {
                l += -50L;
            } else if (n2 == 0) {
                l += -500L;
            }
        }
        return l;
    }

    private static long roundScaledValue(int n, int n2, int n3) {
        if (n3 == 0) {
            return n;
        }
        long l = n;
        if (n > 0) {
            l = (long)((double)l + 5.0 * Math.pow(10.0, n3 - n2 - 1));
        } else if (n < 0) {
            l = (long)((double)l + -5.0 * Math.pow(10.0, n3 - n2 - 1));
        }
        return l;
    }

    public static long chipsToNanoseconds(int n) {
        return (long)n * 1000000L / 1228800L;
    }

    public static String hexDump(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 4 + n2);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            if (n4 == 0) {
                stringBuffer.append(UIHelper.zeroPadToHex(n3, 8));
                stringBuffer.append('|');
            }
            stringBuffer.append(' ');
            int n5 = byArray[n++] & 0xFF;
            stringBuffer.append(UIHelper.zeroPadToHex(n5, 2));
            if (++n4 != 16 && ++n3 != n2) continue;
            UIHelper.hexDumpDoEndOfLine(stringBuffer, byArray, n - n4, n4);
            n4 = 0;
        }
        return stringBuffer.toString();
    }

    private static void hexDumpDoEndOfLine(StringBuffer stringBuffer, byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = 16 - n2; n3 > 0; --n3) {
            stringBuffer.append("   ");
        }
        stringBuffer.append(" |");
        for (n3 = 0; n3 < n2; ++n3) {
            char c = (char)byArray[n + n3];
            if (c < ' ' || c >= '\u007f') {
                c = '.';
            }
            stringBuffer.append(c);
        }
        while (n3++ < 16) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("|\n");
    }

    private static String zeroPadToHex(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toHexString(n));
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public static String stripNewlines(String string) {
        if (string != null) {
            int n = string.indexOf("\n");
            if (n < 0) {
                return string;
            }
            string = n >= 1 && Character.isLetterOrDigit(string.charAt(n - 1)) ? string.replace('\n', ' ') : string.substring(0, n) + string.substring(n + 1);
            return UIHelper.stripNewlines(string);
        }
        return "";
    }

    public static String formatScientific(double d, int n) {
        double d2;
        int n2;
        if (d == Double.POSITIVE_INFINITY) {
            return "\u221e";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-\u221e";
        }
        if (Double.isNaN(d)) {
            return "NAN";
        }
        if (d == 0.0) {
            n2 = 0;
            d2 = 0.0;
        } else {
            float f = FastMath.float_log10((float)Math.abs(d));
            n2 = (int)Math.floor(f);
            d2 = d * Math.pow(10.0, -n2);
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setMaximumFractionDigits(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(numberFormat.format(d2));
        stringBuffer.append("E");
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    public static void split(String string, char c, String[] stringArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            int n3 = string.indexOf(c, n2);
            if (n3 < 0 || n == stringArray.length - 1) {
                stringArray[n] = string.substring(n2);
                ++n;
                break;
            }
            stringArray[n] = string.substring(n2, n3);
            n2 = n3 + 1;
        }
        while (n < stringArray.length) {
            stringArray[n] = "";
            ++n;
        }
    }

    public static String format(double d, int n) {
        DecimalFormat decimalFormat = new DecimalFormat();
        ((NumberFormat)decimalFormat).setMaximumFractionDigits(n);
        ((NumberFormat)decimalFormat).setMinimumFractionDigits(n);
        return decimalFormat.format(d);
    }

    public static int compareVersionNumbers(String string, String string2) {
        int[] nArray = UIHelper.parseVersion(string);
        int[] nArray2 = UIHelper.parseVersion(string2);
        int n = Math.min(nArray.length, nArray2.length);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i] - nArray2[i];
            if (n2 == 0) continue;
            return n2;
        }
        return nArray.length - nArray2.length;
    }

    private static int[] parseVersion(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return nArray;
    }

    public static void fixWindowLocation(Point point) {
        if (RuntimeConfiguration.isEmbedded()) {
            point.translate(-4, -20);
        }
    }

    public static void fixWindowSize(Dimension dimension) {
        if (!RuntimeConfiguration.isEmbedded()) {
            dimension.width += 8;
            dimension.height += 24;
        }
    }

    public static String formatMessage(String string, String[] stringArray) {
        int n = string.indexOf(37);
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(60);
            int n2 = 0;
            do {
                stringBuffer.append(string.substring(n2, n));
                char c = string.charAt(n + 1);
                String string2 = stringArray[c - 49];
                stringBuffer.append(string2);
                n2 = n + 2;
            } while (n >= 0 && (n = string.indexOf(37, n2)) >= 0);
            stringBuffer.append(string.substring(n2));
            return stringBuffer.toString();
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DebugTimer {
        private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$UIHelper$DebugTimer == null ? (class$elgato$infrastructure$util$UIHelper$DebugTimer = UIHelper.class$("elgato.infrastructure.util.UIHelper$DebugTimer")) : class$elgato$infrastructure$util$UIHelper$DebugTimer);
        private long start;
        private String name;
        private long stop = -1L;

        public DebugTimer(String string) {
            this.name = string;
            this.start = System.currentTimeMillis();
        }

        public String getMessage() {
            return this.name + " took " + this.getElapsedTime() + " milliseconds.";
        }

        public void stop() {
            this.stop = System.currentTimeMillis() - this.start;
            if (logger.isDebugEnabled()) {
                logger.debug(this.getMessage());
            }
        }

        private boolean isRunning() {
            return this.stop == -1L;
        }

        public long getElapsedTime() {
            if (this.isRunning()) {
                this.stop();
            }
            return this.stop;
        }
    }
}

