/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class VectorMap {
    private final Hashtable mapOfVectors = new Hashtable();

    public synchronized void addItem(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("Vector Map does not allow null keys");
        }
        if (object2 == null) {
            throw new NullPointerException("Vector Map does not allow null values");
        }
        Vector<Object> vector = (Vector<Object>)this.mapOfVectors.get(object);
        if (vector == null) {
            vector = new Vector<Object>();
            this.mapOfVectors.put(object, vector);
        }
        vector.addElement(object2);
    }

    public synchronized Vector getItems(Object object) {
        Vector vector = (Vector)this.mapOfVectors.get(object);
        return vector == null ? new Vector(0) : vector;
    }

    public synchronized Object removeItem(Object object, Object object2) {
        Vector vector = this.getItems(object);
        int n = vector.indexOf(object2);
        if (n != -1) {
            vector.removeElementAt(n);
            this.removeVectorIfEmpty(object, vector);
            return object2;
        }
        return null;
    }

    public synchronized void removeAll(Object object) {
        this.mapOfVectors.remove(object);
    }

    private void removeVectorIfEmpty(Object object, Vector vector) {
        if (vector.size() == 0) {
            this.mapOfVectors.remove(object);
        }
    }

    public synchronized Enumeration getKeys() {
        return this.mapOfVectors.keys();
    }

    public synchronized int size() {
        return this.mapOfVectors.size();
    }

    public synchronized boolean equals(Object object) {
        return ((Object)this.mapOfVectors).equals(((VectorMap)object).mapOfVectors);
    }

    public synchronized boolean contains(Object object) {
        boolean bl = false;
        Enumeration enumeration = this.mapOfVectors.elements();
        while (enumeration.hasMoreElements() && !bl) {
            Vector vector = (Vector)enumeration.nextElement();
            bl = vector.contains(object);
        }
        return bl;
    }
}

