/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util.chanstd;

import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.BandSegment;
import elgato.infrastructure.util.chanstd.ChannelFwd;
import elgato.infrastructure.util.chanstd.ChannelRev;

public class AbstractBandSegment
implements BandSegment {
    private final long bandBaseFwdFrequency;
    private final long bandBaseRevFrequency;
    private final long channelBandWidth;
    private final int startChannelNumber;
    private final int endChannelNumber;
    private final int channelOffset;
    private final long startFrequencyFwd;
    private final long endFrequencyFwd;
    private final long startFrequencyRev;
    private final long endFrequencyRev;

    protected AbstractBandSegment(long l, long l2, long l3, int n, int n2, int n3) {
        this(l, l2, l3, n, n2, n3, Text.Fwd, Text.Rev);
    }

    protected AbstractBandSegment(long l, long l2, long l3, int n, int n2, int n3, String string, String string2) {
        this.bandBaseFwdFrequency = l;
        this.bandBaseRevFrequency = l2;
        this.channelBandWidth = l3;
        this.startChannelNumber = n;
        this.endChannelNumber = n2;
        this.channelOffset = n3;
        long l4 = this.getChannelBandWidth() / 2L;
        this.startFrequencyFwd = new ChannelFwd(n, this, string).getCenterFrequency() - l4;
        this.endFrequencyFwd = new ChannelFwd(n2, this, string).getCenterFrequency() + l4;
        this.startFrequencyRev = new ChannelRev(n, this, string2).getCenterFrequency() - l4;
        this.endFrequencyRev = new ChannelRev(n2, this, string2).getCenterFrequency() + l4;
    }

    public long getBandBaseFwdFrequency() {
        return this.bandBaseFwdFrequency;
    }

    public long getBandBaseRevFrequency() {
        return this.bandBaseRevFrequency;
    }

    public int getStartChannelNumber() {
        return this.startChannelNumber;
    }

    public int getEndChannelNumber() {
        return this.endChannelNumber;
    }

    public long getStartFreqFwd() {
        long l = this.getChannelBandWidth() / 2L;
        return this.startFrequencyFwd + l;
    }

    public long getEndFreqFwd() {
        long l = this.getChannelBandWidth() / 2L;
        return this.endFrequencyFwd - l;
    }

    public double frequencyToChannel(long l) {
        double d = -1.0;
        if (l <= this.endFrequencyFwd && l >= this.startFrequencyFwd) {
            d = ((double)l - (double)this.getBandBaseFwdFrequency()) / (double)this.getChannelBandWidth() + (double)this.getChannelOffset();
        } else if (l <= this.endFrequencyRev && l >= this.startFrequencyRev) {
            d = ((double)l - (double)this.getBandBaseRevFrequency()) / (double)this.getChannelBandWidth() + (double)this.getChannelOffset();
        } else {
            throw new IllegalArgumentException("Invalid frequency for this License: " + l);
        }
        return d;
    }

    public long getChannelBandWidth() {
        return this.channelBandWidth;
    }

    public int getChannelOffset() {
        return this.channelOffset;
    }

    public boolean isFrequencyInBandSegment(long l) {
        return l >= this.startFrequencyFwd && l <= this.endFrequencyFwd || l >= this.startFrequencyRev && l <= this.endFrequencyRev;
    }

    public boolean isFrequencyFwdChannel(long l) {
        return l >= this.startFrequencyFwd && l <= this.endFrequencyFwd;
    }
}

