/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util.chanstd;

import elgato.infrastructure.util.chanstd.BandSegment;
import elgato.infrastructure.util.chanstd.ChannelFwd;
import elgato.infrastructure.util.chanstd.ChannelNeutral;
import elgato.infrastructure.util.chanstd.ChannelRev;
import elgato.infrastructure.util.chanstd.IChannel;
import java.text.NumberFormat;

public abstract class AbstractChannel
implements IChannel {
    private static final NumberFormat channelFormat = NumberFormat.getInstance();
    private final double channelNumber;
    private final BandSegment bandSegment;

    protected AbstractChannel(double d, BandSegment bandSegment) {
        this.channelNumber = d;
        this.bandSegment = bandSegment;
    }

    public double getChannelNumber() {
        return this.channelNumber;
    }

    protected String getChannelNumberString() {
        return channelFormat.format(this.channelNumber);
    }

    public long getCenterFrequency() {
        return (long)((double)this.getBandWidth() * (this.channelNumber - (double)this.bandSegment.getChannelOffset()) + (double)this.getBandBaseFrequency());
    }

    protected abstract long getBandBaseFrequency();

    private long getBandWidth() {
        return this.bandSegment.getChannelBandWidth();
    }

    public BandSegment getBandSegment() {
        return this.bandSegment;
    }

    public IChannel convertToReverse(String string) {
        return new ChannelRev(this.channelNumber, this.bandSegment, string);
    }

    public IChannel convertToForward(String string) {
        return new ChannelFwd(this.channelNumber, this.bandSegment, string);
    }

    public IChannel convertToNeutral() {
        return new ChannelNeutral(this.channelNumber, this.bandSegment);
    }

    static {
        channelFormat.setMaximumFractionDigits(3);
        channelFormat.setGroupingUsed(false);
    }
}

