/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.util.chanstd;

import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.BandNotFoundException;
import elgato.infrastructure.util.chanstd.BandSegment;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.util.chanstd.Bands;
import elgato.infrastructure.util.chanstd.ChannelFwd;
import elgato.infrastructure.util.chanstd.IChannel;
import elgato.infrastructure.util.chanstd.InvalidChannelException;
import elgato.infrastructure.util.chanstd.InvalidFrequencyException;
import elgato.measurement.acp.ACPFormat;
import elgato.measurement.channelScanner.ChannelScannerFormat;

public final class Band {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$util$chanstd$Band == null ? (class$elgato$infrastructure$util$chanstd$Band = Band.class$("elgato.infrastructure.util.chanstd.Band")) : class$elgato$infrastructure$util$chanstd$Band);
    private static final int INVALID_CHANNEL_NUMBER = -1;
    private final String strVal;
    private final String shortLabel;
    private final String miniLabel;
    private final BandSegment[] bandSegments;
    private final ChannelScannerFormat channelScannerFormat;
    private final ACPFormat acpFormat;
    private final int channelOffset;
    private final boolean forwardAndReverseSameFrequencies;
    private final int defaultChannel;
    private final int minChannel;
    private final int maxChannel;
    private final int technologyType;
    private final String fwdUnitLabel;
    private final String revUnitLabel;
    static /* synthetic */ Class class$elgato$infrastructure$util$chanstd$Band;

    Band(String string, String string2, String string3, int n, BandSegment[] bandSegmentArray, ChannelScannerFormat channelScannerFormat, ACPFormat aCPFormat, int n2, int n3) {
        this(string, string2, string3, n, bandSegmentArray, channelScannerFormat, aCPFormat, n2, n3, Text.Fwd, Text.Rev);
    }

    Band(String string, String string2, String string3, int n, BandSegment[] bandSegmentArray, ChannelScannerFormat channelScannerFormat, ACPFormat aCPFormat, int n2, int n3, String string4, String string5) {
        this.strVal = string;
        this.channelOffset = n;
        this.shortLabel = string2;
        this.miniLabel = string3;
        this.bandSegments = bandSegmentArray;
        this.channelScannerFormat = channelScannerFormat;
        this.acpFormat = aCPFormat;
        this.defaultChannel = n2;
        this.technologyType = n3;
        this.fwdUnitLabel = string4;
        this.revUnitLabel = string5;
        BandSegment bandSegment = bandSegmentArray[0];
        this.forwardAndReverseSameFrequencies = bandSegment.getBandBaseFwdFrequency() == bandSegment.getBandBaseRevFrequency();
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        BandSegment bandSegment2 = null;
        BandSegment bandSegment3 = null;
        for (int i = 0; i < bandSegmentArray.length; ++i) {
            BandSegment bandSegment4 = bandSegmentArray[i];
            if (bandSegment4.getStartChannelNumber() < n4) {
                n4 = bandSegment4.getStartChannelNumber();
                bandSegment2 = bandSegment4;
            }
            if (bandSegment4.getEndChannelNumber() <= n5) continue;
            n5 = bandSegment4.getEndChannelNumber();
            bandSegment3 = bandSegment4;
        }
        if (bandSegment2 == null) {
            throw new RuntimeException("Can't happen! Must have a band segment! (no min)");
        }
        if (bandSegment3 == null) {
            throw new RuntimeException("Can't happen! Must have a band segment! (no max)");
        }
        this.minChannel = n4;
        this.maxChannel = n5;
    }

    public IChannel getDefaultChannel() {
        try {
            if (this.defaultChannel != -1) {
                return this.getChannelFwdByChannelNumber(this.defaultChannel);
            }
            return this.getChannelFwdByChannelNumber(this.minChannel);
        }
        catch (InvalidChannelException invalidChannelException) {
            throw new RuntimeException("Could not get default channel: " + this.defaultChannel);
        }
    }

    public IChannel getClosestChannel(double d) {
        IChannel iChannel;
        double d2 = 2.147483647E9;
        int n = 1;
        int n2 = 0;
        try {
            iChannel = this.getChannelFwdByChannelNumber(d);
        }
        catch (InvalidChannelException invalidChannelException) {
            double d3 = 0.0;
            for (int i = 0; i < this.bandSegments.length; ++i) {
                int n3;
                BandSegment bandSegment = this.bandSegments[i];
                int n4 = bandSegment.getStartChannelNumber();
                d3 = Math.abs((double)n4 - d);
                if (d3 < d2) {
                    d2 = d3;
                    n = n4;
                    n2 = i;
                }
                if (!((d3 = Math.abs((double)(n3 = bandSegment.getEndChannelNumber()) - d)) < d2)) continue;
                d2 = d3;
                n = n3;
                n2 = i;
            }
            iChannel = this.findChannelFwdByChannelNumber(n, n2);
        }
        return iChannel;
    }

    private IChannel findChannelFwdByChannelNumber(double d) {
        for (int i = 0; i < this.bandSegments.length; ++i) {
            BandSegment bandSegment = this.bandSegments[i];
            if (!(d >= (double)bandSegment.getStartChannelNumber()) || !(d <= (double)bandSegment.getEndChannelNumber())) continue;
            return new ChannelFwd(d, bandSegment, this.fwdUnitLabel);
        }
        return null;
    }

    private IChannel findChannelFwdByChannelNumber(double d, int n) {
        BandSegment bandSegment = this.bandSegments[n];
        if (d >= (double)bandSegment.getStartChannelNumber() && d <= (double)bandSegment.getEndChannelNumber()) {
            return new ChannelFwd(d, bandSegment, this.fwdUnitLabel);
        }
        return null;
    }

    public IChannel getChannelFwdByChannelNumber(double d) throws InvalidChannelException {
        IChannel iChannel = this.findChannelFwdByChannelNumber(d);
        if (iChannel == null) {
            throw new InvalidChannelException("Channel number " + d + " not valid for " + this.toString());
        }
        return iChannel;
    }

    public IChannel getChannelRevByChannelNumber(double d) throws InvalidChannelException {
        return this.getChannelFwdByChannelNumber(d).convertToReverse(this.getChannelRevUnitLabel());
    }

    public IChannel getChannelNeutralByChannelNumber(double d) throws InvalidChannelException {
        return this.getChannelFwdByChannelNumber(d).convertToNeutral();
    }

    public final String getChannelFwdUnitLabel() {
        return this.fwdUnitLabel;
    }

    public final String getChannelRevUnitLabel() {
        return this.revUnitLabel;
    }

    public int getNextChannel(double d) {
        int n = (int)d;
        if (n >= this.maxChannel) {
            return this.minChannel;
        }
        if (this.findChannelFwdByChannelNumber(++n) != null) {
            return n;
        }
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.bandSegments.length; ++i) {
            BandSegment bandSegment = this.bandSegments[i];
            int n3 = bandSegment.getStartChannelNumber();
            if (n3 < n || n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public int getPrevChannel(double d) {
        int n = (int)d;
        if (n <= this.minChannel) {
            return this.maxChannel;
        }
        if (d % 1.0 == 0.0) {
            --n;
        }
        if (this.findChannelFwdByChannelNumber(n) != null) {
            return n;
        }
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < this.bandSegments.length; ++i) {
            BandSegment bandSegment = this.bandSegments[i];
            int n3 = bandSegment.getEndChannelNumber();
            if (n3 > n || n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public IChannel getMaxChannel() {
        try {
            return this.getChannelFwdByChannelNumber(this.maxChannel);
        }
        catch (InvalidChannelException invalidChannelException) {
            throw new RuntimeException("Could not get max channel: " + this.maxChannel);
        }
    }

    public BandSegment[] getBandSegments() {
        return this.bandSegments;
    }

    public final String toString() {
        return this.shortLabel;
    }

    public final String getMiniLabel() {
        return this.miniLabel;
    }

    public double convertFrequencyToChannelNumber(long l) throws InvalidFrequencyException {
        BandSegment bandSegment;
        int n;
        double d = -1.0;
        double[] dArray = new double[this.bandSegments.length];
        for (n = 0; n < this.bandSegments.length; ++n) {
            Double d2;
            int n2;
            bandSegment = this.bandSegments[n];
            if (!bandSegment.isFrequencyInBandSegment(l) || (float)(n2 = (d2 = new Double(d = bandSegment.frequencyToChannel(l))).intValue()) != d2.floatValue()) continue;
            return d;
        }
        for (n = 0; n < this.bandSegments.length; ++n) {
            bandSegment = this.bandSegments[n];
            if (d != -1.0 || !bandSegment.isFrequencyInBandSegment(l)) continue;
            d = bandSegment.frequencyToChannel(l);
        }
        if (d == -1.0) {
            throw new InvalidFrequencyException("Frequency: " + l + " converted to bad channel number for band: " + this.toString());
        }
        return d;
    }

    public boolean isFrequencyFwdChannel(long l) {
        boolean bl = false;
        for (int i = 0; i < this.bandSegments.length; ++i) {
            BandSegment bandSegment = this.bandSegments[i];
            if (!bandSegment.isFrequencyFwdChannel(l)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static final int getNumBands() {
        return Bands.getBands().size();
    }

    public static Band[] getBands() {
        Object[] objectArray = new Band[Bands.getBands().size()];
        Bands.getBands().copyInto(objectArray);
        return objectArray;
    }

    public static Band getBandByIndex(int n) throws BandNotFoundException {
        if (n < 0 || n > Bands.getBands().size()) {
            throw new BandNotFoundException("Band with an index of " + n + " not found");
        }
        return (Band)Bands.getBands().elementAt(n);
    }

    public static Band getCurrentBand(BandSelector bandSelector) {
        return Band.getCurrentBand(bandSelector.getCurrentBandIndex());
    }

    public static Band getCurrentBand(int n) {
        Band band;
        try {
            band = Band.getBandByIndex(n);
        }
        catch (BandNotFoundException bandNotFoundException) {
            band = Band.getDefaultBandAndLogError(bandNotFoundException);
        }
        return band;
    }

    private static Band getDefaultBandAndLogError(Exception exception) {
        logger.error("No channel standard available using default", exception);
        return Bands.BAND_US_PCS;
    }

    public String getLongName() {
        return this.strVal;
    }

    public static long getCurrentBandChannelWidth(BandSelector bandSelector) {
        return Band.getBandChannelWidth(bandSelector.getCurrentBandIndex());
    }

    public static long getBandChannelWidth(int n) {
        return Band.getCurrentBand(n).getBandSegments()[0].getChannelBandWidth();
    }

    public String getChannelScannerFormatLabel() {
        return this.channelScannerFormat.getLongLabel();
    }

    public ChannelScannerFormat getChannelScannerFormat() {
        return this.channelScannerFormat;
    }

    public ACPFormat getACPFormat() {
        return this.acpFormat;
    }

    public int getChannelOffset() {
        return this.channelOffset;
    }

    public boolean isForwardAndReverseSameFrequencies() {
        return this.forwardAndReverseSameFrequencies;
    }

    public int getTechnologyType() {
        return this.technologyType;
    }

    public long getStartFwdFrequency() {
        long l = Long.MAX_VALUE;
        BandSegment bandSegment = null;
        for (int i = 0; i < this.bandSegments.length; ++i) {
            BandSegment bandSegment2 = this.bandSegments[i];
            if (bandSegment2.getStartFreqFwd() >= l) continue;
            l = bandSegment2.getStartFreqFwd();
            bandSegment = bandSegment2;
        }
        if (bandSegment == null) {
            throw new RuntimeException("Can't happen! Must have a band segment! (no min)");
        }
        return l;
    }

    public long getEndFwdFrequency() {
        long l = Long.MIN_VALUE;
        BandSegment bandSegment = null;
        for (int i = 0; i < this.bandSegments.length; ++i) {
            BandSegment bandSegment2 = this.bandSegments[i];
            if (bandSegment2.getEndFreqFwd() <= l) continue;
            l = bandSegment2.getEndFreqFwd();
            bandSegment = bandSegment2;
        }
        if (bandSegment == null) {
            throw new RuntimeException("Can't happen! Must have a band segment! (no min)");
        }
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

