/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.valueobject;

import elgato.infrastructure.valueobject.Value;

public class IntegerValue
extends Value {
    protected IntegerValue(String string, String string2, int n) {
        super(string, string2, new Integer(n));
    }

    protected IntegerValue(String string, int n) {
        this(string, (String)null, n);
    }

    protected IntegerValue(String string, boolean bl) {
        this(string, bl ? 1 : 0);
    }

    public String toString() {
        return this.getValueObject().toString();
    }

    public int intValue() {
        return this.castedValue();
    }

    public long longValue() {
        return this.intValue();
    }

    public boolean booleanValue() {
        return this.intValue() != 0;
    }

    public void setValue(String string) {
        this.changeValue(Integer.parseInt(string));
    }

    public void setValue(int n) {
        this.changeValue(n);
    }

    public void setValue(long l) {
        this.changeValue((int)l);
    }

    private void changeValue(int n) {
        this.changeValue(new Integer(n));
    }

    public boolean isValid(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private Integer castedValue() {
        return (Integer)this.getValueObject();
    }

    public boolean isValid() {
        return this.isValid(this.toString());
    }
}

