/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.valueobject;

import elgato.infrastructure.valueobject.Value;

public class LongValue
extends Value {
    public LongValue(String string, long l) {
        super(string, new Long(l));
    }

    public void setValue(String string) {
        this.changeValue(Long.parseLong(string));
    }

    public void setValue(int n) {
        this.changeValue(n);
    }

    public void setValue(long l) {
        this.changeValue(l);
    }

    public boolean isValid(String string) {
        try {
            Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public int intValue() {
        return this.castedValue() == null ? 0 : this.castedValue().intValue();
    }

    public long longValue() {
        return this.castedValue() == null ? 0L : this.castedValue();
    }

    public boolean booleanValue() {
        return this.longValue() != 0L;
    }

    public boolean isValid() {
        return true;
    }

    public int hashCode() {
        return this.intValue() + this.getLabel().hashCode();
    }

    public String toString() {
        return this.getValueObject().toString();
    }

    private void changeValue(long l) {
        this.changeValue(new Long(l));
    }

    protected Long castedValue() {
        return (Long)this.getValueObject();
    }
}

