/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.valueobject;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.units.RelativeFactorConversion;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;

public class PercentValueListener
implements ValueListener {
    private final LongActuator actuator;
    private final LongActuator otherActuator;
    private final int roundFactor;
    protected final String listenerName;

    private PercentValueListener(LongActuator longActuator, LongActuator longActuator2, int n, String string) {
        this.actuator = longActuator;
        this.roundFactor = n;
        this.otherActuator = longActuator2;
        this.listenerName = string;
        this.valueChanged(null);
    }

    public static PercentValueListener createTenPercentValueListener(LongActuator longActuator, String string) {
        return new PercentValueListener(longActuator, null, 10, string);
    }

    public static PercentValueListener createOnePercentValueListener(LongActuator longActuator, String string) {
        return new PercentValueListener(longActuator, null, 100, string);
    }

    public static PercentValueListener createTenPercentValueListener(LongActuator longActuator, LongActuator longActuator2, String string) {
        return new PercentValueListener(longActuator, longActuator2, 10, string);
    }

    public static PercentValueListener createOnePercentValueListener(LongActuator longActuator, LongActuator longActuator2, String string) {
        return new PercentValueListener(longActuator, longActuator2, 100, string);
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public void valueChanged(ValueInterface valueInterface) {
        int n = this.calcIncrement();
        this.actuator.setIncrement(n);
        if (this.otherActuator != null) {
            this.otherActuator.setIncrement(n);
        }
    }

    private int calcIncrement() {
        int n;
        if (this.otherActuator != null) {
            n = (int)(this.actuator.longValue() - this.otherActuator.longValue());
            if (n < 0) {
                n = -n;
            }
        } else {
            n = this.actuator.intValue();
        }
        return RelativeFactorConversion.calculateTruncatedPercentIncrement(n, this.roundFactor);
    }
}

